
/*

   nightview CGI interface

   It read data from a standard input (POST method) and redirect its
   to the nightviewd or telescoped over local socket

  $Id: nightview-cgi.c,v 1.5 2006-11-29 23:04:15 hroch Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "nightview.h"

#define LEN 2048

extern char *undecode(char *);
extern char *get_data(char *,int, char *, char *);
extern char *send_to_socket(char *,int,char *);

int main(int argc, char *argv[])
{
  int i;
  int content_length = -1;
  int method = 0;
  char *request_method = "";
  char *content_type = "";
  int type = 0;
  char *content;
  char *c, *response;
  char name[LEN],value[LEN];

  if( (c = getenv("CONTENT_LENGTH")) )
    if( sscanf(c,"%d",&i) == 1 )
      content_length = i;

  if( (request_method = getenv("REQUEST_METHOD")) )
    if( strcmp(request_method,"POST") == 0 )
      method = 1;
    
  if( (content_type = getenv("CONTENT_TYPE")) )
    if( strcmp(content_type,"application/x-www-form-urlencoded") == 0 )
      type = 1;

  /* print response */
  if( content_length > 0 && method == 1 && type == 1 ) {

    printf("Content-type: text/xml\r\n\r\n");
    printf("<?xml version=\"1.0\"?>\r\n");
    printf("<status>\r\n");

    /* regular response */    
    if( (content = malloc(content_length+1)) == NULL ) {
      syslog(LOG_ERR,"Memory for content can't be allocated.\n");
      return(1);
    }
    if( (i = fread(content,content_length,1,stdin)) != 1 ) {
      free(content);
      syslog(LOG_ERR,"Input data read error: %m data_len=%d\n",i);
      return(1);
    }
    content[content_length] = '\0';

#ifdef DEBUG
    printf("<debug>%s</debug>\r\n",content);
#endif

    c = undecode(content);
#ifdef DEBUG
      printf("<debug>content: %s\n</debug>",c);
      syslog(LOG_ERR,"content: %s\n",c);
#endif
    /* run actions */
    while( (c = get_data(c,LEN,name,value)) ) {

#ifdef DEBUG
      printf("<debug>%s %s\n</debug>",name,value);
      syslog(LOG_ERR,"%s %s\n",name,value);
#endif

      if( strcmp(name,"telescope") == 0 ) {
	if( (response = send_to_socket(MOUNT_SHOCK,LEN,value)))
	  printf("<telescope>%s</telescope>\r\n",response);
	free(response);
      }

      if( strcmp(name,"camera") == 0 ) {
	if( (response = send_to_socket(NIGHT_SHOCK,LEN,value)))
	  printf("<camera>%s</camera>\r\n",response);
	free(response);
      }
    }

    /* clear input data and variables */
    free(content);
    content_length = -1;
    method = 0;
    type = 0;

    printf("</status>\r\n");
    fclose(stdout);
  }

  else {
    
    /* an error */
    printf("Content-type: text/xml\r\n\r\n");
    printf("<?xml version=\"1.0\"?>\r\n");
    printf("<status>\r\n");
    printf("<error>\r\n");
    printf("<description>An error occurred.</description>\r\n");
    printf("<title>Check following:</title>\r\n");
    printf("<item>the CONTENT_LENGTH environment variable unspecified by your http server</item>\r\n");
    printf("<item>the REQUEST_METHOD environment variable not set to POST</item>\r\n");
    printf("<item>the CONTENT_TYPE isn't 'application/x-www-form-urlencoded'</item>\r\n");
    printf("</error>\r\n");
    printf("</status>\r\n");
    }

  return(0);
}

char h2c(char a)
{
  char i;

  if( a >= 'A' )
    i = a - 'A' + 10;
  else
    i = a - '0';

  return(i);
}


/* get next NAME=VALUE from data */
char *undecode(char *content)
{
  int i,j;

  /* interpretation the hexadecimal values %HH */
  i = 0;
  j = 0;
  while( content[j] != '\0' ) {

    if( content[j] != '%' ) {
      content[i] = content[j];
      j = j + 1;
    }
    else {
      content[i] = 16*h2c(content[j+1]) + h2c(content[j+2]);
      j = j + 3;
    }
    i = i + 1;
  }
  content[i] = '\0';
  return(content);
}

char *get_data(char *content, int size, char *name, char *value)
{
  int i,j,len;

  /* name */
  for( i = 0; content[i] != '=' && content[i] != '\0' && i < size; i++ )
    name[i] = content[i];
  name[i] = '\0';

  if( i == 0 ) return(NULL);

  /* value */
  j = i + 1;
  for( i = j; content[i] != '&' && content[i] != '\0' && i < size; i++ )
    value[i-j] = content[i];
  value[i-j] = '\0';
  len = i;

  /* remove + */
  for( j = 0; value[j] != '\0'; j++ )
    if( value[j] == '+' )
      value[j] = ' ';

#ifdef DEBUG
  syslog(LOG_ERR,"c=%d name=%s value=%s\n",content[len],name,value);
  printf("<debug>c=%d name=%s value=%s</debug>\n",content[len],name,value);
#endif

  return(content + len);
}
