
/*

   send a data from a http server to a local daemon and wait to response

   $Id: sender.c,v 1.4 2006-11-29 23:04:15 hroch Exp $

*/

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/socket.h>

#include <syslog.h>

char *send_to_socket(char *name, int len, char *input)
{
  char *output;
  int id;
  int size;
  struct sockaddr_un file;

  /* create socket */
  if( (id = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0 ) {
    return(strdup("Socket not created."));
  }
  
  /* init server socket */
  file.sun_family = AF_LOCAL;
  strncpy(file.sun_path,name, sizeof(file.sun_path));
  size = sizeof(file);
  if( connect(id, (struct sockaddr *) &file, size) < 0) {
    close(id);
    return(strdup("Socket not connected."));
  }

  if( write(id,input,strlen(input)+1) < 0 ) {
    close(id);
    return(strdup("Write to socket error."));
  }

  if( (output = malloc(len)) == NULL) {
    close(id);
    return(strdup("Memory for buffer not allocated."));
  }

#ifdef DEBUG
  syslog(LOG_ERR,"sender input: %s\n",input);
#endif

  if( (len = read(id,output,len)) < 0 ) {
    free(output);
    close(id);
    return(strdup("Read from socket error."));
  }
  output[len] = '\0';
    
#ifdef DEBUG
  syslog(LOG_ERR,"sender output: %s %d\n",output,len);
#endif

  close(id);
  return(output);
}
