/*

  Form ansfers to a client questions.
  
  $Id: driver.c,v 1.19 2008-08-15 20:42:30 hroch Exp $
  
*/ 


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include "ccdtypes.h"
#include "ccd.h"
#include "ccdcommon.h"
#include "commands.h"
#include "rcfile.h"
#include "nightview.h"

#define LEN 80

/* system wide rc file name */
/*#define SYSTEMRC "/usr/local/etc/nightviewd.conf"*/

/* bad magic constant ... correlates with device specific constant */
#define NFILTERS 5

/* format of string's, the digits must (!!) by the same as LEN */
#define FSTR "%80[^\"]"

static CCD *ccd = NULL;
static int debug = 0;

void driver_init(int argc, char *argv[])
{
  FILE *rc;
  int i, j;
  double longitude = 0.0, latitude = 0.0, altitude = 0.0, focus = 0.0;
  char line[LEN], filter[LEN], buf[LEN];
  char *val;
  char *fl[NFILTERS] = { NULL, NULL, NULL, NULL, NULL };
  char *sitename = NULL;
  char *telename = NULL;
  char *device = NULL;
  char *conf = NULL;
  int filter_wheel = 0;

  /* init syslog */
  /*openlog("nightviewd",LOG_PID, LOG_NOTICE);*/

  /* check for config file and debug level */
  for( i = 1; i < argc; i++) {
    if( strcmp(argv[i],"-c") == 0 && i++ < argc )
      conf = argv[i];
    if( strcmp(argv[i],"-d") == 0 && i++ < argc )
      sscanf(argv[i],"%d",&debug);
  }

  /* init by config file - read the rc file */
  if( conf == NULL ) conf = SYSTEMRC;
  if( (rc = rc_open(conf,"r")) ) {
    while( rc_gets(line,LEN,rc) ) {
    
      if( (val = strchr(line,'=')) && strstr(line,"Device") ) {
        if( (device = malloc(strlen(val)+1)) )
          sscanf(val+1,"%80s",buf);
	  device = strdup(buf);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Filter") && 
	  strstr(line,"wheel") ) {
	filter_wheel = strstr(val+1,"true") != NULL;
      }	
      for( i = 0; i < NFILTERS; i++ ) {
	snprintf(filter,LEN,"Filter %d",i+1);
	if( (val = strchr(line,'=')) && strstr(line,filter) ) {
          sscanf(strchr(line,'\"')+1,FSTR,buf);
	  fl[i] = strdup(buf);
	}
      }
      if( (val = strchr(line,'=')) && strstr(line,"Site") ) {
        sscanf(strchr(line,'\"')+1,FSTR,buf);
	sitename = strdup(buf);
      }	

      if( (val = strchr(line,'=')) && strstr(line,"Longitude") ) {
	if( sscanf(val+1,"%lf",&longitude) != 1 )
	  longitude = 0.0;
      }
      if( (val = strchr(line,'=')) && strstr(line,"Latitude") ) {
	if( sscanf(val+1,"%lf",&latitude) != 1 )
	  latitude = 0.0;
      }
      if( (val = strchr(line,'=')) && strstr(line,"Altitude") ) {
	if( sscanf(val+1,"%lf",&altitude) != 1 )
	  altitude = 0.0;
      }
      if( (val = strchr(line,'=')) && strstr(line,"Telescope") ) {
        sscanf(strchr(line,'\"')+1,FSTR,buf);
	telename = strdup(buf);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Focus") ) {
	if( sscanf(val+1,"%lf",&focus) != 1 )
	  focus = 0.0;
      }
    }
    rc_close(rc);
  }

  /* init by program arguments */
  for( i = 1; i < argc; i++) {
    if( strcmp(argv[i],"-device") == 0 && i++ < argc )
      if( (device = malloc(strlen(argv[i]+1))) )
	strcpy(device,argv[i]);
    if( strcmp(argv[i],"-filter_wheel") == 0 )
      filter_wheel = 1;
    for( j = 0; j < NFILTERS; j++ ) {
      snprintf(filter,LEN,"-filter%d",j+1);
      if( strcmp(argv[i],filter) == 0 && i+1 < argc ) {
	fl[j] = strdup(argv[++i]);
      }
    }
    if( strcmp(argv[i],"-site") == 0 && i++ < argc )
      sitename = strdup(argv[i]);
    if( strcmp(argv[i],"-longitude") == 0 && i++ < argc )
      if( sscanf(argv[i],"%lf",&longitude) != 1 )
	longitude = 0.0;
    if( strcmp(argv[i],"-latitude") == 0 && i++ < argc )
      if( sscanf(argv[i],"%lf",&latitude) != 1 )
	latitude = 0.0;
    if( strcmp(argv[i],"-altitude") == 0 && i++ < argc )
      if( sscanf(argv[i],"%lf",&altitude) != 1 )
	altitude = 0.0;
    if( strcmp(argv[i],"-telescope") == 0 && i++ < argc )
      telename = strdup(argv[i]);
    if( strcmp(argv[i],"-focus") == 0 && i++ < argc )
      if( sscanf(argv[i],"%lf",&focus) != 1 )
	focus = 0.0;
  }

  if( debug > 0 ) {
    for(i = 0; i < NFILTERS; i++)
      fprintf(stderr,"Filter wheel: %d, Filter %d: %s\n",filter_wheel,i,fl[i]);
  }

  if( ! (ccd = ccd_init(device)) ) {
    syslog(LOG_ERR,"Daemon setup failed\n");
    exit(1);
  }

  if( ccd_set_filters(ccd,filter_wheel,NFILTERS,fl) == 0) {
    syslog(LOG_WARNING,"Filter setup failed.\n");
  }

  if( ccd_set_site(ccd,sitename,longitude,latitude,altitude) == 0 ) {
    syslog(LOG_WARNING,"Site setup failed.\n");
  }
  
  if( ccd_set_telescope(ccd,telename,focus) == 0 ) {
    syslog(LOG_WARNING,"Telescope setup failed.\n");
  }

  free(device);
  free(sitename);
  free(telename);
  for( j = 0; j < NFILTERS; j++ )
    free(fl[j]);

}

void driver_close(void)
{
  //if( ccd_get_on(ccd) )
  ccd_shutdown(ccd);
  ccd_free(ccd);
  ccd = NULL;
}


char *driver(char *a, size_t *total)
{
  int i, j;
  float temp, regul, rstat;
  double exp_time;
  char *b, *bp;
  int bitpix, mode, x1, y1, x2, y2;

  if( debug > 0 )
    fprintf(stderr,"Q->:%s\n",a);

  *total = -1;
  b = strdup(UNRECOGNIZED);

  if( strcmp(a,LOGIN) == 0 ) {
    b = strdup(WELCOME); }

  /* camera init */
  else if( strstr(a,CAMERA_CONNECT) ) {
    if( ccd_connect(ccd) )
      b = strdup(CAMERA_CONNECTED);
    else
      b = strdup(CAMERA_NOTCONNECTED);
  }

  /* camera shutdown */
  else if( strcmp(a,CAMERA_SHUTDOWN) == 0 ) {
    if( ccd_shutdown(ccd) )
      b = strdup(CAMERA_SHUTDOWNED); 
    else
      b = strdup(CAMERA_NOSHUTDOWN);
  }
  
  /*  camera info */
  else if( strstr(a,CAMERA_INFO) ) {
    sscanf(a + strlen(CAMERA_INFO),"%d",&i);
    if( ccd_get_on(ccd) ) {
      b = malloc(LEN);
      snprintf(b,LEN,"'%s' %5d %5d %5.1f %5.1f %6.2f",
	       ccdinfo_get_name(ccd,i),
	       ccdinfo_get_size_width(ccd,i),
	       ccdinfo_get_size_height(ccd,i),
	       ccdinfo_get_size_pixwidth(ccd,i),
	       ccdinfo_get_size_pixheight(ccd,i),
	       ccdinfo_get_gain(ccd,i)); 
    }
    else
      b = strdup(CAMERA_NOINFO);}

  /* camera internal chip list - number of */
  else if( strcmp(a,CAMERA_NCHIP) == 0 ) {
    if( ccd_get_on(ccd) ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%d",ccd_nchiplist(ccd));
    }
    else
      b = strdup(CAMERA_NOCHIPNO);
  }

  /* camera internal chip list - list */
  else if( strstr(a,CAMERA_CHIP) ) {
    if( sscanf(a + strlen(CAMERA_CHIP),"%d",&i) == 1 && ccd_get_on(ccd) ) {
      b = malloc(LEN);
      snprintf(b,LEN,"'%s' '%s' '%s' %d %d %d %d %.2lf %.2lf %d %d %d %d %d",
	       ccd_get_firmware(ccd,i),
	       ccd_get_cameraname(ccd,i),
	       ccd_get_serial(ccd,i),
	       ccd_get_abgtype(ccd,i),
	       ccd_get_adrange(ccd,i),
	       ccd_get_bias(ccd,i),
	       ccd_get_nreadout(ccd,i),
	       ccd_get_minexp(ccd,i),
	       ccd_get_maxexp(ccd,i),
	       ccd_get_nbadcol(ccd,i),
	       ccd_get_badcol(ccd,i,0),
	       ccd_get_badcol(ccd,i,1),
	       ccd_get_badcol(ccd,i,2),
	       ccd_get_badcol(ccd,i,3));
    }
    else
      b = strdup(CAMERA_NOCHIP);
  }


  /* camera readout modes - number of (for specified chip) */
  else if( strstr(a,CAMERA_NREADOUT) ) {
    if( sscanf(a + strlen(CAMERA_NREADOUT),"%d",&i) == 1 && 
	ccd_get_on(ccd) && (j = ccd_get_nreadout(ccd,i)) > 0 ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%d",j);
    }
    else
      b = strdup(CAMERA_NONREADOUT);
  }

  /* camera readout modes - list */
  else if( strstr(a,CAMERA_READOUT_MODES) ) {
    if( sscanf(a + strlen(CAMERA_READOUT_MODES),"%d %d",&i,&j) == 2 && 
	ccd_get_on(ccd) ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%5d %5d %5d %5.1f %5.1f %6.2f",
	       ccd_get_readout_mode(ccd,i,j),
	       ccd_get_readout_width(ccd,i,j),
	       ccd_get_readout_height(ccd,i,j),
	       ccd_get_readout_pixsize(ccd,i,j),
	       ccd_get_readout_piysize(ccd,i,j),
	       ccd_get_readout_gain(ccd,i,j));
    }
    else
      b = strdup(CAMERA_NOREADOUT);
  }

  /* temperature init */
  else if( strcmp(a,TEMPERATURE_INIT) == 0 ) {
    b = strdup(TEMPERATURE_INITED); }

  /*  temperature ccd */
  else if( strcmp(a,TEMPERATURE_CCD) == 0 ) {
    temp = temp_ccd(ccd);
    b = malloc(LEN);
    snprintf(b,LEN,"%7.1f",temp); 
  }

  /* temperature air */
  else if( strcmp(a,TEMPERATURE_AIR) == 0 ) {
    temp = temp_air(ccd);
    b = malloc(LEN);
    snprintf(b,LEN,"%7.1f",temp);
  }

  /*  temperature setpoint */
  else if( strcmp(a,TEMPERATURE_SETPOINT) == 0 ) {
    temp = temp_setpoint(ccd);
    b = malloc(LEN);
    snprintf(b,LEN,"%7.1f",temp); 
  }

  /* cooling power */
  else if( strcmp(a,TEMPERATURE_REGUL) == 0 ) {
    regul = temp_regul(ccd);
    b = malloc(LEN);
    snprintf(b,LEN,"%7.1f",regul); }

  /*  temperature set */
  else if( strstr(a,TEMPERATURE_SET) != NULL ) {
    if( sscanf(a + strlen(TEMPERATURE_SET),"%f",&temp) == 1 && 
	temp_set(ccd,temp) ) 
      b = strdup(TEMPERATURE_SETED);
    else
      b = strdup(TEMPERATURE_NOSET); }

  /*  cooling off */
  else if( strcmp(a,TEMPERATURE_OFF) == 0 ) {
    temp_off(ccd);
    b = strdup(TEMPERATURE_OFFED); }

  /* exposure start */
  else if( strstr(a,EXPOSURE_START) != NULL ) {
    sscanf(a+strlen(EXPOSURE_START),"%lf %d %d",&exp_time,&i, &j);
    if( exp_start(ccd, exp_time, i, j) )
      b = strdup(EXPOSURE_STARTED);
    else
      b = strdup(EXPOSURE_NOSTART); }

  /* exposure status */
  else if( strstr(a,EXPOSURE_STAT) != NULL ) {
    sscanf(a+strlen(EXPOSURE_STAT),"%d",&j);
    i = exp_stat(ccd,j);
    if( i == EOE )
      b = strdup(END_OF_EXPOSURE);
    else if( i == IDLE )
      b = strdup(TIDLE);
    else if( i == RUN )
      b = strdup(TRUN);
    else
      b = strdup(EXPOSURE_ERROR); }

  /* exposure stop */
  else if( strstr(a,EXPOSURE_STOP) ) {
    sscanf(a+strlen(EXPOSURE_STOP),"%d",&j);
    if( exp_stop(ccd,j) )
      b = strdup(EXPOSURE_STOPED);
    else
      b = strdup(EXPOSURE_ERROR);
  }

  /* readout start */
  else if( strstr(a,EXPOSURE_READ) ) {
    if( sscanf(a+strlen(EXPOSURE_READ),"%d %d %d %d %d %d %d",
	       &bitpix,&mode,&x1,&y1,&x2,&y2,&i) == 7) {
      if( read_start(ccd, bitpix, mode, x1, y1, x2, y2, i) )
	b = strdup(READOUT_STARTED);
      else
	b = strdup(READOUT_NOSTART); 
    }
  }

  /*  readout status */
  else if( strstr(a,READOUT_STAT) ) {
    rstat = read_stat(ccd);
    if( rstat >= 100.0 )
      b = strdup(END_OF_READOUT);
    else if(  0.0 <= rstat && rstat <= 100.0 ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%s %f",TRUN,rstat);
    }
    else
      b = strdup(READOUT_ERROR); 
  }

  /* readout stop */
  else if( strstr(a,READOUT_STOP) ) {
    if( read_stop(ccd) )
      b = strdup(READOUT_STOPED);
    else
      b = strdup(READOUT_ERROR);
  }

  /* readout file */
  else if( strstr(a,EXPOSURE_DOWNLOAD) != NULL ) {
    b = read_download(ccd,NULL);
    if( b == NULL )
      b = strdup(READOUT_ERROR);
  }

  /* exposure remove */
  else if( strstr(a,EXPOSURE_REMOVE) != NULL ) {
    if( read_remove(ccd) )
      b = strdup(EXPOSURE_REMOVED);
    else
      b = strdup(EXPOSURE_NOREMOVE);
  }

  /* filter functions */ 
  else if( strstr(a,FILTER_INIT) != NULL ) {
    if( filter_init(ccd) ) 
      b = strdup(FILTER_INITED);
    else
      b = strdup(FILTER_NOINIT);
  }

  /* filter list */
  else if( strcmp(a,FILTER_LIST) == 0 ) {
    b = filter_list(ccd);
    if( b == NULL )
      b = strdup(FILTER_NOLIST);
  }

  /* filter set */
  else if( strstr(a,FILTER_SET) != NULL ) {
    if( filter_set(ccd, a + strlen(FILTER_SET)+1))
      b = strdup(FILTER_SETED);
    else
      b = strdup(FILTER_NOSET); }

  /* filter get */
  else if( strstr(a,FILTER_GET) != NULL ) {
    if( (bp = filter_get(ccd)))
      b = strdup(bp);
    else
      b = strdup("Unknown");
  }

  /* filter status */
  else if( strstr(a,FILTER_STAT) != NULL ) {
    i = filter_status(ccd);
    if( i == EOE )
      b = strdup(FILTER_READY);
    else if( i == IDLE )
      b = strdup(TIDLE);
    else if( i == RUN )
      b = strdup(TRUN);
    else
      b = strdup(FILTER_ERROR); }

  /* observatory name */
  else if( strstr(a,OBSERVATORY_NAME) != NULL ) {
      b = strdup(ccd_get_site_name(ccd));
  }

  /* observatory longitude */
  else if( strstr(a,OBSERVATORY_LONGITUDE) != NULL ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%f",ccd_get_site_long(ccd));
  }

  /* observatory latitude */
  else if( strstr(a,OBSERVATORY_LATITUDE) != NULL ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%f",ccd_get_site_lat(ccd));
  }

  /* observatory elevation (altitude) */
  else if( strstr(a,OBSERVATORY_ALTITUDE) != NULL ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%f",ccd_get_site_alt(ccd));
  }

  /* telescope */
  else if( strstr(a,TELESCOPE_NAME) != NULL ) {
      b = strdup(ccd_get_telescope_name(ccd));
  }

  /* observatory elevation (altitude) */
  else if( strstr(a,TELESCOPE_FOCUS) != NULL ) {
      b = malloc(LEN);
      snprintf(b,LEN,"%f",ccd_get_telescope_focus(ccd));
  }

  /* set observer */
  else if( strstr(a,OBSERVER_NAME) != NULL ) {
    if ( ccd_def_observer(ccd,a + strlen(OBSERVER_NAME) + 1) )
      b = strdup(OBSERVER_NAME_SET);
    else
      b = strdup(OBSERVER_NAME_NOSET);
  }

  /* set object */
  else if( strstr(a,OBJECT_NAME) != NULL ) {
    if ( ccd_def_object(ccd,a + strlen(OBJECT_NAME) + 1) )
      b = strdup(OBJECT_NAME_SET);
    else
      b = strdup(OBJECT_NAME_NOSET);
  }

  /* set fitsname */
  else if( strstr(a,FITS_NAME) != NULL ) {
    if ( ccd_def_fitsname(ccd,a + strlen(FITS_NAME) + 1) )
      b = strdup(FITS_NAME_SET);
    else
      b = strdup(FITS_NAME_NOSET);
  }

  /* not recognized */
  else
    b = strdup(UNRECOGNIZED);

  if( debug )
    /*    if( *total == - 1 )*/
      fprintf(stderr,"A<-:%s\n",b);

  /*  if( *total == -1 ) */
    *total = strlen(b) + 1;
  return((void *) b);
}
