
/*
  server daemon for libccd

 $Id: nightview.c,v 1.9 2002-01-30 18:48:37 hroch Exp $

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <syslog.h>
#include "commands.h"

#define PORT 7666
#define LEN 80
#define CLIENTS 5

static int socket_id = -1;

static int sendall(int i, char *buf,int *len)
{
  int n,total, bytesleft;

  total = 0;
  bytesleft = *len;
  
  while( total < *len ) {
    if( (n = send(i, buf+total, bytesleft, 0)) == -1 )
      return(-1);
    total = total + n;
    bytesleft = bytesleft - n;
  }
  *len = total;
  return(0);
}


int main(int argc, char *argv[])
{
  fd_set master, read_fds;
  struct sockaddr_in my, remote;
  struct timeval tv;
  int listener;
  int fdmax, newfd;
  int yes = 1;
  int i, len, nbytes, total;
  char buf[LEN];
  char *ansfer;

  /* init commands */
  command_init(argc, argv);

  /* init variables */
  len = sizeof(remote);

  /* initialize socket identifiers */
  FD_ZERO(&master);
  FD_ZERO(&read_fds);

  /* open socket */
  if( (listener = socket(AF_INET, SOCK_STREAM, 0)) == -1 ) {
    syslog(LOG_ERR,"%m\n");
    return(1);
  }

  /* ? */
  if( setsockopt(listener, SOL_SOCKET, SO_REUSEADDR,&yes,sizeof(int)) == -1 ) {
    syslog(LOG_ERR,"%m\n");
    return(1);
  }

  /* bind addres */
  my.sin_family = AF_INET;
  my.sin_addr.s_addr = INADDR_ANY;
  my.sin_port = htons(PORT);
  memset(&(my.sin_zero),'\0',8);
  if( bind(listener, (struct sockaddr *) &my, sizeof(my)) == -1 ) {
    syslog(LOG_ERR,"%m\n");
    return(1);
  }

  /* listen of clients */
  if( listen(listener, CLIENTS) == -1 ) {
    syslog(LOG_ERR,"%m\n");
    return(1);
  }

  FD_SET(listener, &master);

  fdmax = listener;

  /* main loop, wait for client, send data to clients */
  while(1) {

    read_fds = master;
    tv.tv_sec = 0;
    tv.tv_usec = 200000;
    if( select(fdmax+1,&read_fds, NULL, NULL, &tv) == -1 ) {
      syslog(LOG_ERR,"%m\n");
      return(1);
    }

    for( i = 0; i <= fdmax; i++ ) {

      if( FD_ISSET(i, &read_fds) ) {

	/* new client */
	if( i == listener ) {

	  if( (newfd = accept(listener, (struct sockaddr *)&remote, &len)) == -1)
	    syslog(LOG_ERR,"%m\n");
	  else {

	    /* request authorized ? */
	    FD_SET(newfd, &master);
	    if( newfd > fdmax )
	      fdmax = newfd;
	    syslog(LOG_NOTICE,"new connection from %s on socket %d\n", inet_ntoa(remote.sin_addr),newfd); 
	  }
	}

	else {
	
	  /* receive request */
	  if( (nbytes = recv(i,buf,LEN, 0)) <= 0 || 
	      strstr(buf,"quit") != NULL ) {

	    /* connection closed */
	    if( nbytes == 0 || strstr(buf,"quit") != NULL )
	      syslog(LOG_NOTICE,"connection on socket %d hung up\n", newfd); 
	    else
	      syslog(LOG_ERR,"%m\n");
	    close(i);
	    FD_CLR(i, &master); }

	  else {
    
	    /* works on data */
	    socket_id = i;
	    buf[strcspn(buf,"\n\r\0")] = '\0';
/*	    printf("data received from socket %d : %s\n",i,buf);*/
	    ansfer = command(buf,&total);

	    /* send response */
	    /*	    strncpy(buf1,"echo> ",LEN);
	    strncat(buf1,buf,LEN);
	    buf1[4 + nbytes] = '\n';*/
	    /*	    total = strlen(ansfer);*/
	    if( sendall(i, ansfer, &total) == -1 )
	      syslog(LOG_ERR,"%m\n");
	    free(ansfer);
	  }
	}
      }
    }
  }

  return(0);

}
