/*

  ccd functions

  $Id: ccd.c,v 1.25 2006-11-29 23:07:39 hroch Exp $

*/

#include "gtknightview.h"
#include "ccdtypes.h"
#include "ccd.h"
#include "ccdcommon.h"
#include <string.h>

static CCD *ccd = NULL;

/* 
   The basic idea is a hide the private data - ccd - for user.
   It works only with functions ccd_* to operate with device.
   This functions shadows the primary device and convert subroutines
   like:

     function(CCD *ccd, param1, ...) -> ccd_function(parame1, ...)

*/

int ccd_power_on(char *server)
{
  if( !ccd && (ccd = ccd_init(server)) ) {
    if( ccd_connect(ccd) )
      return(1);
    else {
      ccd_free(ccd);
      ccd = NULL;
      return(0);
    }
  }
  else    
    return(0);
}

int ccd_power_off(void)
{
  if( ccd ) {
    ccd_shutdown(ccd);
    ccd_free(ccd);
    ccd = NULL;
    return(1);
  }
  return(0);
}

int ccd_temp_set(float temperature)
{
  if( ccd )
    if( temp_set(ccd,temperature) == 1 )
      return(1);
  return(0);
}

void ccd_temp_off(void)
{
  if( ccd )
    temp_off(ccd);
}

float ccd_temp_ccd(void)
{
  float temp;

  if( ccd ) {
    temp = temp_ccd(ccd);
    if( temp > -280.0 )
      return(temp);
  }
  return(-999.9);
}

float ccd_temp_air(void)
{
  float temp;

  if( ccd ) {
    temp = temp_air(ccd);
    if( temp > -280.0 )
      return(temp);
  }
  return(-999.9);
}

int ccd_temp_regul(void)
{
  return((int) rint(temp_regul(ccd)));
}

int ccd_exp_start(float time, int shutter, int chip)
{
  if( ccd ) 
    if( exp_start(ccd, time, shutter, chip) )
      return(1);
  return(0);
}

int ccd_exp_stat(int chip)
{
  if( ccd )
    return(exp_stat(ccd,chip));
  return(IDLE);
}

int ccd_exp_stop(int chip)
{
  if( ccd )
    return(exp_stop(ccd,chip));
  return(0);
}  

float ccd_read_stat(void)
{
  if( ccd )
    return(read_stat(ccd));
  return(-1.0);
}

int ccd_read_start(int bin, int x1, int y1, int x2, int y2, int chip)
{
  int bitpix;

  if( ccd ) {
    bitpix = dat_bitpix_get();
    return(read_start(ccd,bitpix,bin-1,x1,y1,x2,y2,chip));
  }
  return(0);
}

int ccd_read_stop(void)
{
  return(read_stop(ccd));
}

char *ccd_read_image(void)
{
  char *filename;

  filename = read_download(ccd,tmpnam(NULL));

  if( ccd && filename )
    return(filename); 
  return(NULL);
}

int ccd_remove_image(void)
{
  if( ! read_remove(ccd) ) {
    fprintf(stderr,"Remove of temporary file failed.\n");
    return(0);
  }
  else
    return(1);
}

char *ccd_get_name(int chip)
{
  return(ccd_get_cameraname(ccd,chip));
}

int ccd_info_width(int chip)
{
  int bin = dat_binning_get()-1;
  return(ccd_get_readout_width(ccd,chip,bin));
}

int ccd_info_height(int chip)
{
  int bin = dat_binning_get()-1;
  return(ccd_get_readout_height(ccd,chip,bin));
}

int ccd_info_pixwidth(int chip)
{
  int bin = dat_binning_get()-1;
  return((int) ccd_get_readout_pixsize(ccd,chip,bin));
}

int ccd_info_pixheight(int chip)
{
  int bin = dat_binning_get()-1;
  return((int) ccd_get_readout_piysize(ccd,chip,bin));
}

float ccd_info_gain(int chip)
{
  int bin = dat_binning_get()-1;
  return(ccd_get_readout_gain(ccd,chip,bin));
}

void ccd_filter_init(int *n, char *f[])
{
  char *buf;
  int i,nn;

  if( ccd ) {
    buf = filter_list(ccd);
    split(buf,f,*n,"' ");
    free(buf);
    nn = *n;
    for( i = 0; i < nn; i++) {
      if( ! f[i] ) {
	*n = *n - 1;
      }
    }
  }
}

int ccd_filter_set(char *filter)
{
  if( ccd )
    return(filter_set(ccd,filter));
  return(0);
}

char *ccd_filter_get(void)
{
  return(filter_get(ccd));
}

int ccd_filter_status(void)
{
  if( ccd )
    return(filter_status(ccd));
  return(0);
}

int ccd_observer(char *observer)
{
  return(ccd_def_observer(ccd,observer));
}

int ccd_object(char *object)
{
  return(ccd_def_object(ccd,object));
}
