
/*

  action after click mouse 

  $Id: click.c,v 1.8 2002-06-03 14:16:15 hroch Exp $

*/

#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include "gtknightview.h"

static int width, height;
static int i,j;
static float x, y;

void geometry(float *x1,float *y1,int *i1,int *j1,int *w1,int *h1)
{
  *x1 = x; *y1 = y;
  *i1 = i; *j1 = j;
  *w1 = width; *h1 = height;
}

gboolean button_clicked(GtkWidget *window, GdkEventButton *event)
{
  static GtkWidget *control_panel = NULL;
  static gboolean panel_on = FALSE;

  if( event->button == 3 ) {

    /* init panel */
    if( control_panel == NULL )
      control_panel = control_panel_new(); 

    /* show panel */
    if( panel_on ) {
      gtk_widget_hide(control_panel);
      panel_on = FALSE; }
    else {
      gtk_widget_show(control_panel);
      panel_on = TRUE; }

  }
    
  return(TRUE);
}

gboolean mouse(GtkWidget *obr, GdkEventButton *event)
{
  int dp;
  GdkModifierType state;

  gdk_window_get_geometry(event->window,&i,&j,&width,&height,&dp);
  gdk_window_get_pointer (event->window, &i, &j, &state);
  x = (float) i / (float) width;
  y = (float) j / (float) height;

  /*    printf("%d %d\n",i,j);*/

  update_zoom();
  return(FALSE);
}

gboolean keyboard(GtkWidget *obr, GdkEventKey *event)
{
  int ii,jj, dp;
  static int eventy[5] = { GDK_Left, GDK_Right, GDK_Up, GDK_Down, GDK_Q };

  for( ii = 0; ii < 5 && (event->keyval != eventy[ii]); ii++);
  if( ii == 5 ) return(TRUE);

  if( event->keyval == GDK_Q )
    quit_soft();

  gdk_window_get_geometry(event->window,&i,&j,&width,&height,&dp);
  i = rint(x*width);
  j = rint(y*height);

  ii = jj = 0;
  if( event->keyval == GDK_Left )
    ii = -1;
  else if( event->keyval == GDK_Right )
    ii = +1;
  else if( event->keyval == GDK_Up )
    jj = -1;
  else if( event->keyval == GDK_Down )
    jj = +1;

  i = i + ii;
  j = j + jj;

  x = (float) i / (float) width;
  y = (float) j / (float) height;

  /*  printf("%d %d %d %d\n",i,j,width,height);*/

  XWarpPointer(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(event->window), None,
	       0, 0, 0, 0, ii, jj);

  update_zoom();
  return(TRUE);
}

