
#include "nightview.h"
#include "gtknightview.h"

typedef struct _FDATA FDATA;

struct _FDATA {
  char *object;
  char *observer;
  char *station;
  float station_long, station_lat, station_elev;
  char *telescope;
  char *note;
  float image_scale;
  int width, height;
  int x1,y1,x2,y2;
  int bitpix, binning;
  char camera;
  char *server;
  int subtract_dark;
  int compress;
  int legend;
  char *n,*e,*w,*s;
  /*  char *filters[5];*/
  char *filter;
  /*
  float temp_ccd;
  float temp_air;
  */
  char *font;
  int color_red, color_green, color_blue;
};

static FDATA *data;

void dat_init(void)
{  
  data = malloc(sizeof(FDATA));
  data->object = strdup("Object");
  data->observer = strdup("Observer");
  data->telescope = strdup("Telescope");
  data->station = strdup("Observatory");
  data->note = strdup("Comment");
  data->station_long = 0.0;
  data->station_lat = 0.0;
  data->station_elev = 0.0;
  data->image_scale = 1.0;
  data->x1 = 1;
  data->y1 = 1;
  data->x2 = -1;
  data->y2 = -1;
  data->bitpix = 16;
  data->binning = 1;
  data->camera = 'I';
  data->server = strdup(NIGHT_LOCALHOST);
  data->subtract_dark = 0;
  data->legend = 1;
  data->n = strdup("N");
  data->w = strdup("W");
  data->e = strdup("E");
  data->s = strdup("S");
  data->filter = strdup("");
  data->compress = 0;
  data->font = strdup("fixed");
  data->color_red = 65535;
  data->color_green = 65535;
  data->color_blue = 65535;
}

void dat_object_set(char *object)
{
  free(data->object);
  data->object = object;
}

char *dat_object_get(void)
{
  return(data->object);
}

void dat_observer_set(char *object)
{
  free(data->observer);
  data->observer = object;
}

char *dat_observer_get(void)
{
  return(data->observer);
}

void dat_observatory_set(char *obs)
{
  free(data->station);
  data->station = obs;
}

char *dat_observatory_get(void)
{
  return(data->station);
}

void dat_longitude_set(float lon)
{
  data->station_long = lon;
}

float dat_longitude_get(void)
{
  return(data->station_long);
}

void dat_latitude_set(float lon)
{
  data->station_lat = lon;
}

float dat_latitude_get(void)
{
  return(data->station_lat);
}

void dat_scale_set(float lon)
{
  data->image_scale = lon;
}

float dat_scale_get(void)
{
  return(data->image_scale);
}

void dat_elevation_set(float lon)
{
  data->station_elev = lon;
}

float dat_elevation_get(void)
{
  return(data->station_elev);
}

void dat_filter_set(char *f)
{
  free(data->filter);
  data->filter = f;
}

char *dat_filter_get()
{
  return(data->filter);
}

void dat_binning_set(int bin)
{
  data->binning = bin;
}

int dat_binning_get(void)
{
  return(data->binning);
}

void dat_bitpix_set(int bitpix)
{
  data->bitpix = bitpix;
}

int dat_bitpix_get(void)
{
  return(data->bitpix);
}

void dat_x1_set(int x1)
{
  data->x1 = x1;
}

void dat_y1_set(int y1)
{
  data->y1 = y1;
}

void dat_x2_set(int x2)
{
  data->x2 = x2;
}

void dat_y2_set(int y2)
{
  data->y2 = y2;
}

int dat_x1_get(void)
{
  return(data->x1);
}

int dat_y1_get(void)
{
  return(data->y1);
}

int dat_x2_get(void)
{
  return(data->x2);
}

int dat_y2_get(void)
{
  return(data->y2);
}

int dat_width_get(void)
{
  return(data->width);
}

int dat_height_get(void)
{
  return(data->height);
}


char *dat_server_get(void)
{
  return(data->server);
}

void dat_server_set(char *server)
{
  free(data->server);
  data->server = server;
}

int dat_chip_get(void)
{
  if( data->camera == 'I' )
    return(0);
  else if( data->camera == 'T' )
    return(1);
  else {
    fprintf(stderr,"Chip unknown in %s:%d\n",__FILE__,__LINE__);
    return(-1);
  }
}

void dat_chip_set(int chip)
{
  if( chip == 0 )
    data->camera = 'I';
  else if( chip == 1 )
    data->camera = 'T';
  else
    data->camera = ' ';
}

void dat_camera_set(char a)
{
  data->camera = a;
}

char dat_camera_get(void)
{
  return(data->camera);
}

char *dat_north_get(void)
{
  return(data->n);
}

void dat_north_set(char *n)
{
  free(data->n);
  data->n = n;
}

char *dat_east_get(void)
{
  return(data->e);
}

void dat_east_set(char *n)
{
  free(data->e);
  data->e = n;
}

char *dat_west_get(void)
{
  return(data->w);
}

void dat_west_set(char *n)
{
  free(data->w);
  data->w = n;
}

char *dat_south_get(void)
{
  return(data->s);
}

void dat_south_set(char *n)
{
  free(data->s);
  data->s = n;
}

int dat_legend_get(void)
{
  return(data->legend);
}

void dat_legend_set(int i)
{
  data->legend = i;
}

int dat_subtractdark_get(void)
{
  return(data->subtract_dark);
}

void dat_subtractdark_set(int i)
{
  data->subtract_dark = i;
}

char *dat_telescope_get(void)
{
  return(data->telescope);
}

void dat_telescope_set(char *tele)
{
  data->telescope = tele;
}

char *dat_note_get(void)
{
  return(data->note);
}

void dat_note_set(char *note)
{
  data->note = note;
}

int dat_compress_get(void)
{
  return(data->compress);
}

void dat_compress_set(int compress)
{
  data->compress = compress;
}


void dat_font_set(char *font)
{
  data->font = font;
}

char *dat_font_get(void)
{
  return(data->font);
}

void dat_color_set_r(int i)
{
  data->color_red = i;
}

int dat_color_get_r(void)
{
  return(data->color_red);
}

void dat_color_set_g(int i)
{
  data->color_green = i;
}

int dat_color_get_g(void)
{
  return(data->color_green);
}

void dat_color_set_b(int i)
{
  data->color_blue = i;
}

int dat_color_get_b(void)
{
  return(data->color_blue);
}


/*
FDATA *data_dup(void)
{
  FDATA *d;

  d = malloc(sizeof(FDATA));
  d->object = strdup(data->object);
  d->observer = strdup(data->observer);
  d->station = strdup(data->station);
  d->station_long = data->station_long;
  d->station_lat = data->station_lat;
  d->station_elev = data->station_elev;
  d->image_scale  = data->image_scale;
  d->x1 = data->x1;
  d->y1 = data->y1;
  d->x2 = data->x2;
  d->y2 = data->y2;
  d->bitpix = data->bitpix;
  d->binning = data->binning;
  d->camera = data->camera;
  d->server = strdup(data->server);
  d->server_port = data->server_port;
  d->reuse_darks = data->reuse_darks;
  d->legend = data->legend;
  d->n = data->n;
  d->e = data->e;
  d->w = data->w;
  d->s = data->s;
  d->filters[0] = data->filters[0];
  d->filters[1] = data->filters[1];
  d->filters[2] = data->filters[2];
  d->filters[3] = data->filters[3];
  d->filters[4] = data->filters[4];
  d->filter = data->filter;
  return(d);
}

FDATA *data_copy(FDATA *data)
{
  FDATA *d;

  d = malloc(sizeof(FDATA));
  d->object = strdup(data->object);
  d->observer = strdup(data->observer);
  d->station = strdup(data->station);
  d->station_long = data->station_long;
  d->station_lat = data->station_lat;
  d->station_elev = data->station_elev;
  d->image_scale  = data->image_scale;
  d->x1 = data->x1;
  d->y1 = data->y1;
  d->x2 = data->x2;
  d->y2 = data->y2;
  d->bitpix = data->bitpix;
  d->binning = data->binning;
  d->camera = data->camera;
  d->server = strdup(data->server);
  d->server_port = data->server_port;
  d->subtract_dark = data->subtract_dark;
  d->legend = data->legend;
  d->n = data->n;
  d->e = data->e;
  d->w = data->w;
  d->s = data->s;
  d->filters[0] = data->filters[0];
  d->filters[1] = data->filters[1];
  d->filters[2] = data->filters[2];
  d->filters[3] = data->filters[3];
  d->filters[4] = data->filters[4];
  d->filter = data->filter;
  
  return(d);
}
*/
