/*

  exposure frame

  $Id: exposure.c,v 1.36 2006-11-29 23:07:39 hroch Exp $

*/

#include "gtknightview.h"
#include "ccdtypes.h"
#include "ccd.h"
#include <unistd.h>

#define MENU_ITEMS    4
#define LIGHT_ITEM    "Light          "
#define SUBTRACT_ITEM "Light with dark"
#define DARK_ITEM     "Dark           "
#define CONTINUE_ITEM "Continue mode  "
/*#define AUTODARK_ITEM "Light with dark"*/

#define SUFIX "_darkof"

static float time;
static int dark = 0;
static char *exp_type = LIGHT_ITEM;
static int exp_status = IDLE;
static GtkWidget *exposure, *button;
static gboolean btoggled = FALSE;
static int subtract = 0;
static GtkWidget *subtract_menu;

static gboolean start_exposure(GtkWidget *, GtkWidget *);

static void readout_exposure(GtkWidget *button)
{
  unsigned char *data;
  int i;
  FIMAGE *fits;
  FIMAGE *idark;
  /*FIMAGE *fitsd;*/
  char *darkname;
  char *tempname;

  /* forget old image */
  if( (fits = image_buff_get(0)) ) {
    unlink(fits->filename);
  }

  if( (tempname = ccd_read_image()) != NULL && ccd_remove_image() ) {

    /* subtract dark if required */
    if( dark && strstr(exp_type,SUBTRACT_ITEM) ) {

      /* create dark's name */
      i = strlen(fits->filename) + strlen(SUFIX) + 1;
      if( (darkname = malloc(i)) )
	snprintf(darkname,i,"%s%s",fits->filename,SUFIX);

#ifdef DEBUG
      printf("darkname: %s\n",darkname);
#endif

      /* subtract dark and replace image */
      idark = image_buff_get(1);
      if( idark && fits_diff(darkname,tempname,idark->filename) == 0 ) {
	unlink(tempname);
	tempname = strdup(darkname);
      }
      
      free(darkname);
    }

    if( (fits = read_fits(strdup(tempname))) == NULL ) {
      fprintf(stderr,"File download error. %s %d\n",__FILE__,__LINE__);
      return;
    }

    /* keep scientific exposure */
    if( strstr(exp_type,LIGHT_ITEM) || strstr(exp_type,SUBTRACT_ITEM) ||
        strstr(exp_type,CONTINUE_ITEM) ) { 
      image_buff_free(0);
      image_buff_add(0,fits,tempname);
    }

    /* keep dark exposure */
    else if( strstr(exp_type,DARK_ITEM) ) {
      image_buff_free(1);
      image_buff_add(1,fits,tempname);
      dark = 1;
      gtk_widget_set_sensitive(GTK_WIDGET(subtract_menu),TRUE);      
    }

    /* display image */
    data = float2RGB(fits);
    init_obr(fits->width,fits->height,data);
  }
  else
    fprintf(stderr,"Exposure download error. %s %d\n",__FILE__,__LINE__);
}

static gboolean r_status(GtkWidget *button)
{
  static float read_status;
  char buf[80];

  if( GTK_TOGGLE_BUTTON (button)->active ) {
    if( (read_status = ccd_read_stat()) > 0.0 ) {
      /* progress_show(read_status);*/
      snprintf(buf,80," %4.1f%% of image downloaded",read_status);
      show_status(buf);}
    if( read_status > 99.99 ) {
      readout_exposure(button);

      /*
      if( strstr(exp_type,CONTINUE_ITEM) ) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),TRUE);
	start_exposure(button, exposure);
	while( gtk_events_pending())
	  gtk_main_iteration();
      }
      */
      return(FALSE); }
    return(TRUE);
  }
  return(FALSE);
}

/* start new exposure when subtract dark or continue mode is on */
static void cont_exp(gpointer data)
{
  GtkToggleButton *button;
  int tog;

  tog = btoggled;
  button = GTK_TOGGLE_BUTTON(data);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),FALSE);
/*  progress_stop("");*/

  if( tog ) {
    if( strstr(exp_type,CONTINUE_ITEM) ) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),TRUE);
    }

/*
    if( shutter == 0 && strstr(exp_type,SUBTRACT_ITEM) ) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),TRUE);
    }

*/
/*    progress_start("%v sec",time,NULL);*/
  }
}

static int start_readout_exposure(GtkWidget *button)
{
  static int r = 0;
  int chip,x1,y1,x2,y2;

  chip = dat_chip_get();
  x1 = dat_x1_get();
  y1 = dat_y1_get();
  x2 = dat_x2_get();
  y2 = dat_y2_get();
  if( GTK_TOGGLE_BUTTON (button)->active ) {
    if( ccd_read_start(dat_binning_get(),x1,y1,x2,y2,chip) ) {
      /*
      progress_start("%v %% ",100.0,(gpointer) r_status);
      */
      progress_activity();
      show_status("Downloading exposure...");
      /*
      if( strstr(exp_type,LIGHT_ITEM) || strstr(exp_type,DARK_ITEM) )
	r = gtk_timeout_add((guint32) 2000,(gpointer)r_status,button);
      else
      */
	r = gtk_timeout_add_full((guint32) 1000,(gpointer)r_status,NULL,
				 (gpointer) button, cont_exp);
    }
  }
  else {
    if( r ) {
      r = 0;
      progress_stop("");
      gtk_timeout_remove(r);
      show_status("Readout finished."); }
  }
  return(FALSE);

}

static gboolean e_status(GtkWidget *button)
{
  int chip;

  chip = dat_chip_get();

  if( GTK_TOGGLE_BUTTON (button)->active ) {
    if( (exp_status = ccd_exp_stat(chip)) == RUN )
      return(TRUE);
    else if( exp_status == EOE ) {
      ccd_exp_stop(chip);      
      start_readout_exposure(button);
      return(FALSE); }
    else {
      ccd_exp_stop(chip);      
      progress_stop("");
      return(FALSE);
    }
    return(TRUE);
  }
  else
    return(FALSE);

}

static gboolean start_exposure(GtkWidget *button, GtkWidget *exposure)
{
  static int exp_time = 0;
  static float exp_tick;
  int shutter;
  int chip;

  chip = dat_chip_get();
  /*  subtract = dat_subtractdark_get();*/

  /* check is dark exist and it's need */
  if( strstr(exp_type,SUBTRACT_ITEM) && ! dark ) {
    show_status("Fatal warning: Make dark first."); 
    return(TRUE);
  }

  /* determine shutter state */
  if( strstr(exp_type,DARK_ITEM) )
    shutter = 0;
  else
    shutter = 1;

  /* check is dark exist and it's need */
  if( strstr(exp_type,SUBTRACT_ITEM) && ! dark ) {
    show_status("Fatal warning: Make dark first."); 
    return(TRUE);
  }

  time = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(exposure));
  if( time < 0.11 )
    time = 0.11;

  if( GTK_TOGGLE_BUTTON (button)->active ) { /* start exposure */
    if( ccd_exp_start(time, shutter, chip) ) {
      progress_start("%v sec",time,NULL);
      if( time < 5.0 )
	exp_tick = 0.5;
      else if( time <= 5.0 && time < 20.0 )
	exp_tick = 1.0;
      else
        exp_tick = 2.0;
      exp_tick = 1000.0*exp_tick;  
      exp_time = gtk_timeout_add((guint32) exp_tick,(gpointer)e_status,button);
      show_status("Exposure in progress...");
      ccd_observer(dat_observer_get());
      ccd_object(dat_object_get());
    }
    else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),FALSE);
      show_status("Exposure start failed"); }}
  else {
    if( exp_time ) {
      exp_time = 0;
      progress_stop("");
      ccd_exp_stop(chip);
      gtk_timeout_remove(exp_tick);
      show_status("Exposure finished."); }
  }
  return(TRUE);
}

static void selected(char *type)
{
  exp_type = type;
#ifdef DEBUG
  printf("%s\n",exp_type);
#endif
}

static void button_state(GtkWidget *button)
{
  btoggled = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button));
#ifdef DEBUG
  printf("btoggled: %d\n",btoggled);
#endif
}

GtkWidget *make_exposure(GtkWidget *panel)
{
  GtkWidget *exp_frame, *subtype, *subitem;
  GtkWidget *exp_type;
  GtkWidget *hbox;
  GtkObject *adj;
  int i;
  static const char *menu_item[MENU_ITEMS] = { 
    LIGHT_ITEM, SUBTRACT_ITEM, DARK_ITEM, CONTINUE_ITEM };

  exp_frame = gtk_frame_new(" Exposure ");

  hbox = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(exp_frame),hbox);
  gtk_widget_show(hbox);

    /* enter field */
  adj = gtk_adjustment_new(1.0, 0.11, 167777.16, 1.0, 60.0, 0.0);
  exposure = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 1);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), FB);
  gtk_container_add(GTK_CONTAINER(hbox),exposure);
  gtk_widget_show(exposure);

  exp_type = gtk_option_menu_new();
  gtk_container_add(GTK_CONTAINER(hbox),exp_type);
  gtk_widget_show(exp_type);
  
  subtype = gtk_menu_new();
  for( i = 0; i < MENU_ITEMS; i++ ) {
    subitem = gtk_menu_item_new_with_label(menu_item[i]);
    gtk_menu_append(GTK_MENU(subtype), subitem);
    gtk_signal_connect_object( GTK_OBJECT(subitem), "activate",
	   GTK_SIGNAL_FUNC(selected), (gpointer) menu_item[i]);
    if( i == 1 )          /* === SUBTRACT_ITEM */
      subtract_menu = subitem;
    gtk_widget_show(subitem);
  }
  gtk_option_menu_set_menu(GTK_OPTION_MENU(exp_type), subtype);
  gtk_widget_show(subtype);

  gtk_widget_set_sensitive(GTK_WIDGET(subtract_menu),FALSE);

  button = gtk_toggle_button_new_with_label(" Start/Stop ");
  gtk_container_set_border_width (GTK_CONTAINER (hbox), FB);
  gtk_container_add(GTK_CONTAINER(hbox),button);
  gtk_widget_show(button);

  gtk_signal_connect(GTK_OBJECT(button),"toggled",
		     GTK_SIGNAL_FUNC(start_exposure), (gpointer) exposure);

  gtk_signal_connect(GTK_OBJECT(button),"toggled",
		     GTK_SIGNAL_FUNC(button_state), NULL);

  /*
  gtk_signal_connect(GTK_OBJECT(button),"released",
		     GTK_SIGNAL_FUNC(term_exposure), (gpointer) exposure);
  */

  return(exp_frame);
}
