/*

  file open/save

  $Id: file.c,v 1.16 2006-11-29 23:07:39 hroch Exp $

*/

#include <sys/stat.h>
#include <unistd.h>
#include <libgen.h>
#include "gtknightview.h"
#include "fitsadd.h"

static char *d_observer = NULL;
static char *d_object = NULL;
static char *d_note = NULL;
/*
static gboolean d_compress = FALSE;
*/
 
/*
static char *dirname(char *filename)
{
  char *directory;
  int l;

  l = strrchr(filename,'/') - filename;
  directory = malloc(l+1);
  strncpy(directory,filename,l);
  *(directory + l) = '\0';

  return(directory);
}
*/


static void file_ok_sel( GtkWidget *w, GtkFileSelection *fs)
{
  char *name, *directory;
  unsigned char *data;
  FIMAGE *fits;
  
  name = strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));

#ifdef DEBUG
  printf("open: %s\n", name);
#endif
  
  if( (fits = read_fits(name)) == NULL )
    show_status("File not found or not FITS");
  else {
    show_status("The image is open.");
    image_buff_free(0);
    if( image_buff_add(0,fits,name) ) {
      data = float2RGB(fits);
      init_obr(fits->width, fits->height, data);
    }
  }

  directory = dirname(name); 
  chdir(directory);

#ifdef DEBUG
  printf("Working directory changed to %s.\n",directory);
#endif

  free(name);
}

static void set_object(GtkWidget *widget, GtkWidget *objname)
{
  d_object = strdup(gtk_entry_get_text(GTK_ENTRY(objname)));
}

static void set_obsname(GtkWidget *widget, GtkWidget *obsname)
{
  d_observer = strdup(gtk_entry_get_text(GTK_ENTRY(obsname)));
}

static void set_note(GtkWidget *widget, GtkEntry *note)
{
  d_note = strdup(gtk_entry_get_text(GTK_ENTRY(note)));
}

/*
static void set_compress(GtkToggleButton *compress, GtkFileSelection *filew)
{
  char *name, *a;

  d_compress = gtk_toggle_button_get_active(compress);

  a = strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (filew)));

  if( d_compress )
    name = fits_gz(a);
  else
    name = fits_ugz(a);

#ifdef DEBUG
  printf("%s\n",name);
#endif

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (filew),name);
  free(a);
}
*/

static GtkWidget *add_entries(GtkWidget *filew)
{
  GtkWidget *vbox, *observer, *object, *objname, *obsname /*, *compress*/,
    *note, *notetext;

  vbox = gtk_vbox_new(FALSE,FB);
  
  object = gtk_frame_new(" Object ");
  gtk_container_add (GTK_CONTAINER (vbox), object);
  gtk_widget_show(object);
  
  objname = gtk_entry_new();
  gtk_container_add (GTK_CONTAINER (object),objname);
  gtk_widget_show(objname);
  gtk_entry_set_text(GTK_ENTRY(objname),d_object);
  gtk_signal_connect(GTK_OBJECT(objname),"changed",
		     GTK_SIGNAL_FUNC(set_object), objname);

  observer = gtk_frame_new(" Observer ");
  gtk_container_add (GTK_CONTAINER (vbox), observer);
  gtk_widget_show(observer);
  
  obsname = gtk_entry_new();
  gtk_container_add (GTK_CONTAINER (observer),obsname);
  gtk_widget_show(obsname);
  gtk_entry_set_text(GTK_ENTRY(obsname),d_observer);
  gtk_signal_connect(GTK_OBJECT(obsname),"changed",
		     GTK_SIGNAL_FUNC(set_obsname), obsname);

  note = gtk_frame_new(" Comment ");
  gtk_container_add (GTK_CONTAINER (vbox), note);
  gtk_widget_show(note);
  
  notetext = gtk_entry_new();
  gtk_container_add (GTK_CONTAINER (note),notetext);
  gtk_widget_show(notetext);
  gtk_entry_set_text(GTK_ENTRY(notetext),d_note);
  gtk_signal_connect(GTK_OBJECT(notetext),"changed",
		     GTK_SIGNAL_FUNC(set_note), notetext);

  /*
  compress = gtk_check_button_new_with_label("Compress");
  gtk_container_add (GTK_CONTAINER (vbox), compress);
  gtk_widget_show(compress);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(compress),d_compress);
  gtk_signal_connect(GTK_OBJECT(compress),"toggled",
		     GTK_SIGNAL_FUNC(set_compress), filew);
  */

  return(vbox);
}

static void save_close(GtkWidget *w, GtkWidget *main)
{
  gtk_widget_destroy(main);
  
  dat_object_set(strdup(d_object));
  dat_observer_set(strdup(d_observer));
  /* dat_compress_set(d_compress);*/
  free(d_object);
  free(d_observer);
}

void open_fits(GtkWidget *widget)
{
  GtkWidget *filew;

  filew = gtk_file_selection_new("File selector");
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, filew );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filew)->ok_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filew)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
  			   "*.fits");
  gtk_widget_show(filew);
}


static void file_ok_save( GtkWidget *w, GtkFileSelection *fs)
{
  gchar *name, *directory /*, *namegz, *oname*/;
  FIMAGE *fits;

  name = strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  /*namegz = NULL;*/

  /*
  if( (oname = tmpnam(NULL)) == NULL ) {
    fprintf(stderr,"Tmp file name creation error.\n");
    oname = name;
  }
  */

  /*
  if( d_compress ) {
    namegz = fits_gz(name);
    name = fits_ugz(name);
  }
  */

#ifdef DEBUG
  printf("save: %s\n",name);
#endif

  if( (fits = image_buff_get(0)) ) {

    write_fits(fits, name);

    if( d_object )
      fits_key(name,"OBJECT",d_object,"Object name");

    if( d_observer )
      fits_key(name,"OBSERVER",d_observer,"Observer name");

    if( d_note )
      fits_comment(name,d_note);
  }

  /* the files are created read-only */
  umask( S_IWUSR | S_IWGRP | S_IWOTH );

  /*
  if( d_compress ) {
    unlink(namegz);
    fits_cp(name,namegz);
    unlink(name);
  }
  */
  /*
  else {
    unlink(name);
    fits_cp(name,name);
  }
  unlink(oname);
  */

  directory = dirname(name);
  chdir(directory);

#ifdef DEBUG
  printf("Working directory changed to %s.\n",directory);
#endif

  if( name )
    free(name);
  
  /*
  if( namegz )
    free(namegz);
  */
}

void save_fits(GtkWidget *widget)
{
  GtkWidget *filew;
  GtkWidget *b;
  char *name;

  /* init optional entries */
  d_object = strdup(dat_object_get());
  d_observer = strdup(dat_observer_get());
  d_note = strdup(dat_note_get());
  /*d_compress = dat_compress_get();*/

  filew = gtk_file_selection_new("Save FITS file");

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_save, filew);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(filew)->ok_button),
		      "clicked", (GtkSignalFunc) save_close, filew);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(filew)->cancel_button),
		      "clicked", (GtkSignalFunc) save_close, filew);

  /*
  if( d_compress )
    name = strdup("nightview.fits.gz");
    else*/
    name = strdup("nightview.fits");

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), name);

  /* the vbox is a deep private structure, the future compatibility
     may do not work */
  b = add_entries(filew);
  gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(filew)->main_vbox),b);
  gtk_widget_show(b);

  gtk_widget_show(filew);
}
