/*

  filters

  $Id: filter.c,v 1.9 2006-11-29 23:07:39 hroch Exp $

*/

#include "gtknightview.h"
#include "ccdtypes.h"
#include "ccd.h"

/* filter's limit */
/*
#define MAXFILTERS 10
*/

/* filter progress update interval in miliseconds */
#define UPDATE 200

static char *filter[MAXFILTERS];
static int  nfilters = 0;
static GtkWidget *fl[MAXFILTERS], *hbox;
static GSList *filters;

static int f_status(GtkWidget *button)
{
  int filter_status;
  
  if( (filter_status = ccd_filter_status()) == RUN )
    return(TRUE);
  else {
    progress_stop("");
    show_status("Filter set.");
    return(FALSE);
  }
}

static void set_filter(GtkWidget *button, char *f)
{
  int s;

  if (GTK_TOGGLE_BUTTON (button)->active) {
    if( ccd_filter_set(f) ) {
      dat_filter_set(strdup(f));
      progress_activity();
      s = gtk_timeout_add((guint) UPDATE,(gpointer) f_status, button);
      show_status("Setting filter.."); }
    else
      show_status("Filter set failed.");
  }
}

void filter_ini(void)
{
  int i;
  char *cfilter;
  
  for(i = 0; i < MAXFILTERS; i++)
    filter[i] = NULL;

  nfilters = MAXFILTERS;
  ccd_filter_init(&nfilters,filter);
  printf("%d\n",nfilters);
  
  /* create buttons */
  for( i = 0; i < nfilters; i++ ) {

    if( i == 0 )
      filters = NULL;
    else
      filters = gtk_radio_button_group (GTK_RADIO_BUTTON (fl[i-1]));

    fl[i] = gtk_radio_button_new_with_label(filters,filter[i]);
    gtk_container_add(GTK_CONTAINER(hbox),fl[i]);
    gtk_signal_connect (GTK_OBJECT (fl[i]), "toggled",
			GTK_SIGNAL_FUNC(set_filter), (gpointer) filter[i]);
    gtk_widget_show(fl[i]);
  }

  /* activate init filter */
  cfilter = ccd_filter_get();
  for( i = 0; i < nfilters && cfilter; i++) {
    if( strcmp(filter[i],cfilter) == 0 )
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fl[i]), TRUE);
  }

}

void filter_clear()
{
  int i;

  for(i = 0; i < nfilters; i++ ) {
    gtk_container_remove(GTK_CONTAINER(hbox),fl[i]);
  }

  for(i = 0; i < MAXFILTERS; i++) {
    free(filter[i]);
    filter[i] = NULL;
  }

  nfilters = 0;
}

GtkWidget *make_filter(GtkWidget *panel)
{
  GtkWidget *filter_frame;

  filter_frame = gtk_frame_new("Filter");
  
  hbox = gtk_hbox_new(FALSE, FB);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), FB);
  gtk_container_add(GTK_CONTAINER(filter_frame),hbox);

  gtk_widget_show_all(hbox);

  return(filter_frame);
}
