/*

  exposure frame

  $Id: graph.c,v 1.13 2002-08-01 12:32:37 hroch Exp $

*/

#include "gtknightview.h"

#define ZOOM_SIZE 60
#define ZOOM_SCALE 3
#define ZOOM_IMAGE ZOOM_SIZE/ZOOM_SCALE
#define CROSS_SIZE 30

static GdkPixmap *g = NULL; 
static GtkWidget *zoom = NULL;
static GtkWidget *profile = NULL;
static GtkWidget *plabel = NULL, *ilabel, *flabel;

GtkWidget *get_zoom(void)
{
  return(zoom);
}

static void draw_cross(GtkWidget *zoom, GdkGC *gc1)
{
  int xc, yc, d;
  GdkGC *gc;
  GdkColormap *colormap;
  GdkColor color;

  color.red = dat_color_get_r();
  color.green = dat_color_get_g();
  color.blue = dat_color_get_b();
  gc = gdk_gc_new(zoom->window);
  colormap = gdk_window_get_colormap(zoom->window);
  gdk_color_alloc(colormap, &color);
  gdk_gc_set_foreground(gc,&color);

  xc = zoom->allocation.width/2 + 1;
  yc = zoom->allocation.height/2 + 1;
  /*  d = zoom->allocation.width/CROSS_SIZE;*/
  d = ZOOM_SCALE/2;

  gdk_draw_rectangle(zoom->window,gc,TRUE,xc-d,yc+ 5*d,2*d,10*d);
  gdk_draw_rectangle(zoom->window,gc,TRUE,xc-d,yc-15*d,2*d,10*d);
  gdk_draw_rectangle(zoom->window,gc,TRUE,xc-15*d,yc-d,10*d,2*d);
  gdk_draw_rectangle(zoom->window,gc,TRUE,xc+ 5*d,yc-d,10*d,2*d);

  gdk_gc_unref(gc);
}

static gboolean zoom_configure(GtkWidget *zoom)
{
  float x,y;
  int i,j,w, h, d, width, height;
  GdkPixbuf *im, *im1;

  if( zoom == NULL ) return(FALSE);

  width = zoom->allocation.width;
  height = zoom->allocation.height;
  /*  printf("%d %d\n",width, height);*/

  geometry(&x,&y,&i,&j,&w,&h);
  /*  printf("%d %d %d %d\n",i,j,w,h);*/
  d = width/2/ZOOM_SCALE;
  if( 2*ZOOM_SCALE*d > width ) d = d - 1;
  if( (im = sub_image(i-d,j-d,i+d,j+d)) ) {
    if( (im1 = gdk_pixbuf_scale_simple(im,width,height,GDK_INTERP_NEAREST)) ) {
      gdk_pixbuf_render_to_drawable(im1, zoom->window, 
				    zoom->style->bg_gc[zoom->state],
			    0,0,0,0,width,height,GDK_RGB_DITHER_MAX, 0,0);
      draw_cross(zoom,zoom->style->fg_gc[zoom->state]);
      gdk_pixbuf_unref(im);
    }
    gdk_pixbuf_unref(im1);
  }
  return(FALSE);
}

static gboolean zoom_expose(GtkWidget *zoom)
{ 
  zoom_configure(zoom);
  return(FALSE);
}

static gboolean profile_configure(GtkWidget *w)
{
  int ii, width, height, cwidth, cheight;
  float x,y;
  int i,j,ww, hh, npoints, xi, yi;
  GdkPoint *points;
  FIMAGE *f;

  if( g ) 
    gdk_pixmap_unref(g);

  width = w->allocation.width;
  height = w->allocation.height;
  cwidth = width/40;  /* = 3 */
  cheight = height/40;
  if( width < 1 || height < 1 || cwidth < 1 ) return(FALSE);

  geometry(&x,&y,&i,&j,&ww,&hh);
  g = gdk_pixmap_new(w->window, width, height,-1);
  gdk_draw_rectangle(g,w->style->bg_gc[w->state],TRUE,0,0,width, height);

  /* draw axes */
  gdk_draw_rectangle(g,w->style->fg_gc[w->state],FALSE,1,1,width-2, height-2);

  /* x ticks */
  for( ii = 5; ii < width; ii = ii + 5*cwidth ) {
    gdk_draw_line(g,w->style->fg_gc[w->state],ii,1,ii,4);
    gdk_draw_line(g,w->style->fg_gc[w->state],ii,height-5,ii,height);
  }

  /* y ticks */
  for( ii = 0; ii < height; ii = ii + 10 ) {
    gdk_draw_line(g,w->style->fg_gc[w->state],1,ii,4,ii);
    gdk_draw_line(g,w->style->fg_gc[w->state],width-5,ii,width,ii);
  }

  /* draw profile */
  points = malloc(sizeof(GdkPoint)*21);
  f = image_buff_get(0);

  /* x direction */
  npoints = get_points(f,i,j,10,1,0,height,points);
  for( ii = 0; ii < npoints; ii++ ) {
    points[ii].x = cwidth*(points[ii].x + 11) + 5;
    points[ii].y = height - points[ii].y - 10;
    if( points[ii].y >= height  ) points[ii].y = height;
    if( points[ii].y <= 0   ) points[ii].y = 0;
  }  
  gdk_draw_lines(g,w->style->fg_gc[w->state],points,npoints);

  /* y direction */
  npoints = get_points(f,i,j,10,0,1,height,points);
  for( ii = 0; ii < npoints; ii++ ) {
    xi = points[ii].x;
    yi = points[ii].y;
    points[ii].y = cheight*(xi + 11) + 5;
    points[ii].x = width - yi - 10;
    /*        printf("%d %d\n",points[ii].x,points[ii].y);*/
    /*
    points[ii].x = cwidth*(points[ii].x + 11) + width/2 + 5;
    points[ii].y = height - points[ii].y - 10;
    */
    if( points[ii].y >= height  ) points[ii].y = height;
    if( points[ii].y <= 0   ) points[ii].y = 0;
  }  
  gdk_draw_lines(g,w->style->fg_gc[w->state],points,npoints);

  free(points);
  return(FALSE);
}

gboolean profile_expose(GtkWidget *w)
{
  int width, height;

  profile_configure(w);
  width = w->allocation.width;
  height = w->allocation.height;
  if( g )
    gdk_draw_pixmap(w->window,w->style->fg_gc[GTK_WIDGET_STATE (w)],
		    g,0,0,0,0,width,height);
  return(FALSE);
}

gboolean label_configure(GtkWidget *w)
{
  float x, y, val, xfwhm, yfwhm;
  int i,j,nx,ny;
  char buf[80];
  FIMAGE *f;

  if( plabel == NULL ) return(FALSE);

  geometry(&x,&y,&i,&j,&nx,&ny);
  f = image_buff_get(0);
  
  i = rint(x*nx);
  j = rint(y*ny);
  val = get_intensity(f,i,j);
  get_fwhm(f,i,j,&xfwhm,&yfwhm);
  
  sprintf(buf,"(x,y)=%d,%d",i+1,ny-j);
  gtk_label_set_text(GTK_LABEL(plabel),buf);

  sprintf(buf,"intensity=%5.1f",val);
  gtk_label_set_text(GTK_LABEL(ilabel),buf);

  if( xfwhm < 5.8 && xfwhm < 5.8 ) 
    sprintf(buf,"fwhm=%3.1f,%3.1f",xfwhm,yfwhm);
  else
    sprintf(buf,"fwhm=       ");
  gtk_label_set_text(GTK_LABEL(flabel),buf);

  return(FALSE);
}

gboolean label_expose(GtkWidget *w)
{
  label_configure(NULL);
  return(FALSE);
}

void update_zoom(void)
{
  if( zoom )
    zoom_expose(zoom);
  if( profile) 
    profile_expose(profile);
  if( plabel ) 
    label_expose(NULL);
}

GtkWidget *make_graph(GtkWidget *panel)
{
  GtkWidget *graph_frame;
  GtkWidget *hbox, *info;
  GtkWidget *aspect, *profasp;

  graph_frame = gtk_frame_new(NULL);
 
  hbox = gtk_hbox_new(FALSE, FB);
  /*  gtk_box_pack_start(GTK_BOX(graph_frame),hbox,TRUE,TRUE,FALSE);*/
  gtk_container_add(GTK_CONTAINER(graph_frame),hbox);
  gtk_widget_show(hbox);

  /* zoom rectangle */
  aspect = gtk_aspect_frame_new(NULL, 0.0, 0.0, 1.0, FALSE);
  /*  gtk_container_add(GTK_CONTAINER(hbox),aspect);*/
  gtk_box_pack_start(GTK_BOX(hbox),aspect,TRUE,TRUE,FALSE);
  gtk_widget_show(aspect);

  zoom = gtk_drawing_area_new();
  /*  gtk_drawing_area_size(GTK_DRAWING_AREA(zoom), ZOOM_SIZE, ZOOM_SIZE);*/

  gtk_signal_connect(GTK_OBJECT(zoom), "configure_event",
		     GTK_SIGNAL_FUNC(zoom_configure), NULL);
  gtk_signal_connect(GTK_OBJECT(zoom), "expose_event",
		     GTK_SIGNAL_FUNC(zoom_expose), NULL);

  /*  gtk_signal_connect(GTK_OBJECT(zoom), "motion_notify_event",
      GTK_SIGNAL_FUNC(zoom_expose), NULL);*/
  gtk_widget_set_events(zoom, GDK_ALL_EVENTS_MASK);
  gtk_container_add(GTK_CONTAINER(aspect),zoom);
  gtk_widget_show(zoom);

  /* profile */
  /*  profasp = gtk_aspect_frame_new(NULL, 0.0, 0.0, 2.0, FALSE);*/
  profasp = gtk_hbox_new(FALSE,FB);
  gtk_box_pack_start(GTK_BOX(hbox),profasp,TRUE,TRUE,FALSE);
  /*    gtk_container_add(GTK_CONTAINER(hbox),profasp);*/
  gtk_widget_show(profasp);

  profile = gtk_drawing_area_new();
  /*  gtk_drawing_area_size(GTK_DRAWING_AREA(profile), 2*ZOOM_SIZE, ZOOM_SIZE);*/
  gtk_container_add(GTK_CONTAINER(profasp),profile);
  gtk_widget_show(profile);

  gtk_signal_connect(GTK_OBJECT(profile), "configure_event",
		     GTK_SIGNAL_FUNC(profile_configure), NULL);
  gtk_signal_connect(GTK_OBJECT(profile), "expose_event",
		     GTK_SIGNAL_FUNC(profile_expose), NULL);

  /* info text */
  info = gtk_vbox_new(FALSE,FB);

  plabel = gtk_label_new("(x,y) =    ");
  gtk_label_set_justify( GTK_LABEL(plabel), GTK_JUSTIFY_LEFT);
  gtk_container_add(GTK_CONTAINER(info),plabel);
  gtk_widget_show(plabel);
  
  ilabel = gtk_label_new("intensity= ");
  gtk_label_set_justify( GTK_LABEL(ilabel), GTK_JUSTIFY_LEFT);
  gtk_container_add(GTK_CONTAINER(info),ilabel);
  gtk_widget_show(ilabel);

  flabel = gtk_label_new("fwhm=      ");
  gtk_label_set_justify( GTK_LABEL(flabel), GTK_JUSTIFY_LEFT);
  gtk_container_add(GTK_CONTAINER(info),flabel);
  gtk_widget_show(flabel);

  gtk_box_pack_start(GTK_BOX(hbox),info,TRUE,TRUE,FALSE);
  /*  gtk_container_add(GTK_CONTAINER(hbox),info);*/
  gtk_widget_show(info);

  return(graph_frame);
}
