/*

  gtknigtview - main window with image 

  $Id: gtknightview.c,v 1.33 2006-11-29 23:07:39 hroch Exp $

*/

#include "nightview.h"
#include "gtknightview.h"
#include "nightview.xpm"

#define ETC_RC "/etc"

#define LENLINE 250

static GdkPixbuf *im = NULL;
static GtkWidget *window, *obr;
static char *font = NULL;
static GdkColor color;
static int draw_subimage = 0;
static int nx_sub, ny_sub, w_sub, h_sub;

static void draw_rectangle();
static gboolean expose_obr();


void obr_redraw(void)
{
  expose_obr(obr);
}

int get_obr_width(void)
{
  return(obr->allocation.width);
}

int get_obr_height(void)
{
  return(obr->allocation.height);
}

void set_legend_font(char *f)
{
  font = f;
  dat_font_set(f);
}

void set_legend_color(GdkColor *c)
{
  color.red   = c->red;
  color.green = c->green;
  color.blue  = c->blue;

  dat_color_set_r(c->red);
  dat_color_set_g(c->green);
  dat_color_set_b(c->blue);
}

void get_legend_color(GdkColor *c)
{
  c->red = color.red;
  c->green = color.green;
  c->blue = color.blue;
}

void set_subimage(int nx, int ny, int w, int h)
{
  nx_sub = nx;
  ny_sub = ny;
  w_sub = w;
  h_sub = h;
  expose_obr(obr);
}

void set_draw_subimage(int set)
{
  draw_subimage = set;
  expose_obr(obr);
}

GdkPixbuf *sub_image(int x1,int y1,int x2,int y2)
{
  GdkPixbuf *im1;
  int width, height, bitpix;

  if( im == NULL ) return(NULL);

  if( x1 < 0 ) return(NULL);
  if( y1 < 0 ) return(NULL);
  if( x2 >= gdk_pixbuf_get_width(im) ) return(NULL);
  if( y2 >= gdk_pixbuf_get_height(im) ) return(NULL);
  width = x2 - x1 + 1;
  height = y2 - y1 + 1;
  if( width < 1 || height < 1 ) return(NULL);
  /*  printf("%d %d %d %d\n",x1,y1,width,height);*/
  bitpix = gdk_pixbuf_get_bits_per_sample(im);
  im1 = gdk_pixbuf_new(GDK_COLORSPACE_RGB,FALSE,bitpix,width, height);
  if( im1 == NULL ) printf("im1 == NULL\n");
  gdk_pixbuf_copy_area(im,x1,y1,width,height,im1,0,0);
  return(im1);
}

static void free_data(unsigned char *data)
{
  free(data);
}

void init_obr(int width, int height, unsigned char *data)
{
  if( im ) gdk_pixbuf_unref(im);
  im = gdk_pixbuf_new_from_data(data, GDK_COLORSPACE_RGB, FALSE, 8,
				width, height, 3*width, (void *) free_data, 
				NULL);
  gtk_window_set_default_size(GTK_WINDOW(window),width,height);
}

static void draw_legend(GtkWidget *obr, GdkGC *gc1)
{
  int nx,ny,wx,hx, xc, yc, dscale;
  GdkFont *fn;
  GdkGC *gc;
  static char *scale = "1'";
  char *n, *e, *w, *s;
  GdkColormap *colormap;

  gc = gdk_gc_new(obr->window);
  colormap = gdk_window_get_colormap(obr->window);
  gdk_color_alloc(colormap, &color);
  gdk_gc_set_foreground(gc,&color);

  nx = obr->allocation.width;
  ny = obr->allocation.height;
  xc = obr->allocation.width/2;
  yc = obr->allocation.height/2;
  dscale = rint(60.0/dat_scale_get()/dat_binning_get());
  n = dat_north_get();
  e = dat_east_get();
  w = dat_west_get();
  s = dat_south_get();
  gdk_draw_rectangle(obr->window,gc,TRUE,nx-dscale-20,ny-10,dscale,2);
  fn = gdk_font_load(font);
  wx = gdk_string_width(fn,scale);
  hx = gdk_string_height(fn,scale);
  gdk_draw_string(obr->window,fn,gc,nx-20-dscale/2-wx/2,ny-12,scale);
  if( strlen(n) > 0 ) {
    wx = gdk_string_width(fn,n);
    hx = gdk_string_height(fn,n);
    gdk_draw_string(obr->window,fn,gc,xc-wx/2,4+hx,n);
  }
  if( strlen(w) > 0 ) {
    wx = gdk_string_width(fn,w);
    hx = gdk_string_height(fn,w);
    gdk_draw_string(obr->window,fn,gc,nx-wx-4,yc-hx/2,w);
  }
  if( strlen(e) > 0 ) {
    wx = gdk_string_width(fn,e);
    hx = gdk_string_height(fn,e);
    gdk_draw_string(obr->window,fn,gc,4,yc-hx/2,e);
  }
  if( strlen(s) > 0 ) {
    wx = gdk_string_width(fn,s);
    hx = gdk_string_height(fn,s);
    gdk_draw_string(obr->window,fn,gc,xc-wx/2,ny-hx,s);
  }

  gdk_gc_unref(gc);
}

static void draw_rectangle(GtkWidget *obr)
{
  int nx,ny, y;
  GdkGC *gc;
  GdkColormap *colormap;

  nx = obr->allocation.width;
  ny = obr->allocation.height;

  if( nx_sub > 0 && ny_sub > 0 && w_sub < nx && h_sub < ny ) {

    gc = gdk_gc_new(obr->window);
    colormap = gdk_window_get_colormap(obr->window);
    gdk_color_alloc(colormap, &color);
    gdk_gc_set_foreground(gc,&color);

    y = ny - ny_sub - h_sub + 1;
    gdk_draw_rectangle(obr->window,gc,FALSE,nx_sub, y ,w_sub,h_sub);
  }
}

static gboolean expose_obr(GtkWidget *obr)
{
  GdkPixbuf *im1;

  im1 = gdk_pixbuf_scale_simple(im,obr->allocation.width,obr->allocation.height,
				GDK_INTERP_NEAREST);
  gdk_pixbuf_render_to_drawable(im1,obr->window,obr->style->black_gc,
		  0,0,0,0,obr->allocation.width,
				obr->allocation.height,
				GDK_RGB_DITHER_MAX, 0,0);  

  if( dat_legend_get() && image_buff_get(0) )
    draw_legend(obr,obr->style->white_gc);

  if( draw_subimage )
    draw_rectangle(obr);

  gdk_pixbuf_unref(im1);
  return(TRUE);
}

static gboolean configure_obr(GtkWidget *obr)
{

  if( im == NULL ) {
    im = gdk_pixbuf_new_from_xpm_data(m101);
    gdk_pixbuf_render_to_drawable(im, obr->window, obr->style->black_gc,
				  0,0,0,0,265,265,GDK_RGB_DITHER_NORMAL,0,0);
  }
  return(TRUE);
}

void stdinput(gpointer d, int source, GdkInputCondition cond)
{
  char filename[LENLINE], line[LENLINE];
  static FIMAGE *fits;
  static unsigned char *data = NULL;

  if( fgets(line,LENLINE,stdin) != NULL ) {
    sscanf(line,"%s",filename);

#ifdef DEBUG
    printf("input: %s\n",filename);
#endif

    if( (fits = read_fits(filename)) == NULL )
      show_status("File not found.");
    else {
      image_buff_free(0);
      if( image_buff_add(0,fits,filename) ) {
	data = float2RGB(fits);
	init_obr(fits->width, fits->height, data);
      }
    }
  }
  else
    exit(0);
}

void print_help(void)
{

  printf("%s\n",XWINVER);
  printf("GTKNightView - interactive CCD control software\n");
  printf("Usage: gtknightview [-h|--help] [-i image] [-]\n");
  printf("options\n");
  printf("\t-i <image>\t view image\n");
  printf("\t-\t read image names from standard input\n");
  printf("\t-h, --help\t print this help\n\n");
}

void print_info(void)
{
  /*
  print_help();
  */
  
  /*
  printf("\n\n");
  printf("  This version is not fully completed, please work on:.\n");
  printf("  * correcting of bug fixes\n"); 
  printf("  * subimage selection\n");
  printf("  * add color and font preferences save\n");
  printf("  * exposure light with dark mode\n");
  printf("  * selection of image area\n");
  printf("  * correct exposure process/download interput\n");
  */
}

int main(int argc, char *argv[])
{
  unsigned char *data;
  FIMAGE *fits;
  char *path[3];
  int i;

  /* command line arguments - looking for help*/
  for( i = 1; i < argc; i++ ) {
    if( strcmp(argv[i],"-h") == 0 || strcmp(argv[i],"--help") == 0 ) {
      print_help();
      return(0);
    }
  }

  print_info();

  gtk_init(&argc,&argv);
  gdk_rgb_init();

  dat_init();

  path[0] = strdup(ETC_RC);
  path[1] = strdup(getenv("HOME"));
  path[2] = NULL;
  rc_init("gtknightviewrc",path);

  color.red = dat_color_get_r();
  color.green = dat_color_get_g();
  color.blue = dat_color_get_b();
  font = dat_font_get();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), TRUE,TRUE,TRUE);
  gtk_window_set_default_size(GTK_WINDOW(window),265,265);

  obr = gtk_drawing_area_new();
  gtk_container_add(GTK_CONTAINER(window), obr);
  gtk_widget_show(obr);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event", 
                     GTK_SIGNAL_FUNC(quit_soft), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy_event", 
                     GTK_SIGNAL_FUNC(quit_hard), NULL);
  gtk_signal_connect(GTK_OBJECT(obr), "expose_event",
		     GTK_SIGNAL_FUNC(expose_obr), NULL);
  gtk_signal_connect(GTK_OBJECT(obr), "configure_event",
		     GTK_SIGNAL_FUNC(configure_obr), NULL);
  gtk_signal_connect(GTK_OBJECT(obr), "button_press_event",
		     GTK_SIGNAL_FUNC(button_clicked), NULL);
  gtk_signal_connect(GTK_OBJECT(obr), "motion_notify_event",
		     GTK_SIGNAL_FUNC(mouse), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "key_press_event",
		     GTK_SIGNAL_FUNC(keyboard), obr);
  gtk_widget_set_events(obr, GDK_ALL_EVENTS_MASK );

  /* command line arguments */
  for( i = 1; i < argc; i++ ) {
    if( strcmp(argv[i],"-i") == 0 && i++ <= argc ) {
      if( (fits = read_fits(argv[i++])) == NULL )
	show_status("File not found.");
      else {
	if( image_buff_add(0,fits,argv[i]) ) {
	  data = float2RGB(fits);
	  init_obr(fits->width, fits->height, data);
	}
      }
    }
    else if( strcmp(argv[i],"-") == 0 )
      gdk_input_add(fileno(stdin),GDK_INPUT_READ,(void *) stdinput,NULL);
  }

  gtk_widget_show(window);
  gtk_main();

  return(0);
}

