
/*

  gtknigtview - main window with image header file

  $Id: gtknightview.h,v 1.38 2006-11-29 23:07:39 hroch Exp $

*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

/* thick of frame around objects */
#define FB 5

/* temperature tick - time step for update temperature indicator, in milisec */
/*#define TEMP_TICK 10000*/

/* structures */
typedef struct _FIMAGE FIMAGE;

struct _FIMAGE {
  int width, height;
  float *image;
  char *filename;
};

/* quit.c */
extern void quit_soft(void);
extern void quit_hard(void);

/* click.c */
extern void geometry(float *,float *,int *,int *,int *, int *);
extern gboolean button_clicked(GtkWidget *, GdkEventButton *);
extern gboolean mouse(GtkWidget *, GdkEventButton *);
extern gboolean keyboard(GtkWidget *, GdkEventKey *);

/* panel.c */
extern GtkWidget *control_panel_new(void);

/* menu.c */
extern GtkWidget *make_main_menu(GtkWidget *);

/* temperature.c */
extern GtkWidget *make_temperature(GtkWidget *);
extern void temperature_init(void);
extern void temperature_shutdown(void);

/* power.c */
extern GtkWidget *make_power(GtkWidget *);

/* status.c */
extern void progress_start(char *, float, void *);
extern void progress_stop(char *);
extern void progress_show(float);
extern GtkWidget *make_status(GtkWidget *);
extern void show_status(char *);
extern void progress_activity(void);

/* ccd.c */
extern int ccd_exp_start(float,int,int);
extern int ccd_exp_stat(int);
extern int ccd_exp_stop(int);
extern float ccd_read_stat(void);
extern int ccd_read_start(int, int, int, int, int, int);
extern char *ccd_read_image(void);
extern int ccd_remove_image(void);
extern int ccd_power_on(char *);
extern int ccd_power_off(void);
extern int ccd_temp_set(float);
extern void ccd_temp_off(void);
extern float ccd_temp_ccd(void);
extern float ccd_temp_air(void);
extern int ccd_temp_regul(void);
extern char *camera_info(char *);
extern void ccd_filter_init(int *, char *f[]);
extern int ccd_filter_set(char *);
extern char *ccd_filter_get(void);
extern int ccd_filter_status(void);
extern int ccd_info_width(int);
extern int ccd_info_height(int);
extern char *ccd_get_name(int chip);
extern int ccd_info_pixwidth(int chip);
extern int ccd_info_pixheight(int chip);
extern float ccd_info_gain(int chip);

/* exposure.c */
extern GtkWidget *make_exposure(GtkWidget *);

/* about.c */
extern void about(void);

/* info.c */
extern void info(void);

/* file.c */
extern void open_fits(GtkWidget *);
extern void save_fits(GtkWidget *);

/* fits.c */
extern unsigned char *float2RGB(FIMAGE*);
extern FIMAGE *read_fits(char *);
extern int write_fits(FIMAGE *,char *);
extern void get_fwhm(FIMAGE *,int,int,float *,float *);
extern float get_intensity(FIMAGE*,int,int);
extern int get_points(FIMAGE *,int, int, int, int, int, int, GdkPoint *);

/* gtknightview.c */
extern void init_obr(int, int, unsigned char *);
extern GdkPixbuf *sub_image(int,int,int,int);
extern void set_legend_font(char *f);
extern void set_legend_color(GdkColor *c);
extern void obr_redraw(void);
extern void set_draw_subimage(int set);
extern void set_subimage(int nx, int ny, int w, int h);
extern int get_obr_width(void);
extern int get_obr_height(void);

/* rc.c */
extern int rc_init(char *, char *path[]);
extern void rc_save();

/* filter.c */
extern void filter_ini(void);
extern GtkWidget *make_filter(GtkWidget *);
extern void filter_clear(void);

/* graph.c */
extern GtkWidget *make_graph(GtkWidget *);
extern void update_zoom(void);
extern GtkWidget *get_zoom(void);

/*image.c */
extern int image_buff_add(int, FIMAGE *, char *);
extern FIMAGE *image_buff_get(int);
extern void image_buff_free(int);
extern FIMAGE *image_buff_sub(FIMAGE *image2, FIMAGE *image1);

/* preferences.c */
extern void make_preferences(void);

/* dat.c */
extern void dat_init(void);
extern void dat_filter_set(char *f);
extern void dat_binning_set(int bin);
extern int dat_binning_get(void);
extern void dat_bitpix_set(int bitpix);
extern int dat_bitpix_get(void);
extern void dat_x1_set(int x1);
extern void dat_y1_set(int y1);
extern void dat_x2_set(int x2);
extern void dat_y2_set(int y2);
extern int dat_x1_get(void);
extern int dat_y1_get(void);
extern int dat_x2_get(void);
extern int dat_y2_get(void);
extern int dat_width_get(void);
extern int dat_height_get(void);
extern void dat_width_set(int x2);
extern void dat_height_set(int x2);
extern char *dat_server_get(void);
extern void dat_server_set(char *);
extern int dat_chip_get(void);
extern void dat_chip_set(int chip);
extern void dat_object_set(char *object);
extern char *dat_object_get(void);
extern void dat_observatory_set(char *object);
extern char *dat_observatory_get(void);
extern void dat_longitude_set(float);
extern float dat_longitude_get(void);
extern void dat_latitude_set(float lon);
extern float dat_latitude_get(void);
extern void dat_elevation_set(float lon);
extern float dat_elevation_get(void);
extern void dat_scale_set(float lon);
extern float dat_scale_get(void);
extern char *dat_north_get(void);
extern void dat_north_set(char *n);
extern char *dat_east_get(void);
extern void dat_east_set(char *n);
extern char *dat_west_get(void);
extern void dat_west_set(char *n);
extern char *dat_south_get(void);
extern void dat_south_set(char *n);
extern int dat_legend_get(void);
extern void dat_legend_set(int i);
extern int dat_subtractdark_get(void);
extern void dat_subtractdark_set(int i);
extern void dat_camera_set(char a);
extern char dat_camera_get(void);
extern void dat_observer_set(char *object);
extern char *dat_observer_get(void);
extern void dat_filter_set(char *f);
extern char *dat_filter_get();
extern void dat_observatory_set(char *obs);
extern char *dat_observatory_get(void);
extern char *dat_telescope_get(void);
extern void dat_telescope_set(char *tele);
extern int dat_compress_get(void);
extern void dat_compress_set(int compress);
extern char *dat_note_get(void);
extern void dat_note_set(char *note);
extern void dat_font_set(char *font);
extern char *dat_font_get(void);
extern void dat_color_set_r(int i);
extern int dat_color_get_r(void);
extern void dat_color_set_g(int i);
extern int dat_color_get_g(void);
extern void dat_color_set_b(int i);
extern int dat_color_get_b(void);
