/*

  image buffer

  $Id: image.c,v 1.15 2002-12-19 14:58:48 hroch Exp $

*/

/* the idea is: the other suroutines can write/read images only to this
   buffer, which represents memory or disk, there is no direct acces to
   this buffers 

   the buffer 0 is scientific exposure
              1 is dark

*/

#include "gtknightview.h"
#include <string.h>

#define MAXBUF 5

static FIMAGE *image[MAXBUF] = { NULL, NULL, NULL, NULL, NULL};

/* register buffer, remember pointer to memory allocated by calling
   subroutine */

int image_buff_add(int i, FIMAGE *f, char *name)
{
  if( 0 <= i && i < MAXBUF) {
    if( image[i] == NULL ) {
      image[i] = f;
      image[i]->filename = strdup(name);
#ifdef DEBUG
      printf("Image registered: %dx%d\n",image[i]->width,image[i]->height);
#endif
      return(1);
    }
  }
  return(0);
}

FIMAGE *image_buff_get(int i)
{
  if( 0 <= i && i < MAXBUF)
    return(image[i]);
  else
    return(NULL);
}

/* forget and free pointer to memory */

void image_buff_free(int i)
{
  if( image[i] != NULL ) {
    ccd_remove_image();
    free(image[i]->image);
    free(image[i]->filename);
    free(image[i]);
    image[i] = NULL;
  }
}

/* subtract image2 from image1 */
FIMAGE *image_buff_sub(FIMAGE *image2, FIMAGE *image1)
{
  FIMAGE *z;
  int x,y,i,ss;
  
  x = y = -1;
  if( (image1->width == image2->width) && (image1->height == image2->height) ) {
    x = image1->width;
    y = image1->height;
  }

  if( (x > 0 && y > 0) && 
      ((z = malloc(sizeof(FIMAGE))) && (z->image = malloc(x*y*sizeof(float)))) ) {
    z->width = x;
    z->height = y;
    z->filename = NULL;
    for( i = 0; i < x*y; i++ ) {
      ss = image2->image[i] - image1->image[i];
      if( ss < 0  )
	z->image[i] = 0;
      else if( ss > 65535 ) 
	z->image[i] = 65535;
      else
	z->image[i] = ss;
    }
    return(z);
  }
  return(NULL);
}

