/*

  camera info

  $Id: info.c,v 1.11 2006-11-29 23:07:39 hroch Exp $

*/

#include "gtknightview.h"

#define LEN 300
#define NT 2

void info(void)
{
  GtkWidget *window, *button, *clist;
  GtkStyle *style;
  char *title[NT] = {" Description           ",
		     " Value                                                "};
  char *line[NT];
  char *b;
  char fexp[LEN], ftemp[LEN], fcom[LEN];
  int i, ipix;
  int chip, width, height, binning;
  float pixwidth, pixheight,tp,texp;
  FIMAGE *imgfile;

  window = gtk_dialog_new();

  clist = gtk_clist_new_with_titles(NT,title);

  style = gtk_rc_get_style(GTK_WIDGET(window));

  /* disable title buttons */
  gtk_clist_column_titles_passive(GTK_CLIST(clist));
  /* set no select behaviour */
  gtk_clist_set_selection_mode(GTK_CLIST(clist),GTK_SELECTION_EXTENDED);
  
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(window)->vbox),clist);

  for( i = 0; i < NT; i++ )
    line[i] = malloc(LEN);

  chip = dat_chip_get();
  width = ccd_info_width(chip);
  height = ccd_info_height(chip);
  binning = dat_binning_get();
  pixwidth = ccd_info_pixwidth(chip);
  pixheight = ccd_info_pixheight(chip);

  snprintf(line[0],LEN,"Model:");
  b = ccd_get_name(chip);
  if( b )
    snprintf(line[1],LEN,"%s",b);
  else
    snprintf(line[1],LEN,"%s","Unknown device");
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"Image size:");
  snprintf(line[1],LEN,"%dx%d",width, height);
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"Binning:");
  snprintf(line[1],LEN,"%d",binning);
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"Pixel size:");
  snprintf(line[1],LEN,"%5.1fx%5.1f (microns)",pixwidth, pixheight);
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"Gain:");
  snprintf(line[1],LEN,"%5.1f e-/ADU",ccd_info_gain(chip));
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"CCD temperature:");
  snprintf(line[1],LEN,"%5.1f \260C",ccd_temp_ccd());
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"Air temperature:");
  snprintf(line[1],LEN,"%5.1f \260C",ccd_temp_air());
  gtk_clist_append(GTK_CLIST(clist),line);

  snprintf(line[0],LEN,"Dark image:");
  if( (imgfile = image_buff_get(1)) &&
      fits_keylist(imgfile->filename,"EXPTIME",fexp,fcom) == 0 &&
      fits_keylist(imgfile->filename,"TEMPERAT",ftemp,fcom) == 0 ) {
    texp = (float) atof(fexp);
    tp   = (float) atof(ftemp);
    snprintf(line[1],LEN,"%5.1f sec, %5.1f \260C",texp,tp);
  }
  else
    snprintf(line[1],LEN,"%s","Not presented");
  gtk_clist_append(GTK_CLIST(clist),line);

  for( i = 0; i < NT; i++ )
    free(line[i]);
	 
  /* set optimal column width */
  /*
  for( i = 0; i < NT; i++ ) {
    ipix = gdk_string_width(style->font,title[i]);
    gtk_clist_set_column_width (GTK_CLIST(clist),i,ipix);
  }
  */

  button = gtk_button_new_with_label("OK");
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(window)->action_area),button);

  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			    (gpointer) window);
  gtk_signal_connect_object(GTK_OBJECT(window), "key_press_event",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			    (gpointer) window);

  gtk_widget_show_all(window);
}
