/*

  control panel

  $Id: menu.c,v 1.15 2006-11-29 23:07:39 hroch Exp $

*/

#include "gtknightview.h"

static void change_chars(void)
{
    dat_x1_set(1);
    dat_y1_set(1);
    dat_x2_set(ccd_info_width(dat_chip_get()));
    dat_y2_set(ccd_info_height(dat_chip_get()));
}

static void set_legend(gpointer data, guint action, GtkCheckMenuItem *legend)
{

  if( legend->active )
    dat_legend_set(1);
  else
    dat_legend_set(0);

}

static void set_darks(gpointer data, guint action, GtkCheckMenuItem *darks)
{

  if( darks->active )
    dat_subtractdark_set(1);
  else
    dat_subtractdark_set(0);

}

static void set_bin(gpointer data, guint action, GtkRadioMenuItem *bin)
{

  if( GTK_CHECK_MENU_ITEM(bin)->active ) {
    dat_binning_set(action);
    dat_x1_set(1);
    dat_y1_set(1);
    dat_x2_set(ccd_info_width(dat_chip_get()));
    dat_y2_set(ccd_info_height(dat_chip_get()));
    show_status("Binning changed.");
  }

}

static void set_cam(gpointer data, guint action, GtkRadioMenuItem *cam)
{

  if( GTK_CHECK_MENU_ITEM(cam)->active ) {
    if( action == 2 )
      dat_camera_set('T');
    else
      dat_camera_set('I');
    change_chars();
    show_status("Camera changed.");
  }
}

GtkWidget *make_main_menu(GtkWidget *panel)
{
  GtkItemFactory *item_factory;
  static GtkItemFactoryEntry menu_items[] = {
    { "/_File",       "<alt>F", NULL, 0, "<Branch>"},
    { "/_File/_Open", "<control>O", open_fits, 0, NULL},
    { "/_File/_Save", "<control>S", save_fits, 0, NULL},
    { "/_File/", NULL, NULL, 0, "<Separator>"},
    { "/_File/_Exit", "<alt>q",  quit_soft, 0, NULL},
    { "/_Settings",       "<alt>S", NULL, 0, "<Branch>"},
    { "/_Settings/_Binning", "<control>B", NULL, 0, "<Branch>" },
    { "/_Settings/_Binning/_1x1", "<control>3", set_bin, 1, "<RadioItem>" },
    { "/_Settings/_Binning/_2x2", "<control>2", set_bin, 2, "/Settings/Binning/1x1" },
    { "/_Settings/_Binning/_3x3", "<control>1", set_bin, 3, "/Settings/Binning/1x1" },
    { "/_Settings/_Camera", "<control>C", NULL, 0, "<Branch>" },
    { "/_Settings/_Camera/_Imaging", "<control>I", set_cam, 1, "<RadioItem>" },
    { "/_Settings/_Camera/_Tracking", "<control>T", set_cam, 2,"/Settings/Camera/Imaging"  },
    { "/_Settings/", NULL, NULL, 0, "<Separator>"},
    { "/_Settings/Enable _Legend", "<control>L", set_legend, 0, "<ToggleItem>" },
    /*
    { "/_Settings/Subt_ract Dark", "<control>R", set_darks, 0, "<ToggleItem>" },
    */
    { "/_Settings/", NULL, NULL, 0, "<Separator>"},
    { "/_Settings/_Preferences..", "<control>P", make_preferences, 0, NULL},
    { "/_Help",       "<alt>H", NULL, 0, "<LastBranch>"},
    { "/_Help/_Camera Info..", NULL, info, 0, NULL},
    { "/_Help/_About..",       NULL, about, 0, NULL}
  };
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, 
				       "<main>", accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, menu_items);
  gtk_window_add_accel_group (GTK_WINDOW (panel), accel_group);


  if( dat_legend_get()  )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
     gtk_item_factory_get_item(item_factory, "/Settings/Enable Legend")),TRUE);
  /*
  if( dat_subtractdark_get() )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_item(
			 item_factory, "/Settings/Subtract Dark")),TRUE);  
  */

  if( dat_binning_get() == 1 )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
       gtk_item_factory_get_item(item_factory, "/Settings/Binning/1x1")),TRUE);
  if( dat_binning_get() == 2 )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
       gtk_item_factory_get_item(item_factory, "/Settings/Binning/2x2")),TRUE);
  if( dat_binning_get() == 3 )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
       gtk_item_factory_get_item(item_factory, "/Settings/Binning/3x3")),TRUE);

  if( dat_camera_get() == 'I' )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
      gtk_item_factory_get_item(item_factory, "/Settings/Camera/Imaging")),TRUE);
  if( dat_camera_get() == 'T' )
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
     gtk_item_factory_get_item(item_factory, "/Settings/Camera/Tracking")),TRUE);

  return(gtk_item_factory_get_widget (item_factory, "<main>"));
}

