/*

  control panel

  $Id: panel.c,v 1.2 2001-09-17 13:14:18 hroch Exp $

*/

#include "gtknightview.h"

GtkWidget *control_panel_new(void)
{
  GtkWidget *panel;
  GtkWidget *vbox, *hbox;
  GtkWidget *menu;
  GtkWidget *temperature, *power, *status, *exposure, *filter, *graph;

  /* main window */
  panel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(panel), "Control Panel");
  gtk_widget_show(panel);

  /* main vbox */
  vbox = gtk_vbox_new(FALSE, FB);
  gtk_container_add (GTK_CONTAINER (panel), vbox);
  gtk_widget_show(vbox);

  /* menu */
  menu = make_main_menu(panel);
  gtk_container_add (GTK_CONTAINER (vbox), menu);
  gtk_widget_show(menu);

  /* graphics */
  graph = make_graph(panel);
  gtk_container_add (GTK_CONTAINER (vbox), graph);
  gtk_widget_show(graph);

  /* exposure */
  exposure = make_exposure(panel);
  gtk_container_add (GTK_CONTAINER (vbox), exposure);
  gtk_widget_show(exposure);

  /* filters */
  filter = make_filter(panel);
  gtk_container_add (GTK_CONTAINER (vbox), filter);
  gtk_widget_show(filter);

  /* temperature and power hbox */
  hbox = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(vbox),hbox);
  gtk_widget_show(hbox);

  temperature = make_temperature(panel);
  gtk_container_add (GTK_CONTAINER (hbox), temperature);
  gtk_widget_show(temperature);  

  power = make_power(panel);
  gtk_container_add (GTK_CONTAINER (hbox), power);
  gtk_widget_show(power);

  /* status bar(s) */
  status = make_status(panel);
  gtk_container_add (GTK_CONTAINER (vbox), status);
  gtk_widget_show(status);  

  return(panel);
}
  
