/*

  power indication

  $Id: power.c,v 1.9 2006-11-29 23:07:39 hroch Exp $

*/

#include "gtknightview.h"


static void power_switch(GtkWidget *power)
{
  if( GTK_TOGGLE_BUTTON (power)->active ) { /* switch power on */
    if( ccd_power_on(dat_server_get()) ) {
      dat_x1_set(1);
      dat_y1_set(1);
      dat_x2_set(ccd_info_width(0));
      dat_y2_set(ccd_info_height(0));
      show_status("Camera on.");
      temperature_init();
      filter_ini();
    }
    else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (power),FALSE);
      show_status("Connection to camera failed."); }}
  else {
    filter_clear();
    temperature_shutdown();
    ccd_power_off();
    show_status("Camera off.");
  }
}


GtkWidget *make_power(GtkWidget *panel)
{
  GtkWidget *frame, *button;

  frame = gtk_frame_new("Power");
  
  button = gtk_toggle_button_new_with_label(" On/Off ");
  gtk_container_set_border_width (GTK_CONTAINER (button), FB);
  gtk_container_add(GTK_CONTAINER(frame),button);
  gtk_widget_show(button);

  gtk_signal_connect(GTK_OBJECT(button),"toggled",
		     GTK_SIGNAL_FUNC(power_switch), NULL);

  return(frame);
}
