/*

  control panel

  $Id: prefer.c,v 1.17 2006-11-29 23:07:39 hroch Exp $

*/

#include "nightview.h"
#include "gtknightview.h"

#define LEN 250

/* global variables */
static double rgb[3];
static GtkWidget *colordig;
static GtkWidget *fontdig;

/* parameters */
static char *d_server = NULL;
static char *d_observer;
static char *d_object;
static char *d_note; 
static char *d_n;
static char *d_e;
static char *d_w;
static char *d_s;
static float d_scale;
static int d_x1,d_y1,d_x2,d_y2;

static const char *netlabel[2] = {"Local connection", "Remote to host:"};
static int net_server = 0;
static GtkWidget *ser;

static void copy_param(void)
{
  d_object = strdup(dat_object_get());
  d_server = strdup(dat_server_get());
  if( strcmp(d_server,NIGHT_LOCALHOST) == 0 ) {
    net_server = 0;
    d_server = strdup("localhost");
  }
  else
    net_server = 1;
  d_observer = strdup(dat_observer_get());
  d_note = strdup(dat_note_get());
  d_n = strdup(dat_north_get());
  d_e = strdup(dat_east_get());
  d_w = strdup(dat_west_get());
  d_s = strdup(dat_south_get());
  d_scale = dat_scale_get();
  d_x1 = dat_x1_get();
  d_y1 = dat_y1_get();
  d_x2 = dat_x2_get();
  d_y2 = dat_y2_get();
  if( d_x2 < d_x1 )
    d_x2 = d_x1;
  if( d_y2 < d_y1 )
    d_y2 = d_y1;
}

static void keep_param(void)
{
  if( net_server == 0 )
    dat_server_set(strdup(NIGHT_LOCALHOST));
  else
    dat_server_set(strdup(d_server));
  dat_object_set(strdup(d_object));
  dat_observer_set(strdup(d_observer));
  dat_note_set(strdup(d_note));
  dat_north_set(strdup(d_n));
  dat_east_set(strdup(d_e));
  dat_west_set(strdup(d_w));
  dat_south_set(strdup(d_s));
  dat_scale_set(d_scale);
  dat_x1_set(d_x1);
  dat_y1_set(d_y1);
  dat_x2_set(d_x2);
  dat_y2_set(d_y2);
#ifdef DEBUG
  printf("%d %d %d %d\n",d_x1,d_y1,d_x2,d_y2);
#endif
}

static void free_param(void)
{
  free(d_server);
  d_server = NULL;
  free(d_observer);
  free(d_object);
  free(d_note);
  free(d_n);
  free(d_e);
  free(d_w);
  free(d_s);
}

static void win_cancel(GtkWidget *widget, GtkWidget *win)
{
  free_param();
  gtk_widget_destroy(win);
}


static void win_ok(GtkWidget *widget, GtkWidget *win)
{
  keep_param();
  free_param();
  obr_redraw();
  gtk_widget_destroy(win);
}

static void set_object(GtkWidget *widget, GtkWidget *objname)
{
  d_object = strdup(gtk_entry_get_text(GTK_ENTRY(objname)));
}

static void set_obsname(GtkWidget *widget, GtkWidget *obsname)
{
  d_observer = strdup(gtk_entry_get_text(GTK_ENTRY(obsname)));
}

static void set_note(GtkWidget *widget, GtkEntry *note)
{
  d_note = strdup(gtk_entry_get_text(note));
}

static void set_scale(GtkSpinButton *scale)
{
  d_scale = gtk_spin_button_get_value_as_float(scale);
}

static void set_ser(GtkWidget *widget, GtkWidget *server)
{
  free(d_server);
  d_server = strdup(gtk_entry_get_text(GTK_ENTRY(server)));
}

static void set_south(GtkWidget *button)
{
  char *p;

  if( GTK_TOGGLE_BUTTON (button)->active )
    p = "S";
  else
    p = "";

  free(d_s);
  d_s = strdup(p);
}

static void set_north(GtkWidget *button)
{
  char *p;

  if( GTK_TOGGLE_BUTTON (button)->active )
    p = "N";
  else
    p = "";

  free(d_n);
  d_n = strdup(p);
}

static void set_west(GtkWidget *button)
{
  char *p;

  if( GTK_TOGGLE_BUTTON (button)->active )
    p = "W";
  else
    p = "";

  free(d_w);
  d_w = strdup(p);
}

static void set_east(GtkWidget *button)
{
  char *p;

  if( GTK_TOGGLE_BUTTON (button)->active )
    p = "E";
  else
    p = "";

  free(d_e);
  d_e = strdup(p);
}

static void set_font(GtkWidget *widget, gpointer save)
{
  char *font;

  if( (int) save ) {
    font = gtk_font_selection_dialog_get_font_name(
	   GTK_FONT_SELECTION_DIALOG(fontdig));
#ifdef DEBUG
    printf("%s\n",font);
#endif
    if( font ) 
      set_legend_font(font);
  }
  gtk_widget_destroy(fontdig);
}

static void setnet(GtkWidget *w, char *label)
{
  if( GTK_TOGGLE_BUTTON(w)->active ) {
    if( strcmp(label,netlabel[0]) == 0 ) { /* local */
      net_server = 0;
      gtk_editable_set_editable(GTK_EDITABLE(ser),FALSE);
    }
    if( strcmp(label,netlabel[1]) == 0 ) { /* remote */
      net_server = 1;
      gtk_editable_set_editable(GTK_EDITABLE(ser),TRUE);
    }
  }
}

static void show_fonts(GtkWidget *button)
{
  GtkWidget  *ok, *cancel;

  fontdig = gtk_font_selection_dialog_new("Select font for labels");
  cancel = GTK_FONT_SELECTION_DIALOG(fontdig)->cancel_button;
  ok = GTK_FONT_SELECTION_DIALOG(fontdig)->ok_button;  
  gtk_signal_connect(GTK_OBJECT(ok), "clicked",
		     (GtkSignalFunc)set_font, (gpointer) TRUE);
  gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
		     (GtkSignalFunc)set_font, (gpointer) FALSE);
  gtk_font_selection_dialog_set_preview_text(
           GTK_FONT_SELECTION_DIALOG(fontdig),"N E W S 1'");
  gtk_widget_show(fontdig);  

}

static void change_color(GtkWidget *widget, GtkColorSelection *colorsel)
{
  gtk_color_selection_get_color (colorsel,rgb);
}

static void set_color(GtkWidget *widget, gpointer save)
{
  GdkColor c;

  if( (int) save ) {
#ifdef DEBUG
    printf("%f %f %f\n",rgb[0],rgb[1],rgb[2]);
#endif
    c.red   = (guint16)(rgb[0]*65535.0);
    c.green = (guint16)(rgb[1]*65535.0);
    c.blue  = (guint16)(rgb[2]*65535.0);

    set_legend_color(&c);
  }
  gtk_widget_destroy(colordig);
}

static void show_colors(GtkWidget *button)
{
  GtkWidget *colorsel, *ok, *cancel;

  colordig = gtk_color_selection_dialog_new("Select legend's font color");
  colorsel = GTK_COLOR_SELECTION_DIALOG(colordig)->colorsel;
  cancel = GTK_COLOR_SELECTION_DIALOG(colordig)->cancel_button;
  ok = GTK_COLOR_SELECTION_DIALOG(colordig)->ok_button;
  gtk_signal_connect(GTK_OBJECT(colorsel), "color_changed",
		     (GtkSignalFunc)change_color, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(ok), "clicked",
		     (GtkSignalFunc)set_color, (gpointer) TRUE);
  gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
		     (GtkSignalFunc)set_color, (gpointer) FALSE);

  gtk_widget_show(colordig);
}

static void subset_full(GtkButton *b)
{
  d_x1 = 1;
  d_y1 = 1;
  d_x2 = ccd_info_width(dat_chip_get());
  d_y2 = ccd_info_height(dat_chip_get());
  set_subimage(d_x1,d_y1,d_x2,d_y2);

#ifdef DEBUG
  printf("Full area: %d %d %d %d\n",d_x1,d_y1,d_x2,d_y2);
#endif
}

static void subset_show(GtkToggleButton *b)
{
  if( gtk_toggle_button_get_active(b) )
    set_draw_subimage(TRUE);
  else
    set_draw_subimage(FALSE);
}

static void set_x1(GtkSpinButton *s)
{
  d_x1 = gtk_spin_button_get_value_as_int (s);
  set_subimage(d_x1, d_y1, d_x2-d_x1, d_y2-d_y1);
#ifdef DEBUG_EXTRA
  printf("x1 = %d\n",d_x1);
#endif
}

static void set_y1(GtkSpinButton *s)
{
  d_y1 = gtk_spin_button_get_value_as_int (s);
  set_subimage(d_x1, d_y1, d_x2-d_x1, d_y2-d_y1);
#ifdef DEBUG_EXTRA
  printf("y1= %d\n",d_y1);
#endif
}

static void set_x2(GtkSpinButton *s)
{
  d_x2 = gtk_spin_button_get_value_as_int (s);
  set_subimage(d_x1, d_y1, d_x2-d_x1, d_y2-d_y1);
#ifdef DEBUG_EXTRA
  printf("x2 = %d\n",d_x2);
#endif
}

static void set_y2(GtkSpinButton *s)
{
  d_y2 = gtk_spin_button_get_value_as_int (s);
  set_subimage(d_x1, d_y1, d_x2-d_x1, d_y2-d_y1);
#ifdef DEBUG_EXTRA
  printf("y2= %d\n",d_y2);
#endif
}

void make_preferences(void)
{
  GtkWidget *win, *vbox, *notebook, *observer, *object, *note;
  GtkWidget *news, *fscale, *scale,  *north, *east, *west, *south;
  GtkWidget *vbox_g, *vbox_l, *general, *legend, *vnews, *hscale, *mscale;
  GtkWidget *ok, *cancel, *bhbox, *hnews;
  GtkWidget *notetext, *obsname;
  GtkWidget *vbox_s, *subimage, *objname;
  GtkWidget *vbox_n, *fnet, *hnet, *labser, *network;
  GtkWidget *fontcolor, *fcolor, *bcolor, *bfont, *ffont;
  GtkWidget *isub_lb, *isub_rt, *hbox_subset, *subset1, *subset2;
  GtkObject *adj_l, *adj_d, *adj_r, *adj_u;
  GtkWidget *hbox_lb, *x1, *label_x1, *y1, *label_y1;
  GtkWidget *hbox_rt, *x2, *label_x2, *y2, *label_y2;
  GtkObject *adj;
  GtkWidget *netbut[2], *vnet;
  GSList *netcon;
  int x;

  copy_param();

  /* window */
  win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(win), "Preferences");
  gtk_widget_show(win);
  gtk_container_set_border_width (GTK_CONTAINER (win), FB);

  vbox = gtk_vbox_new(FALSE, FB);
  gtk_container_add (GTK_CONTAINER (win), vbox);
  gtk_widget_show(vbox);

  /* general preferences */
  vbox_g = gtk_vbox_new(FALSE, FB);
  gtk_widget_show(vbox_g);

  object = gtk_frame_new(" Object ");
  gtk_container_add (GTK_CONTAINER (vbox_g), object);
  gtk_widget_show(object);
  
  objname = gtk_entry_new();
  gtk_container_add (GTK_CONTAINER (object),objname);
  gtk_widget_show(objname);
  gtk_entry_set_text(GTK_ENTRY(objname),d_object);
  gtk_signal_connect(GTK_OBJECT(objname),"changed",
		     GTK_SIGNAL_FUNC(set_object), objname);

  observer = gtk_frame_new(" Observer ");
  gtk_container_add (GTK_CONTAINER (vbox_g), observer);
  gtk_widget_show(observer);
  
  obsname = gtk_entry_new();
  gtk_container_add (GTK_CONTAINER (observer),obsname);
  gtk_widget_show(obsname);
  gtk_entry_set_text(GTK_ENTRY(obsname),d_observer);
  gtk_signal_connect(GTK_OBJECT(obsname),"changed",
		     GTK_SIGNAL_FUNC(set_obsname), obsname);

  note = gtk_frame_new(" Comment ");
  gtk_container_add (GTK_CONTAINER (vbox_g), note);
  gtk_widget_show(note);
  
  notetext = gtk_entry_new();
  gtk_container_add (GTK_CONTAINER (note),notetext);
  gtk_widget_show(notetext);
  gtk_entry_set_text(GTK_ENTRY(notetext),d_note);
  gtk_signal_connect(GTK_OBJECT(notetext),"changed",
		     GTK_SIGNAL_FUNC(set_note), notetext);

  general = gtk_label_new("General");

  /* legend */
  vbox_l = gtk_vbox_new(FALSE, FB);
  gtk_widget_show(vbox_l);

  hnews = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(vbox_l),hnews);
  gtk_widget_show(hnews);

  news = gtk_frame_new(" Label ");
  gtk_container_add (GTK_CONTAINER (hnews), news);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_l), FB);
  gtk_widget_show(news);

  vnews =gtk_vbox_new(FALSE, FB);
  gtk_container_add (GTK_CONTAINER (news), vnews);
  gtk_widget_show(vnews);

  north = gtk_check_button_new_with_label("North");
  gtk_container_add (GTK_CONTAINER (vnews), north);
  gtk_widget_show(north);
  if( strlen(d_n) > 0 ) 
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(north),TRUE);
  gtk_signal_connect(GTK_OBJECT(north),"toggled",
		     GTK_SIGNAL_FUNC(set_north),NULL);

  east = gtk_check_button_new_with_label("East");
  gtk_container_add (GTK_CONTAINER (vnews), east);
  gtk_widget_show(east);
  if( strlen(d_e) > 0 ) 
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(east),TRUE);
  gtk_signal_connect(GTK_OBJECT(east),"toggled",
		     GTK_SIGNAL_FUNC(set_east),NULL);

  west = gtk_check_button_new_with_label("West");
  gtk_container_add (GTK_CONTAINER (vnews), west);
  gtk_widget_show(west);
  if( strlen(d_w) > 0 ) 
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(west),TRUE);
  gtk_signal_connect(GTK_OBJECT(west),"toggled",
		     GTK_SIGNAL_FUNC(set_west),NULL);

  south = gtk_check_button_new_with_label("South");
  gtk_container_add (GTK_CONTAINER (vnews), south);
  gtk_widget_show(south);
  if( strlen(d_s) > 0 ) 
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(south),TRUE);
  gtk_signal_connect(GTK_OBJECT(south),"toggled",
		     GTK_SIGNAL_FUNC(set_south),NULL);

  fontcolor = gtk_vbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(hnews),fontcolor);
  gtk_widget_show(fontcolor);

  fcolor = gtk_frame_new(" Color ");
  gtk_container_add (GTK_CONTAINER (fontcolor), fcolor);
  gtk_container_set_border_width (GTK_CONTAINER (hnews), FB);
  gtk_widget_show(fcolor);

  bcolor = gtk_button_new_with_label(" Color ");
  gtk_container_add (GTK_CONTAINER (fcolor),bcolor);
  gtk_widget_show(bcolor);
  gtk_signal_connect(GTK_OBJECT(bcolor),"clicked",
		     GTK_SIGNAL_FUNC(show_colors), NULL);

  ffont = gtk_frame_new(" Font ");
  gtk_container_add (GTK_CONTAINER (fontcolor), ffont);
  gtk_container_set_border_width (GTK_CONTAINER (hnews), FB);
  gtk_widget_show(ffont);

  bfont = gtk_button_new_with_label(" Font ");
  gtk_container_add (GTK_CONTAINER (ffont),bfont);
  gtk_widget_show(bfont);
  gtk_signal_connect(GTK_OBJECT(bfont),"clicked",
		     GTK_SIGNAL_FUNC(show_fonts), NULL);

  fscale = gtk_frame_new(" Image scale ");
  gtk_container_add (GTK_CONTAINER (vbox_l), fscale);
  gtk_container_set_border_width (GTK_CONTAINER (fscale), FB);
  gtk_widget_show(fscale);

  hscale = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(fscale),hscale);
  gtk_widget_show(hscale);

  adj = gtk_adjustment_new(d_scale,1e-6,1e6,0.1,1.0,0.0);
  scale = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 2);
  gtk_container_add(GTK_CONTAINER(hscale),scale);
  gtk_widget_show(scale);
  gtk_signal_connect(GTK_OBJECT(scale),"changed",
		     GTK_SIGNAL_FUNC(set_scale),NULL);

  mscale = gtk_label_new("pixel per arcsecond");
  gtk_container_add(GTK_CONTAINER(hscale),mscale);
  gtk_widget_show(mscale);

  legend = gtk_label_new("Legend");

  /* subimage */
  vbox_s = gtk_vbox_new(FALSE, FB);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_s), FB);
  gtk_widget_show(vbox_s);

  isub_lb = gtk_frame_new(" Left bottom corner ");
  gtk_container_add (GTK_CONTAINER (vbox_s), isub_lb);
  gtk_widget_show(isub_lb);

  hbox_lb = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(isub_lb),hbox_lb);
  gtk_widget_show(hbox_lb);

  label_x1 = gtk_label_new(" X: ");
  gtk_container_add(GTK_CONTAINER(hbox_lb),label_x1);
  gtk_widget_show(label_x1);

  x = MAX(ccd_info_width(dat_chip_get()),dat_width_get());
  adj_l = gtk_adjustment_new((gdouble)d_x1,1.0,(gdouble)x,1.0,100.0,0.0);
  x1 = gtk_spin_button_new(GTK_ADJUSTMENT(adj_l), 1.0, 0);
  gtk_container_add(GTK_CONTAINER(hbox_lb),x1);
  gtk_widget_show(x1);
  gtk_signal_connect(GTK_OBJECT(x1),"changed",
		     GTK_SIGNAL_FUNC(set_x1),NULL);

  label_y1 = gtk_label_new(" Y: ");
  gtk_container_add(GTK_CONTAINER(hbox_lb),label_y1);
  gtk_widget_show(label_y1);

  x = MAX(ccd_info_height(dat_chip_get()),dat_height_get());
  adj_d = gtk_adjustment_new((gdouble)d_y1,1.0,(gdouble)x,1.0,100.0,0.0);
  y1 = gtk_spin_button_new(GTK_ADJUSTMENT(adj_d), 1.0, 0);
  gtk_container_add(GTK_CONTAINER(hbox_lb),y1);
  gtk_widget_show(y1);
  gtk_signal_connect(GTK_OBJECT(y1),"changed",
		     GTK_SIGNAL_FUNC(set_y1),NULL);

  isub_rt = gtk_frame_new(" Right top corner ");
  gtk_container_add (GTK_CONTAINER (vbox_s), isub_rt);
  gtk_widget_show(isub_rt);

  hbox_rt = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(isub_rt),hbox_rt);
  gtk_widget_show(hbox_rt);

  label_x2 = gtk_label_new(" X: ");
  gtk_container_add(GTK_CONTAINER(hbox_rt),label_x2);
  gtk_widget_show(label_x2);

  x = MAX(ccd_info_width(dat_chip_get()),dat_width_get());
  adj_r = gtk_adjustment_new((gdouble)d_x2,(gdouble)1,(gdouble)x,1.0,100.0,0.0);
  x2 = gtk_spin_button_new(GTK_ADJUSTMENT(adj_r), 1.0, 0);
  gtk_container_add(GTK_CONTAINER(hbox_rt),x2);
  gtk_widget_show(x2);
  gtk_signal_connect(GTK_OBJECT(x2),"changed",
		     GTK_SIGNAL_FUNC(set_x2),NULL);

  label_y2 = gtk_label_new(" Y: ");
  gtk_container_add(GTK_CONTAINER(hbox_rt),label_y2);
  gtk_widget_show(label_y2);

  x = MAX(ccd_info_height(dat_chip_get()),dat_height_get());
  adj_u = gtk_adjustment_new((gdouble)d_y2,(gdouble)1,(gdouble)x,1.0,100.0,0.0);
  y2 = gtk_spin_button_new(GTK_ADJUSTMENT(adj_u), 1.0, 0);
  gtk_container_add(GTK_CONTAINER(hbox_rt),y2);
  gtk_widget_show(y2);
  gtk_signal_connect(GTK_OBJECT(y2),"changed",
		     GTK_SIGNAL_FUNC(set_y2),NULL);


  hbox_subset = gtk_hbox_new(FALSE,FB);
  gtk_container_add(GTK_CONTAINER(vbox_s),hbox_subset);
  gtk_widget_show(hbox_subset);

  subset1 = gtk_toggle_button_new_with_label(" Show/hide selector ");
  gtk_container_add(GTK_CONTAINER(hbox_subset),subset1);
  gtk_widget_show(subset1);
  gtk_signal_connect(GTK_OBJECT(subset1),"toggled",
		     GTK_SIGNAL_FUNC(subset_show), NULL);
  
  subset2 = gtk_button_new_with_label(" Reset to full area ");
  gtk_container_add(GTK_CONTAINER(hbox_subset),subset2);
  gtk_widget_show(subset2);
  gtk_signal_connect(GTK_OBJECT(subset2),"clicked",
		     GTK_SIGNAL_FUNC(subset_full), NULL);

  subimage = gtk_label_new("Subimage");

  /* network */
  vbox_n = gtk_vbox_new(FALSE, FB);
  gtk_widget_show(vbox_n);

  fnet = gtk_frame_new(" Network ");
  gtk_container_add (GTK_CONTAINER (vbox_n), fnet);
  gtk_container_set_border_width (GTK_CONTAINER (fnet), FB);
  gtk_widget_show(fnet);

  vnet = gtk_vbox_new(FALSE, FB);
  gtk_container_add (GTK_CONTAINER (fnet), vnet);
  gtk_widget_show(vnet);

  /* remote or local connect */
  netcon = NULL;
  netbut[0] = gtk_radio_button_new_with_label(netcon,netlabel[0]);
  gtk_container_add(GTK_CONTAINER(vnet),netbut[0]);
  gtk_widget_show(netbut[0]);

  netcon = gtk_radio_button_group(GTK_RADIO_BUTTON(netbut[0]));
  netbut[1] = gtk_radio_button_new_with_label(netcon,netlabel[1]);
  gtk_container_add(GTK_CONTAINER(vnet),netbut[1]);
  gtk_widget_show(netbut[1]);  

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (netbut[net_server]), TRUE);

  hnet = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(vnet),hnet);
  gtk_widget_show(hnet);

  /*
  labser = gtk_label_new("host: ");
  gtk_container_add(GTK_CONTAINER(hnet),labser);
  gtk_widget_show(labser);
  */  

  ser = gtk_entry_new();
  gtk_container_add(GTK_CONTAINER(hnet),ser);
  gtk_entry_set_text(GTK_ENTRY(ser),d_server);
  gtk_widget_show(ser);
  gtk_signal_connect(GTK_OBJECT(ser),"changed",
		     GTK_SIGNAL_FUNC(set_ser), ser);

  gtk_signal_connect(GTK_OBJECT(netbut[0]),"toggled",
		     GTK_SIGNAL_FUNC(setnet),(gpointer) netlabel[0]);
  gtk_signal_connect(GTK_OBJECT(netbut[1]),"toggled",
		     GTK_SIGNAL_FUNC(setnet),(gpointer) netlabel[1]);

  if( net_server == 0 )
    gtk_editable_set_editable(GTK_EDITABLE(ser),FALSE);

  network = gtk_label_new("Network");

  /* all page */
  notebook = gtk_notebook_new();
  gtk_container_add (GTK_CONTAINER (vbox), notebook);
  gtk_widget_show(notebook);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox_g,general);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox_l,legend);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox_s,subimage);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox_n,network);

  /* buttons */
  bhbox = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(vbox),bhbox);
  gtk_widget_show(bhbox);

  cancel = gtk_button_new_with_label(" Cancel ");
  gtk_container_add(GTK_CONTAINER(bhbox),cancel);
  gtk_widget_show(cancel);
  gtk_signal_connect(GTK_OBJECT(cancel),"clicked",
		     GTK_SIGNAL_FUNC(win_cancel),win);

  ok     = gtk_button_new_with_label("   OK   ");
  gtk_container_add(GTK_CONTAINER(bhbox),ok);
  gtk_widget_show(ok);
  gtk_signal_connect(GTK_OBJECT(ok),"clicked",
		     GTK_SIGNAL_FUNC(win_ok),win);
}
