/*

  RC init

  $Id: rc.c,v 1.21 2006-11-29 23:07:39 hroch Exp $

*/

#include "nightview.h"
#include "gtknightview.h"
#include "rcfile.h"


/* name of the RC's file */
#define RCNAME "gtknightview"

/* length of string's */
#define LEN 80 

#define BLEN 200

/* format of string's, the digits must (!!) by the same as LEN */
#define FSTR "%80[^']"

/* try read files path[i]/name to initialize widget styles,
   path[] ended with NULL */

int rc_init(char *name, char *path[])
{
  int i;
  char buf[BLEN];
  char line[LEN];
  char *val;
  FILE *rc;
  float x;
  char t;
  int c_r, c_g, c_b;

  for( i = 0; path[i] != NULL; i++) {
    sprintf(buf,"%s/%s",path[i],name);
    /*    printf("Parsing %s\n",buf);*/
    gtk_rc_parse(buf); }

  for( i = 0; path[i] != NULL; i++) {
    sprintf(buf,"%s/.%s",path[i],name);
    /*    printf("Parsing %s\n",buf);*/
    gtk_rc_parse(buf); }  

  /*
  dat_object_set("Object");
  dat_observer_set("Observer");
  dat_observatory_set("Observatory");
  dat_longitude_set(0.0);
  dat_latitude_set(0.0);
  dat_elevation_set(0.0);
  dat_scale_set(1.0);
  dat_x1_set(1);
  dat_y1_set(1);
  dat_x2_set(-1);
  dat_y2_set(-1);
  dat_bitpix_set(16);
  dat_binning_set(1);
  dat_camera_set('I');
  dat_server_set("file:///tmp/.night_shock");
  dat_subtractdark_set(1);
  dat_legend_set(1);
  dat_north_set("N");
  dat_west_set("W");
  dat_east_set("E");
  dat_south_set("S");
  dat_filter_set("");
  */

  /* read the rc file */
  snprintf(buf,BLEN,"%s/.%s",getenv("HOME"),RCNAME);
  if( (rc = rc_open(buf,"r")) != NULL ) {
    while( rc_gets(line,LEN,rc) != NULL ) {
      if( (val = strchr(line,'=')) && strstr(line,"Object") ) {
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_object_set(strdup(buf));
      }
      if( (val = strchr(line,'=')) && strstr(line,"Observer") ) {
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_observer_set(strdup(buf));
      }
      /*
      if( (val = strchr(line,'=')) && strstr(line,"Station site") ) {
	d->station = malloc(LEN); strcpy(d->station,"");
        sscanf(strchr(line,'\'')+1,FSTR,d->station); 
      }
      if( (val = strchr(line,'=')) && strstr(line,"Station longitude") ) {
        sscanf(val+1,"%f",&(d->station_long)); }
      if( (val = strchr(line,'=')) && strstr(line,"Station latitude") ) {
        sscanf(val+1,"%f",&(d->station_lat)); }
      if( (val = strchr(line,'=')) && strstr(line,"Station elevation") ) {
        sscanf(val+1,"%f",&(d->station_elev)); }
      */
      if( (val = strchr(line,'=')) && strstr(line,"Image scale") ) {
        sscanf(val+1,"%f",&x);
	dat_scale_set(x);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Left bottom x subimage coordinate") ) {
        sscanf(val+1,"%d",&i);
	dat_x1_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Left bottom y subimage coordinate") ) {
        sscanf(val+1,"%d",&i);
	dat_y1_set(i); 
      }
      if( (val = strchr(line,'=')) && strstr(line,"Right top x subimage coordinate") ) {
        sscanf(val+1,"%d",&i);
	dat_x2_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Right top y subimage coordinate") ) {
        sscanf(val+1,"%d",&i);
	dat_y2_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Camera binning") ) {
        sscanf(val+1,"%d",&i);
	dat_binning_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Camera chip select") ) {
        sscanf(val + strcspn(val," ")+1,"%c",&t);
	dat_camera_set(t);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Server address") ) {
        sscanf(val+1,"%s",buf);
	dat_server_set(strdup(buf));
      }
      if( (val = strchr(line,'=')) && strstr(line,"Subtract dark") ) {
        sscanf(val+1,"%d",&i);
	dat_subtractdark_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Compress") ) {
        sscanf(val+1,"%d",&i);
	dat_compress_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Enable Legend") ) {
        sscanf(val+1,"%d",&i);
	dat_legend_set(i);
      }
      if( (val = strchr(line,'=')) && strstr(line,"Enable North") ) {
	buf[0] = '\0';
        sscanf(strchr(line,'\'')+1,FSTR,buf);
        dat_north_set(strdup(buf));
      }
      if( (val = strchr(line,'=')) && strstr(line,"Enable East") ) {
	buf[0] = '\0';
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_east_set(strdup(buf));
      }
      if( (val = strchr(line,'=')) && strstr(line,"Enable West") ) {
	buf[0] = '\0';
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_west_set(strdup(buf));
      }
      if( (val = strchr(line,'=')) && strstr(line,"Enable South") ) {
	buf[0] = '\0';
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_south_set(strdup(buf));
      }
      /*
      if( (val = strchr(line,'=')) && strstr(line,"Filter 1") ) {
	d->filters[0] = malloc(LEN); strcpy(d->filters[0],"");
        sscanf(strchr(line,'\'')+1,FSTR,d->filters[0]);}
      if( (val = strchr(line,'=')) && strstr(line,"Filter 2") ) {
	d->filters[1] = malloc(LEN); strcpy(d->filters[1],"");
        sscanf(strchr(line,'\'')+1,FSTR,d->filters[1]);}
      if( (val = strchr(line,'=')) && strstr(line,"Filter 3") ) {
	d->filters[2] = malloc(LEN); strcpy(d->filters[2],"");
        sscanf(strchr(line,'\'')+1,FSTR,d->filters[2]);}
      if( (val = strchr(line,'=')) && strstr(line,"Filter 4") ) {
	d->filters[3] = malloc(LEN); strcpy(d->filters[3],"");
        sscanf(strchr(line,'\'')+1,FSTR,d->filters[3]);}
      if( (val = strchr(line,'=')) && strstr(line,"Filter 5") ) {
	d->filters[4] = malloc(LEN); strcpy(d->filters[4],"");
        sscanf(strchr(line,'\'')+1,FSTR,d->filters[4]);}
      if( (val = strchr(line,'=')) && strstr(line,"Filter selected") ) {
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_filter_set(strdup(buf));
      }
      */
      if( (val = strchr(line,'=')) && strstr(line,"Font") ) {
        sscanf(strchr(line,'\'')+1,FSTR,buf);
	dat_font_set(strdup(buf));
      }
      if( (val = strchr(line,'=')) && strstr(line,"Color") ) {
        sscanf(val+1,"%d %d %d",&c_r,&c_g,&c_b);
	dat_color_set_r(c_r);
	dat_color_set_g(c_g);
	dat_color_set_b(c_b);
      }

    }
    rc_close(rc);
  }

  return(TRUE);
}

void rc_save(void)
{
  FILE *rc, *rc1;
  char buf[BLEN];
  char line[LEN];
  char *val;
  char *tmpname, *bak, *name;

  /* file does not exist, create its */
  snprintf(buf,BLEN,"%s/.%s",getenv("HOME"),RCNAME);
  name = strdup(buf);
  if( (rc = rc_open(name,"r")) == NULL ) {
    if( (rc = rc_create(RCNAME,getenv("HOME"))) ) {
      fprintf(rc,"# Nightview parameter file\n");
      fprintf(rc,"Object = '%s'\n",dat_object_get());
      fprintf(rc,"Observer = '%s'\n",dat_observer_get());
      /*
      fprintf(rc,"Station site = '%s'\n",d->station);
      fprintf(rc,"Station latitude = %10.4f\n",d->station_lat);
      fprintf(rc,"Station longitude = %10.4f\n",d->station_long);
      fprintf(rc,"Station elevation = %9.1f\n",d->station_elev);
      */
      fprintf(rc,"Image scale = %7.3f\n",dat_scale_get());
      fprintf(rc,"Left bottom x subimage coordinate = %d\n",dat_x1_get());
      fprintf(rc,"Left bottom y subimage coordinate = %d\n",dat_y1_get());
      fprintf(rc,"Right top x subimage coordinate = %d\n",dat_x2_get());
      fprintf(rc,"Right top y subimage coordinate = %d\n",dat_y2_get());
      /*
      fprintf(rc,"Bitpix = %d\n",dat_bitpix_get());
      */
      fprintf(rc,"Camera binning = %d\n",dat_binning_get());
      fprintf(rc,"Camera chip select = %c\n",dat_camera_get());
      fprintf(rc,"Server address = %s\n",dat_server_get());
      /*
      fprintf(rc,"Server port = %d\n",d->server_port);
      */
      fprintf(rc,"Subtract dark = %d\n",dat_subtractdark_get());
      fprintf(rc,"Compress = %d\n",dat_compress_get());
      fprintf(rc,"Enable Legend = %d\n",dat_legend_get());
      fprintf(rc,"Enable North = '%s'\n",dat_north_get());
      fprintf(rc,"Enable East = '%s'\n",dat_east_get());
      fprintf(rc,"Enable West = '%s'\n",dat_west_get());
      fprintf(rc,"Enable South = '%s'\n",dat_south_get());
      /*
      fprintf(rc,"Filter 1 = '%s'\n",d->filters[0]);
      fprintf(rc,"Filter 2 = '%s'\n",d->filters[1]);
      fprintf(rc,"Filter 3 = '%s'\n",d->filters[2]);
      fprintf(rc,"Filter 4 = '%s'\n",d->filters[3]);
      fprintf(rc,"Filter 5 = '%s'\n",d->filters[4]);
      fprintf(rc,"Filter selected = '%s'\n",dat_filter_get());
      */
      fprintf(rc,"Font = '%s'\n",dat_font_get());
      fprintf(rc,"Color = %d %d %d\n",dat_color_get_r(),dat_color_get_g(),
                                      dat_color_get_b());
      rc_close(rc);
    }
  }

  /* file exist, copy and update parameters */
  else {
    tmpname = ".gtknightview.new";
    if( (rc1 = fopen(tmpname,"w+")) == NULL ) return;
    while( fgets(line,LEN,rc) ) {
      if( (val = strchr(line,'=')) && strstr(line,"Object") )
	snprintf(line,LEN,"Object = '%s'\n",dat_object_get());
      if( (val = strchr(line,'=')) && strstr(line,"Observer") )
	snprintf(line,LEN,"Observer = '%s'\n",dat_observer_get());
      /*
      if( (val = strchr(line,'=')) && strstr(line,"Station site") )
	snprintf(line,LEN,"Station site = '%s'\n",dat_station);
      if( (val = strchr(line,'=')) && strstr(line,"Station latitude") )
	snprintf(line,LEN,"Station latitude = %10.4f\n",d->station_lat);
      if( (val = strchr(line,'=')) && strstr(line,"Station longitude") )
	snprintf(line,LEN,"Station longitude = %10.4f\n",d->station_long);
      if( (val = strchr(line,'=')) && strstr(line,"Station elevation") )
	snprintf(line,LEN,"Station elevation = %9.1f\n",d->station_elev);
      */
      if( (val = strchr(line,'=')) && strstr(line,"Image scale") )
	snprintf(line,LEN,"Image scale = %7.3f\n",dat_scale_get());
      if( (val = strchr(line,'=')) && strstr(line,"Left bottom x subimage coordinate") )
	snprintf(line,LEN,"Left bottom x subimage coordinate = %d\n",dat_x1_get());
      if( (val = strchr(line,'=')) && strstr(line,"Left bottom y subimage coordinate") )
	snprintf(line,LEN,"Left bottom y subimage coordinate = %d\n",dat_y1_get());
      if( (val = strchr(line,'=')) && strstr(line,"Right top x subimage coordinate") )
	snprintf(line,LEN,"Right top x subimage coordinate = %d\n",dat_x2_get());
      if( (val = strchr(line,'=')) && strstr(line,"Right top y subimage coordinate") )
	snprintf(line,LEN,"Right top y subimage coordinate = %d\n",dat_y2_get());
      /*
      if( (val = strchr(line,'=')) && strstr(line,"Bitpix") )
	snprintf(line,LEN,"BITPIX = %d\n",d->bitpix);
      */
      if( (val = strchr(line,'=')) && strstr(line,"Camera binning") )
	snprintf(line,LEN,"Camera binning = %d\n",dat_binning_get());
      if( (val = strchr(line,'=')) && strstr(line,"Camera chip select") )
	snprintf(line,LEN,"Camera chip select = %c\n",dat_camera_get());
      if( (val = strchr(line,'=')) && strstr(line,"Server address") )
	snprintf(line,LEN,"Server address = %s\n",dat_server_get());
      /*
      if( (val = strchr(line,'=')) && strstr(line,"Server port") )
	snprintf(line,LEN,"Server port = %d\n",d->server_port);
      */
      if( (val = strchr(line,'=')) && strstr(line,"Subtract dark") )
	snprintf(line,LEN,"Subtract dark = %d\n",dat_subtractdark_get());
      if( (val = strchr(line,'=')) && strstr(line,"Compress") )
	snprintf(line,LEN,"Compress = %d\n",dat_compress_get());
      if( (val = strchr(line,'=')) && strstr(line,"Enable Legend") )
	snprintf(line,LEN,"Enable Legend = %d\n",dat_legend_get());
      if( (val = strchr(line,'=')) && strstr(line,"Enable North") )
	snprintf(line,LEN,"Enable North = '%s'\n",dat_north_get());
      if( (val = strchr(line,'=')) && strstr(line,"Enable East") )
	snprintf(line,LEN,"Enable East = '%s'\n",dat_east_get());
      if( (val = strchr(line,'=')) && strstr(line,"Enable West") )
	snprintf(line,LEN,"Enable West = '%s'\n",dat_west_get());
      if( (val = strchr(line,'=')) && strstr(line,"Enable South") )
	snprintf(line,LEN,"Enable South = '%s'\n",dat_south_get());
      /*
      if( (val = strchr(line,'=')) && strstr(line,"Filter 1") )
	snprintf(line,LEN,"Filter 1 = '%s'\n",d->filters[0]);
      if( (val = strchr(line,'=')) && strstr(line,"Filter 2") )
	snprintf(line,LEN,"Filter 2 = '%s'\n",d->filters[1]);
      if( (val = strchr(line,'=')) && strstr(line,"Filter 3") )
	snprintf(line,LEN,"Filter 3 = '%s'\n",d->filters[2]);
      if( (val = strchr(line,'=')) && strstr(line,"Filter 4") )
	snprintf(line,LEN,"Filter 4 = '%s'\n",d->filters[3]);
      if( (val = strchr(line,'=')) && strstr(line,"Filter 5") )
	snprintf(line,LEN,"Filter 5 = '%s'\n",d->filters[4]);
      if( (val = strchr(line,'=')) && strstr(line,"Filter selected") )
	snprintf(line,LEN,"Filter selected = '%s'\n",dat_filter_get());
      */
      if( (val = strchr(line,'=')) && strstr(line,"Font") )
	snprintf(line,LEN,"Font = '%s'\n",dat_font_get());
      if( (val = strchr(line,'=')) && strstr(line,"Color") )
	snprintf(line,LEN,"Color = %d %d %d\n",dat_color_get_r(),
		 dat_color_get_g(), dat_color_get_b());
      
      fprintf(rc1,"%s",line);
    }
    fclose(rc1);
    fclose(rc);
    snprintf(buf,BLEN,"%s.bak",name);
    bak = strdup(buf);
    rename(name,bak);
    rename(tmpname,name);
    free(name);
    free(bak);
  }
}


