/*

  status bar

  $Id: status.c,v 1.14 2002-12-12 16:56:18 hroch Exp $

*/

#include "gtknightview.h"
#include <glib.h>

static GtkWidget *status = NULL;
static GtkWidget *progress;
static int in_progress = FALSE;
static int id;
static float tick;

static gboolean update(GtkWidget *progress)
{
  float value;

  if( in_progress ) {
    /* if( value > 1.0 ) value = 0.0; */
    value = gtk_progress_get_value( GTK_PROGRESS(progress)) + tick;
    /*       printf("%f\n",value);*/
    gtk_progress_set_value (GTK_PROGRESS (progress), value);
    return(TRUE); }
  else
    return(FALSE);
}

void progress_start(char *format, float max, void *f)
{
  int timeout; 

  gtk_progress_configure(GTK_PROGRESS (progress), 0.0, 0.0, max);
  gtk_progress_set_activity_mode (GTK_PROGRESS (progress), FALSE);
  gtk_progress_set_format_string(GTK_PROGRESS (progress),format);
  gtk_progress_set_value (GTK_PROGRESS (progress), 0.0);
  gtk_progress_set_show_text(GTK_PROGRESS (progress),TRUE);
  if( max < 10.0 )
    tick = 0.1;
  else
    tick = 0.5;
  in_progress = TRUE;
  if( ! f )
    timeout = gtk_timeout_add((guint32) 1000.0*tick,(GtkFunction) update, 
			    (gpointer) progress);
}

void progress_stop(char *format)
{
  in_progress = FALSE;
}

void progress_show(float value)
{
  gtk_progress_set_value (GTK_PROGRESS (progress), value);
}

void progress_activity(void)
{
  int timeout; 

  gtk_progress_set_value (GTK_PROGRESS (progress), 0.0);
  gtk_progress_configure(GTK_PROGRESS (progress), 0.0, 0.0, G_MAXFLOAT);
  gtk_progress_set_activity_mode (GTK_PROGRESS (progress), TRUE);
  in_progress = TRUE;
  tick = 0.02;
  timeout = gtk_timeout_add((guint32) 200,(GtkFunction) update,
			    (gpointer) progress);
}
  

void show_status(char *text)
{
  static int i = -1;

  if( status ) {
    if( i != -1 )
      gtk_statusbar_remove(GTK_STATUSBAR(status), id, i);
    i = gtk_statusbar_push(GTK_STATUSBAR(status), id, text);
  }
}

GtkWidget *make_status(GtkWidget *panel)
{
  GtkWidget *hbox;

  hbox = gtk_hbox_new(FALSE, 1);

  progress = gtk_progress_bar_new();
  gtk_container_add(GTK_CONTAINER(hbox),progress);
  gtk_widget_show(progress);

  status = gtk_statusbar_new();
  gtk_container_add(GTK_CONTAINER(hbox),status);
  gtk_widget_show(status);
  
  id = gtk_statusbar_get_context_id(GTK_STATUSBAR(status),"NightView");
  gtk_statusbar_push(GTK_STATUSBAR(status), id, 
		     "Control panel ready.                 ");

  return(hbox);
}
