/*

  temperature frame

  $Id: temperature.c,v 1.7 2002-12-27 14:34:56 hroch Exp $

*/

#include "gtknightview.h"
#include <time.h>

#define MAXINTERVAL 60
#define LEN 80

/* time interval for check of update temperature in miliseconds */
#define UPDATE 1000

static float temperature_changed = TRUE;
static float temperature = 99.9;
static int regulation = 0;

static GtkWidget *temp, *button;

void temperature_init(void)
{
  if( ccd_temp_regul() > 0 ) {
    temperature = ccd_temp_ccd();
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),temperature);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),TRUE);
    regulation = 1;
  }
}

void temperature_shutdown(void)
{
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),FALSE);
}

static void regulate_temperature(GtkWidget *button, GtkSpinButton *temp)
{
  if( GTK_TOGGLE_BUTTON (button)->active ) { /* switch temperature on */
    temperature = (float) gtk_spin_button_get_value_as_float(temp);
    regulation = 1;
    if( ccd_temp_set(temperature) ) {
      show_status("Temperature regulated."); }
    else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button),FALSE);
      show_status("Set on regulation failed."); }}
  else {
    regulation = 0;
    ccd_temp_off();
    show_status("Temperature not regulated."); }

  temperature_changed = TRUE;    
}

static void change_temperature(GtkSpinButton *temp, GtkWidget *button)
{
  char buf[LEN];

  temperature = (float) gtk_spin_button_get_value_as_float(temp);
  if( regulation) 
    regulate_temperature(button,temp);
  sprintf(buf,"Temperature setpoint = %5.1f",temperature);
  show_status(buf);
}


static gboolean update_temperature(GtkWidget *w)
{
  char buf[LEN];
  time_t ctime;
  static time_t dtime = 1;
  static time_t stime = 0;

  if( temperature_changed ) { 
    dtime = 1;
    temperature_changed = FALSE;
  }

  ctime = time(NULL);
  if( ctime - stime > dtime ) {
    stime = ctime;
    if( dtime < MAXINTERVAL ) dtime = 2*dtime;

    sprintf(buf,"Temperature: %5.1f\260C(%d%%)",ccd_temp_ccd(),ccd_temp_regul());
    show_status(buf);
  }
  return(TRUE);
}

GtkWidget *make_temperature(GtkWidget *panel)
{
  GtkWidget *temp_frame;
  GtkWidget *hbox;
  GtkObject *adj;

  /* frame */
  temp_frame = gtk_frame_new(" Temperature ");
  
  hbox = gtk_hbox_new(FALSE, FB);
  gtk_container_add(GTK_CONTAINER(temp_frame),hbox);
  gtk_widget_show(hbox);

  /* enter field */
  adj = gtk_adjustment_new(0.0, -50.0, 30.0, 1.0, 10.0, 0.0);
  temp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 1);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), FB);
  gtk_container_add(GTK_CONTAINER(hbox),temp);
  gtk_widget_show(temp);
  
  /* regulate button */
  button = gtk_toggle_button_new_with_label(" Regulate ");
  gtk_container_set_border_width (GTK_CONTAINER (hbox), FB);
  gtk_container_add(GTK_CONTAINER(hbox),button);
  gtk_widget_show(button);

  gtk_signal_connect(GTK_OBJECT(temp),"changed",
		     GTK_SIGNAL_FUNC(change_temperature), button);
  gtk_signal_connect(GTK_OBJECT(button),"toggled",
		     GTK_SIGNAL_FUNC(regulate_temperature), temp);

  /*
  gtk_signal_connect(GTK_OBJECT(temp),"changed",
		     GTK_SIGNAL_FUNC(update_temperature), NULL);
  gtk_signal_connect(GTK_OBJECT(button),"toggled",
		     GTK_SIGNAL_FUNC(update_temperature), NULL);
  */

  gtk_timeout_add((gint32) UPDATE, (void *) update_temperature, NULL);

  return(temp_frame);
}
