
/*

    implementation of nightview http server clasess

    $Id: html.cpp,v 1.5 2008-10-29 22:03:15 hroch Exp $

*/


#include "nightview.h"
#include "http.h"
#include <string>
#include <vector>
#include <sys/stat.h>
#include <fcntl.h>
#include <syslog.h>
#include <cstring>
#include <cstdlib>

#ifdef DEBUG
#include <iostream>
#endif


using namespace std;

void HtmlBase::Setup(int t)
{
  //SetContentType(type);
  type = t;
  vector<string> body = Body();

  size = 0;
  for(vector<string>::iterator l = body.begin(); l!= body.end();l++) {
#ifdef DEBUG
    cerr << *l << endl;
#endif
    *l += "\r\n";
    size += l->size();
  }

  delete[] data;
  data = new char[size];
  int n = 0;

  for(vector<string>::iterator l = body.begin(); l!= body.end();l++) {
    memcpy(data+n,l->data(),l->size());
    n += l->size();
  }

  /*
  char *a = PrepareHtml(p,size);
  SetContentSize(size);
  SetData(a);
  */
}

Html::Html(void)
{
  h = new HtmlNull();
  h->Setup(0);
  /*
  h->SetContentType(0);
  p = 
  int size;
  char *a = h->PrepareHtml(p,size);
  h->SetContentSize(size);
  h->SetBody(a);
  */
}

void Html::Init(const int status, const string& method, const string& resource,
		const string& params, const string& host,
		const string& chroot)
{
  try {
    delete h;

    if( status == 401 ) {
      h = new HtmlAuth(host);
      h->Setup(0);
      h->SetStatus(401);
    }
    else if( method == "GET" && resource == "/" ) {
      h = new HtmlRoot(resource);
      h->Setup(0);
      h->SetStatus(200);
    }
    else if( method == "POST" && resource.find("nightview.cgi") != string::npos){
      h = new HtmlPost(resource,params,chroot);
      h->Setup(3);
      h->SetStatus(200);
    }
    else if( method == "GET" ) {
      h = new HtmlFits(resource,chroot);
      h->Setup(2);
      h->SetStatus(200);
    }
    else {
      h = new HtmlNotfound(resource,host);
      h->Setup(0);
      h->SetStatus(404);
    }
  }
  catch(runtime_error e) {
    delete h;
    string key = e.what();
#ifdef DEBUG
    cout << e.what() << key << endl;
#endif
    if( key == "FileNotFound" ) {
      h = new HtmlNotfound(resource,host);
      h->Setup(0);
      h->SetStatus(404);
    }
    else {
      h = new HtmlError();
      h->Setup(0);
      h->SetStatus(500);
    }
  }    
    /*
    if( PrepareFile(resource) )
      content = 2;
    else {
      vector<string> body = NotFound(resource,host);
      PrepareData(body);
    }
    return true;
    */
  /*
  }
  else {
    h = new HtmlError();
    h->Setup(0);
    } */   
}


vector<string> HtmlBase::Body(void)
{
  string title = "nightviewd http server :: class HtmlBase";
  string a = "http://www.physics.muni.cz/mb/nightview/";
  vector<string> p;
  p.push_back("<html>");
  p.push_back("<head><title>"+title+"</title></head>");
  p.push_back("</h1>");
  p.push_back("</head>");
  p.push_back("<body><h1>"+title+"</h1>");
  p.push_back("<hr><address><a href=\""+a+"\">"+a+"</a></address>");
  p.push_back("</body>");
  p.push_back("</html>");
  return p;
}

vector<string> HtmlNull::Body(void)
{
  vector<string> p;
  p.push_back("<html>0</html>");
  return p;
}

vector<string> HtmlError::Body(void)
{
  string title = "500 Server Error";
  string a = "http://www.physics.muni.cz/mb/nightview/";
  vector<string> p;
  p.push_back("<html>");
  p.push_back("<head><title>"+title+"</title></head>");
  p.push_back("<body><h1>"+title+"</h1>");
  p.push_back("<hr><address><a href=\""+a+"\">"+a+"</a></address>");
  p.push_back("</body>");
  p.push_back("</html>");

  return p;
}

vector<string> HtmlAuth::Body(void)
{
  string title = "401 Unauthorised";
  vector<string> body;
  body.push_back("<html><head><title>"+title+"</title></head>");
  body.push_back("<body><h1>"+title+"</h1>");
  body.push_back("<hr><address>");
  body.push_back("<a href=\""+host+"\">"+host+"</a>");
  body.push_back("</address></body></html>");
  return body;
}

vector<string> HtmlNotfound::Body(void)
{
  string title = "404 Not Found";
  vector<string> body;
  body.push_back("<html><head><title>"+title+"</title></head>");
  body.push_back("<body><h1>"+title+"</h1>");
  body.push_back("<pre>"+resource+"</pre>This item has not been found");
  body.push_back("<hr><address>");
  body.push_back("<a href=\""+host+"\">"+host+"</a>");
  body.push_back("</address></body></html>");
  return body;
}

vector<string> HtmlRoot::Body(void)
{
  string a = "http://www.physics.muni.cz/mb/nightview/";
  vector<string> body;
  body.push_back("<html>");
  body.push_back("<head>");
  body.push_back("<title>Nightview</title>");
  body.push_back("</head>");
  body.push_back("<body>");
  body.push_back("<p>");
  body.push_back("This is a simple tester for nightview web interface.<br>");
  body.push_back("If you don't know how to use it, type \"login\" to some entry.<br>");
  body.push_back("</p>");
  body.push_back("<form method=\"POST\" action=\"nightview.cgi\">");
  body.push_back("<strong>TELESCOPE:</strong>");
  body.push_back("<input type=TEXT NAME=telescope SIZE=40>");
  body.push_back("<br>");
  body.push_back("<strong>CAMERA:</strong>");
  body.push_back("<input type=TEXT NAME=camera SIZE=40><br>");
  body.push_back("<input type=SUBMIT VALUE=\"Click\">");
  body.push_back("</form>");
  body.push_back("<hr><address><a href=\""+a+"\">"+a+"</a></address>");
  body.push_back("</body>");
  body.push_back("</html>");
  return body;
}

/*
char* HtmlBase::PrepareHtml(vector<string>& body, int& size)
{ 

  return data;
}
*/

vector<string> HtmlPost::Body(void)
{
  vector<string> body;
  vector<string> response;
  char *par, *l;

#ifdef DEBUG
  cout << params << endl;
#endif
  par = strdup(params.c_str());
  l = udecode(par);
  char *p1,*p2;
  for(char *w = strtok_r(l,"&",&p1); w; w = strtok_r(NULL,"&",&p1) ) {
    char *path = NULL;
    char *value = NULL;
    string tag;    
    for(char *u = strtok_r(w,"=",&p2); u; u = strtok_r(NULL,"=",&p2) ) {
      if( strcmp(u,"telescope") == 0 ) {
	path = (char *) MOUNT_SHOCK;
	tag = "telescope";
      }
      else if( strcmp(u,"camera") == 0 ) {
	path = (char *) NIGHT_SHOCK;
	tag = "camera";
      }
      else
	value = u;
    }
    if( path && value ) {
      if( chroot != "" && strstr(path,chroot.c_str()) ) {
	path += strlen(chroot.c_str());
	//if( path[0] == '/' )
	//  path++;
      }

      /* remove + */
      for(int j = 0; value[j] != '\0'; j++ )
	if( value[j] == '+' )
	  value[j] = ' ';

#ifdef DEBUG
      cout << path << " " << value << endl;
#endif
      string r;
      SocketClient nightviewd;
      if( nightviewd.Connect(path) ) {
	nightviewd.WriteLine(value);
	r = nightviewd.ReadLine();
	nightviewd.Close();
      }
#ifdef DEBUG
      cout << path << " " << value << r << endl;
#endif
      if( r != "" )
	//r = "<"+tag+">"+string(path)+" "+string(value)+"</"+tag+">";
	r = "<"+tag+">"+r+"</"+tag+">";
      else
	r = "<error><description>Connect to "+tag+"("+path+") failed."+
	  "</description></error>";
      response.push_back(r);
    }
  }
  free(par);

  body.push_back("<?xml version=\"1.0\"?>");
  body.push_back("<status>");

  if( ! response.empty() ) {

    for(vector<string>::iterator l = response.begin(); l!= response.end();l++)
      body.push_back(*l);
      
  }
  else {
    body.push_back("<error>");
    body.push_back("<description>An error occurred.</description>");
    body.push_back("</error>");
  }
  
  body.push_back("</status>");
  return body;  
}

char HtmlPost::h2c(char b)
{
  char i;
  char a;
  
  a = toupper(b);
  if( a >= 'A' )
    i = a - 'A' + 10;
  else
    i = a - '0';

  return(i);
}


char *HtmlPost::udecode(char *content)
{
  int i,j;

  /* interpretation the hexadecimal values %HH */
  i = 0;
  j = 0;
  while( content[j] != '\0' ) {

    if( content[j] != '%' ) {
      content[i] = content[j];
      j = j + 1;
    }
    else {
      content[i] = 16*h2c(content[j+1]) + h2c(content[j+2]);
      j = j + 3;
    }
    i = i + 1;
  }
  content[i] = '\0';
  return(content);
}

void HtmlFits::Setup(int t)
{
  //SetContentType(type);
  type = t;
  delete[] data;
  data = new char[0];
  size = 0;

  struct stat s;
  string filename;
  if( chroot == "" )
    filename = file;
  else
    filename = file.substr(chroot.size()+1,file.size());
#ifdef DEBUG  
  cerr << filename << " stat=" << stat(filename.c_str(),&s) << endl;
#endif
  if( stat(filename.c_str(),&s) == 0 ) {
    const int fb = 2880;
    int ns = fb*(s.st_size/fb+1);
    data = new char[ns];
    int fd;
    int i;
    int n = 0;
    if( (fd = open(filename.c_str(),O_RDONLY)) > 0 ) {
      while( ( i = read(fd,data+n,fb)) > 0 )
	n += i;
      close(fd);
      size = n;
      return;
    }
  }
  syslog(LOG_ERR,"FileNotFound:%s\n",filename.c_str());
  //throw runtime_error("FileNotFound");

  // file not found
  /*
  type = 0;
  const string b = "<html><head><h1>File not found:</h1></head><body>"
    +file+"</body></html>\r\n";
  size = b.size();
  data = new char[size];
  memcpy(data,b.data(),size);
  */
}

