
/*

    headers for nightview http server 

    $Id: http.h,v 1.2 2006-12-30 21:15:47 hroch Exp $

*/

#include <string>
#include <vector>
#include <stdexcept>

class Logger {
 public:
  Logger();
  Logger(std::string);
  Logger(const char *);
  ~Logger();

  void Log(std::string);

 private:
  std::string id;
};
/*
template <class T> class Ptr {
 public:
  Ptr(): refptr(new size_t(1)), p(0) {}
  Ptr(T *t): refptr(new size_t(1)), p(t) {}
  Ptr(const Ptr& o): refptr(o.refptr), p(o.p) {++*refptr;}

  Ptr& operator=(const Ptr&);
  ~Ptr();

  operator bool() const {return p;}
  T& operator*() const {if(p)return *p;throw std::runtime_error("*Ptr==NULL");}
  T& operator->() const {if(p)return p;throw std::runtime_error("Ptr==NULL");}

 private:

  size_t *refptr;
  T* p;
};

  

class Html;
*/
class HtmlBase {

  //friend class HtmlNull;
  //friend class HtmlRoot;
  //friend class HtmlFile;

 public:
  HtmlBase(): size(0), status(0), type(0), data(0) {}
  virtual ~HtmlBase() { delete[] data; data = new char[0]; }
  virtual int ContentType(void) { return type; }
  virtual int ContentSize(void) { return size; }
  virtual int Status(void) { return status; }
  virtual const char* Data() { return data; }
  //char* HtmlBase::PrepareHtml(std::vector<std::string>&, int&);
    //void PrepareData(std::vector<std::string>&);
  //void SetContentType(int n) { type = n; }
  //void SetContentSize(int n) { size = n; }
  //void SetData(char *a) { data = a; }
  virtual void Setup(int);
  virtual void SetStatus(int i) { status = i; }

 protected:
  virtual std::vector<std::string> Body(void);
  int size;
  int status;
  int type;
  char *data;

 private:

};

class HtmlNull: public HtmlBase {

 private:
  std::vector<std::string> Body(void);

  /*
 private:

  
  Ptr<HtmlBase> p;
  HtmlNull(const Ptr<HtmlBase>& h): p(h),content(0),size(0) {}
  
  int ContentType(void) { return content;}
  int ContentSize(void) { return size;}
  
  std::vector<std::string> body;
  int content;
  int size;
  */
};

class HtmlError: public HtmlBase {

 private:
  std::vector<std::string> Body(void);
};

class HtmlAuth: public HtmlBase {

 public:
  HtmlAuth(const std::string& h) {host=h;}

 private:
  std::vector<std::string> Body(void);
  std::string host;  
};

class HtmlNotfound: public HtmlBase {

 public:
  HtmlNotfound(const std::string& r, const std::string& h) {resource=r;host=h;}

 private:
  std::vector<std::string> Body(void);
  std::string resource;
  std::string host;  
};

class HtmlRoot: public HtmlBase {

 public:
  HtmlRoot(const std::string& r) { resource = r;}

 private:
  std::vector<std::string> Body(void);
  std::string resource;

};

class HtmlPost: public HtmlBase {

 public:
  HtmlPost(const std::string& r, const std::string& p, const std::string& c) 
    { resource=r; params=p; chroot = c; }

 private:
  std::vector<std::string> Body(void);
  char *udecode(char *);
  char h2c(char);
  std::string resource;
  std::string params;
  std::string chroot;

};

class HtmlFits: public HtmlBase {

 public:
  HtmlFits(const std::string& f,const std::string& c) { file = f; chroot = c;}

 private:
  void Setup(int);
  std::string chroot;
  std::string file;

};

class Html {

  //friend Html Static(const Html&, const std::string&);
  //friend Html File(const Html&, const std::string&);
  
 public:
  Html();
  ~Html() { delete h; }
  void Init(const int, const std::string&, const std::string&, const std::string&,
	    const std::string&, const std::string&);

  int ContentType(void) { return h->ContentType(); }
  int ContentSize(void) { return h->ContentSize(); }
  int Status(void) { return h->Status(); }  
  const char* Data(void) { return h->Data(); }

 private:
  //Html(HtmlBase *ptr): p(ptr) {}
  //Ptr<HtmlBase> p;
  HtmlBase *h;

};

//Html Static(const Html&, const std::string&);
//Html File(const Html&, const std::string&);



/*
class HtmlRoot: public HtmlBase {

 private:
  
  Ptr<HtmlBase> p;
  HtmlRoot(const Ptr<HtmlBase>& h): p(h) {}
  
  
  int ContentType(void) { return content;}
  int ContentSize(void) { return size;}

  int content;
  int size;
};

class HtmlFile: public HtmlBase {

 private:
  
  Ptr<HtmlBase> p;
  HtmlFile(const Ptr<HtmlBase>& h): p(h) {}
  
  
  int ContentType(void) { return content;}
  int ContentSize(void) { return size;}

  int content;
  int size;
};
*/

class HttpProtocol { 
  // http://www.jmarshall.com/easy/http/
 public:
  HttpProtocol(const std::string& a): status(200), writeopt(true), 
    writeb(true), ex(false), keepalice(false), content(0), body(0), 
    size(0), nversion(0.0), chunked(false), postform(false), postlen(0) 
    { authkey = a; }
  ~HttpProtocol() {delete[] body; body=new char[0]; }
  
  void Init(const std::string&);
  void AddOption(const std::string&);
  bool Exit(void);
  bool KeepAlive(void);
  bool Options(void);

  //void Process(void);

  std::string StatusLine(void);
  int Status(void) { return status; }
  void SetStatus(int i) { status = i; }
  std::string Date(void);
  std::string ContentType(void);
  std::string ContentSize(void);
  char *Data(void);
  int Size(void);
  std::string StatusText(int);
  bool PostData(void);
  int ParamSize(void);
  void SetParam(std::string);
  bool WriteOptions(void);
  std::string ServerInfo(void);
  bool WriteBody(void);
  std::string ConnectionClose(void);
  std::string AChar(int);
  bool CheckOptions(void);
  void OptionParse(const std::string&, std::string&, std::string&);

  void SetContentType(int i) {content=i;}
  void SetContentSize(int i) {size=i;}

  std::string Method(void) { return method;}
  std::string Resource(void) { return resource;}
  std::string Parameters(void) { return params;}
  std::string ReqAuth(void);

 private:
  std::string method;
  std::string resource;
  std::string version;
  //std::string initline;
  std::vector<std::string> options;
  std::string params;
  int status;
  bool writeopt;
  bool writeb;
  bool ex;
  bool keepalice;
  std::string xhost;
  int content;
  char *body;
  int size;
  double nversion;
  bool chunked;
  bool postform;
  int postlen;
  std::string authrealm;
  std::string authkey;
};

class SocketServer {
 public:
  SocketServer(): sock(-1),cid(-1), 
    port(666), client_port(0), len(512), buffer(0), size(0), nula(0) {};
  virtual ~SocketServer();

  virtual void Switchon(const char *,const char *);
  virtual void Switchon(std::string,std::string);
  void Accept(void);
  void Close(void);
  void Close_pipe(int);
  const char *ReadData(int);
  std::string ReadLine(void);
  void WriteLine(std::string);
  void WriteData(int,const char*);
  std::string ServerAddress(void);
  std::string ClientAddress(void);
  int ServerPort(void);
  int ClientPort(void);
  
 private:
  //void RawOutput(std::string);

  int sock;
  int cid;
  //bool listening;
  std::string address;
  int port;
  std::string client_addr;
  int client_port;
  //bool eof;
  const size_t len;
  char data[512+1];
  char *buffer;
  size_t size;
  size_t nula;
};


class SocketClient {
 public: 
  SocketClient(): id(-1) {}
  ~SocketClient() { Close(); }

  bool Connect(std::string);
  std::string ReadLine(void);
  void WriteLine(std::string);
  void Close(void);

 private:

  int id;

};


class HttpServer : public SocketServer {

public:
  HttpServer(): argc(0), argv(0) {}
  HttpServer(int Xargc, char **Xargv, char* c, const char *a ) 
    {argc = Xargc; argv = Xargv; if(c) chroot = c; if(a) auth=a;}
  virtual ~HttpServer() {}

  //virtual void ReadData(std::string);
  //virtual void WriteData(std::string&);
  void Request(HttpProtocol&);
  void Response(HttpProtocol&);
  void Process(HttpProtocol&);
  void Listen(void);
  //void Killme(bool *);
  bool NonStop(void);
  void MaterializeBody(Html);
  std::string Chroot(void) { return chroot; }

private:
  int argc;
  char **argv;
  std::string chroot;
  std::string auth;

  //bool *kill;
};


class CGIServ {
 public:
  CGIServ(): data(0), size(0) {}
  ~CGIServ() { delete[] data; data=new char[0]; }

  bool Init(std::string, std::string, std::string, std::string);
  const char *Data(void);
  int DataSize(void);
  int ContentType(void);

 private:

  void PrepareData(std::vector<std::string>& body);
  bool PrepareFile(std::string&);
  std::vector<std::string> MainPage(void);
  std::vector<std::string> NotFound(std::string, std::string);
  std::vector<std::string> Question(std::string, std::string);
  char *udecode(char *);
  char h2c(char);

  char* data;
  int size;
  int content;
};


