
/*

    implementation of nightview http server clasess

    $Id: httpprotocol.cpp,v 1.6 2009-03-05 10:42:37 hroch Exp $

*/

#include "nightview.h"
#include "http.h"
#include <string>
#include <cstring>
#include <sstream>
#include <vector>
#include <ctime>
#include <cstdio>
#include <cmath>
#include <cstdlib>


#ifdef DEBUG
#include <iostream>
#endif

using namespace std;

void HttpProtocol::Init(const string& initline)
{  
  vector<string> a;
  char *l;
  l = strdup(initline.c_str());
  for(char *w = strtok(l," "); w; w = strtok(NULL," ") )
    a.push_back(string(w));
  if( ! a.empty() ) {
    if( a.size() > 0 )
      method = a[0];
    if( a.size() > 1 )
      resource = a[1];
    if( a.size() > 2 )
      version = a[2];
  }
  free(l);

  if( method == "" )
    method == "GET";

  if( resource == "" )
    resource == "/";

  if( version == "" )
    version = "HTTP/0.9";

  const char *b = strstr(version.c_str(),"/");
  nversion = strtod(b+1,NULL);

  if( method == "HEAD" ) {
    writeb = false;
    writeopt = true;
  }
  else {
    writeb = true;
    writeopt = true;
  }

  if( method == "GET" ) {
    content = 0;
  }    

#ifdef DEBUG
  cerr << "init:" << method << " " << resource << " " << version << endl;
#endif
}

bool HttpProtocol::Options()
{
  if( version == "HTTP/0.9" )
    return false;

  if( ex ) {
    return false;
    CheckOptions();
  }

  return true;
}

void HttpProtocol::AddOption(const string& line)
{

  string l;
  if( ! options.empty() )
    l = options.back();
  string last;
  for(size_t i = 0; i < l.size(); i++ )
    if( ! isspace(l[i]) )
	last = l[i];

  if( line == "" )
    ex = true;
  else if( last == "," )
    l += line;
  else {
    options.push_back(line);

    string key, val;
    OptionParse(line,key,val);
    
    if( key == "Host" )
      xhost = val;

    else if( key == "Transfer-Encoding" && val == "chunked" )
      chunked = true;

    else if( key == "Content-Type" && val=="application/x-www-form-urlencoded")
      postform = true;

    else if( key == "Content-Length" )
      postlen = strtol(val.c_str(),NULL,10);

    else if( key == "Authorization")
      authrealm = val;
  }
}


bool HttpProtocol::CheckOptions()
{
  if( !(method == "GET" || method == "POST" || method == "HEAD")) {
    status = 501;
    writeb = false;
    writeopt = false;
    return false;
  }

  // check Host: presence of option for HTTP/1.1
  if( fabs(nversion-1.1)<1e-14 && xhost == "" ) {
    status = 400;
    writeb = false;
    writeopt = false;
    return false;
  }

  /* chunked data */
  if( chunked ) {
    status = 501;
    writeb = false;
    writeopt = false;
    return false;
  }

  // authtorization
  if( ! authkey.empty() ) {

    string basic = authrealm.substr(0,5);
    const char *a = authrealm.c_str();
    string auth;
    for(size_t i = basic.length()+1; i < strlen(a); i++)
      if( ! isblank(a[i]) )
	auth.push_back(a[i]);

    if( basic.compare("Basic") != 0 || auth.compare(authkey) != 0 ) {
      status = 401;
      writeb = true;
      writeopt = true;
      return false;
    }
  }

  return true;
}

void HttpProtocol::OptionParse(const string& sline, string& key, string& val)
{
  const char *line = sline.c_str();
  key = "";
  size_t i;
  for(i = 0; line[i] != ':' && line[i] != '\0'; i++)
    key += line[i];

  for(i = i + 1; line[i] != '\0' && isspace(line[i]); i++) ;

  val = "";
  for(i = i; line[i] != '\0'; i++)
    val += line[i];

}

bool HttpProtocol::PostData(void)
{
  return postform && postlen > 0;
}

int HttpProtocol::ParamSize(void)
{
  return postlen;
}

void HttpProtocol::SetParam(string a)
{
  params = a;
}

bool HttpProtocol::Exit()
{
  return ex;
}

bool HttpProtocol::KeepAlive()
{
  return keepalice;
}

bool HttpProtocol::WriteOptions()
{
  return writeopt;
}

bool HttpProtocol::WriteBody()
{
  return writeb;
}

string HttpProtocol::ReqAuth(void)
{
  if( authrealm == "" ) {
    string q = "WWW-Authenticate: Basic realm=\"nighthttpd\"";
    return q;
  }
  return "";
}

string HttpProtocol::StatusLine(void)
{
  return(version+" "+AChar(status)+" "+StatusText(status));
}

string HttpProtocol::ServerInfo(void)
{
  string a = "Server: nighthttpd/";
  string b = NIGHTVERSION;
  return(a+b);
}

string HttpProtocol::Date(void)
{
  const int SIZE=256;
  char buffer[SIZE];
  time_t curtime;
  struct tm *gtime;

  curtime = time (NULL);
  gtime = gmtime (&curtime);
  strftime (buffer, SIZE, "%a, %d %b %Y %H:%M:%S %Z",gtime);
  //string a = "Last-Modified: ";
  string a = "Date: ";
  string b = +buffer;
  return(a+b);
}

string HttpProtocol::ContentType(void)
{
  if( content == 0 )
    return("Content-Type: text/html");
  else if( content == 1 )
    return("Content-Type: text/plain");
  else if( content == 2 )
    return("Content-Type: image/x-fits");
  else if( content == 3 )
    return("Content-Type: text/xml");
  else
    return("");

}

string HttpProtocol::ContentSize(void)
{
  string b;
  if( size > 0 ) 
    b = "Content-Length: "+AChar(size);
  else
    b = "";
  return(b);
}

char *HttpProtocol::Data(void)
{
  return(body);
}

int HttpProtocol::Size()
{
  return size;
}

/*
void HttpProtocol::Process()
{
  CGIServ cgi;
  if( cgi.Init(method,resource,params,string("host")) && 
      ( size = cgi.DataSize()) > 0 ) {
    const char *a = cgi.Data();
    delete[] body;
    body = new char[size];
    memcpy(body,a,size);
    content = cgi.ContentType();
  }
  else {
    status = 500;
    writeb = false;
    writeopt = false;
    return;
  }
}
*/

string HttpProtocol::StatusText(int i)
{
  string text;
  if( i == 200 )
    text = "OK";
  else if( i == 400 )
    text = "Bad Request";
  else if( i == 401 )
    text = "Unauthorised";
  else if( i == 404 )
    text = "Not Found";
  else if( i == 500 )
    text = "Server Error";
  else if( i == 501 )
    text = "Not Implemented";
  else
    text = "Server Internal Error";
  return text;
}

string HttpProtocol::ConnectionClose(void)
{
  string text = "Connection: close";
  return text;
}

string HttpProtocol::AChar(int i)
{  

  stringstream oss;
  oss << i;
  string a;
  oss >> a;
  return a;
}
