
/*

    implementation of http server 

    $Id: httpserver.cpp,v 1.6 2008-10-29 22:03:25 hroch Exp $

*/

#include "nightview.h"
#include "http.h"
#include <csignal>
#include <cstdio>
#include <iostream>
#include <fstream>
//#include <stdexcept>
#include <cstring>
#include <cstdlib>
#include <errno.h>
#include <syslog.h>

/* system wide rc file name */
//#define SYSTEMRC "/usr/local/etc/nightviewd.conf"

using namespace std;

static bool shutdown = false;

void terminate_daemon(int sig)
{
  shutdown = true;
  syslog(LOG_NOTICE,"Exiting.\n");
#ifdef DEBUG
  cerr << "shutdown: " << shutdown << endl;
#endif
  exit(0);
}

void abort_daemon(int sig)
{
  syslog(LOG_ERR,"Daemon aborted due to software error.\n");
  exit(0);
}

int main(int argc,char *argv[])
{

  /* initialize signal handlers */
  signal(SIGTERM,terminate_daemon);
  signal(SIGINT,terminate_daemon);
  signal(SIGQUIT,terminate_daemon);
#ifndef DEBUG
  signal(SIGABRT,abort_daemon);
  signal(SIGSEGV,abort_daemon);
#endif
  //signal(SIGHUP, hup_sock);

  /* initialize log */
  openlog("nighthttpd",LOG_PID, LOG_NOTICE);
  syslog(LOG_NOTICE,"Version %s has been started.\n",NIGHTVERSION);

  char *conf = NULL;
  char *address = NULL;
  char *wdir = NULL;
  char *port = (char *) "7666";
  int user = 65534;

  for(int i = 1; i < argc; i++) {

    if( strcmp("-chroot",argv[i]) == 0 )
      wdir = (char *) "/var/tmp";

    else if( strcmp("-u",argv[i]) == 0 && i++ < argc )
      user = strtol(argv[i],NULL,10);

    else if( strcmp("-h",argv[i]) == 0 && i++ < argc )
      address = argv[i];

    else if( strcmp("-p",argv[i]) == 0 && i++ < argc )
      port = argv[i];

    else if( strcmp(argv[i],"-c") == 0 && i++ < argc )
      conf = argv[i];

    else {
      syslog(LOG_ERR,"Command line option not recognized.");
      exit(1);
    }
      

  }

  if( conf == NULL )
    conf = (char *) SYSTEMRC;
  ifstream rc(conf);
  string line;
  string auth;
  while( getline(rc,line) ) {
    size_t phash = line.find("#");
    string text;
    if( phash == string::npos )
      text = line;
    else
      text = line.substr(0,phash-1);
    size_t pkey = text.find("AuthKey");
    size_t peq = text.find("=");
    if( phash > 0 && pkey != string::npos && peq != string::npos ) {
      for(size_t i = peq+1; i < text.size(); i++)
	if( ! isblank(text.at(i)) )
	  auth.append(1,text.at(i));
      break;
    }
      
  }
  rc.close();

  if( auth == "" )
    syslog(LOG_WARNING,"Authentication key not found. Access is granted for everybody.\n");

  if( wdir ) {
    if( getuid() == 0) {

      if( chroot(wdir) != 0 ) {
	syslog(LOG_ERR,"chroot: %s(%d)\n",strerror(errno),errno);
	return 1;
      }

      if( setuid(user) != 0 ) {
	syslog(LOG_ERR,"setuid: %s(%d)\n",strerror(errno),errno);
	return 1;
      }
    }  
    else {
      syslog(LOG_ERR,"Need to be root to do chroot.\n");
      return 1;
    }
  }

#ifndef DEBUG
  /* close unused files, detach from terminal and fork */
  fclose(stdin);
  fclose(stdout);
  fclose(stderr);
  
  int pid;
  if( (pid = fork()) == 0 )
    ;
  else if( pid == -1 ) {
    syslog(LOG_ERR,"Daemonisation failed: %m\n");
    return(1);
  }
  else
    return(0);
#endif

  //  try {
  HttpServer server(argc,argv,wdir,auth.c_str());
  //HttpServer server;
  server.Switchon(address,port);
  //server.Switchon(NULL,7666);
  server.Listen();
  //}
  //catch (runtime_error e) {
  //  syslog(LOG_ERR,"%s\n",e.what());
  //#ifdef DEBUG
  //cerr << e.what() << endl;
  //#endif
  //}
  return 0;
}
