

/*

    implementation of sockets

    $Id: socketclient.cpp,v 1.1 2006-12-26 20:19:31 hroch Exp $

*/

#include "http.h"
#include <iostream>
#include <string>
#include <unistd.h>
#include <sys/un.h>
#include <sys/socket.h>

using namespace std;

bool SocketClient::Connect(string name)
{
  int n;
  struct sockaddr_un file;

  /* create socket */
  if( (id = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0 ) {
    return false;
    //return(strdup("Socket not created."));
  }
  
  /* init server socket */
  file.sun_family = AF_LOCAL;
  strncpy(file.sun_path,name.c_str(), sizeof(file.sun_path));
  n = sizeof(file);
  if( connect(id, (struct sockaddr *) &file, n) < 0) {
    Close();
    return false;
    //return(strdup("Socket not connected."));
  }

  return true;
}

string SocketClient::ReadLine(void)
{
  const int nlen = 1024;
  char output[nlen];
  int len = nlen;
  if( id > 0 && (len = read(id,output,len)) < 0 ) {
    return "";
    //return(strdup("Read from socket error."));
  }
  output[len] = '\0';
  string line = output;
  return line;
}

void SocketClient::WriteLine(string line)
{

  if( id > 0 && write(id,line.c_str(),line.size()) < 0 ) {
    close(id);
    //return(strdup("Write to socket error."));
  }

}

void SocketClient::Close(void)
{
  if( id > 0 )
    close(id);
  id = -1;
}

