

/*

    implementation of sockets

    $Id: socketserver.cpp,v 1.5 2008-10-29 22:04:54 hroch Exp $

*/

#include "http.h"
#include <string>
#include <cstring>
//#include <stdexcept>
#include <algorithm>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <csignal>
#include <syslog.h>

#ifdef DEBUG
#include <iostream>
#include <errno.h>
#endif

using namespace std;

static int sockid = -1;

void terminate_pipe(int sig)
{
  if( sockid > 0)
    close(sockid);
  sockid = -1;

#ifdef DEBUG
  cerr << "Connection reset by peer." << endl;
#endif
}


void SocketServer::Switchon(string a, string p)
{
  const char *addr = a == "" ? NULL : a.c_str();
  const char *port = p == "" ? NULL : p.c_str();
  Switchon(addr,port);
}

void SocketServer::Switchon(const char *addr, const char *p)
{ 

  struct addrinfo hints, *res, *res0;

  memset(&hints, 0, sizeof(hints));
  hints.ai_family = PF_INET;
  hints.ai_socktype = SOCK_STREAM;
  hints.ai_flags = AI_PASSIVE;// | AI_CANONNAME;
  hints.ai_protocol = IPPROTO_TCP;
  sock = -1;
  string e;
  if( getaddrinfo(addr, p, &hints, &res0) == 0 ) {
    for (res = res0; res; res = res->ai_next) {

      /* create socket */
      sock = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
      if( sock < 0 ) {
	e = "Socket create failed";
	continue;
      }

      if (bind(sock, res->ai_addr, res->ai_addrlen) < 0) {
	close(sock);
	sock = -1;
	e = "Bind to socket failed";
	continue;
      }
      if( listen(sock, 1) < 0 ) {
	close(sock);
	sock = -1;	
	e = "Listen to socket failed";
	continue;
      }      

      char hbuf[NI_MAXHOST], sbuf[NI_MAXSERV];
      if(getnameinfo(res->ai_addr,res->ai_addrlen , hbuf, sizeof(hbuf), sbuf,
		      sizeof(sbuf), 0/*NI_NUMERICHOST | NI_NUMERICSERV*/)==0){
	address = hbuf;
	port = strtol(sbuf,NULL,10);
	}
      break;
    }

    freeaddrinfo(res0);  
  }
  if( sock < 0 )
    syslog(LOG_ERR,"%s\n",e.c_str());
    //    throw runtime_error(e);

}

SocketServer::~SocketServer()
{

  if( cid != -1 )
    close(cid);
  delete[] buffer;
}

void SocketServer::Accept(void)
{
  struct sockaddr_in client;
  
  socklen_t size = sizeof(client);
  if( (cid = accept(sock, (struct sockaddr *) &client, &size)) == -1 )
    syslog(LOG_ERR,"Accept on socket failed.\n");
    //    throw runtime_error("Accept on socket failed");

  signal(SIGPIPE,terminate_pipe);
  sockid = cid;

  /* get informations about client*/
  char *a = inet_ntoa(client.sin_addr);
  struct in_addr ip;
  ip = client.sin_addr;
  struct hostent *h;
  if( (h = gethostbyaddr((const char *)&ip,sizeof(ip), AF_INET)) != NULL )
    client_addr = string(h->h_name);
  else
    client_addr = a;
  client_port = ntohs(client.sin_port);
}

string SocketServer::ReadLine(void)
{
  string line;

  while( true ) {

    if( nula == size ) {
      nula = 0;
      size = read(cid,data,len);
      if( size <= 0 ) 
	return(line);
    }  

    for(size_t i = nula; i < size; i++) {

      if( data[i] == '\r' && data[i+1] == '\n' ) {
	nula = i + 2;
	return(line);
      }
      else if( data[i] == '\n' ) {
	nula = i + 1;
	return(line);
      }
      else
	line += data[i];
    }
    nula = size;
  }
}

void SocketServer::WriteLine(string line)
{
  string block;
  block += line;
  block += "\r\n";
  if( write(cid,block.c_str(),block.size()) < 0 )
    if( sockid < 0 )
      Close();
    else
      syslog(LOG_ERR,"Data send failed.\n");
    //    throw runtime_error("Data send failed");
#ifdef DEBUG
  cerr << line << " " << strerror(errno) << endl;
#endif
}


void SocketServer::WriteData(int size, const char *data)
{
  const int maxlen = 1024;
  //char buf[maxlen];
  size_t l,i,d;

  if( size < 1 ) return;

  l = 0;
  d = min(size,maxlen);
  while( l < size && (i = write(cid,data+l, max(d,size-l))) > 0 ) {
    l += i;
  }
}

void SocketServer::Close(void)
{
  /* close socket to the client */
  if( sockid > 0 && cid > 0 && close(cid) < 0 )
    syslog(LOG_ERR,"Socket close failed.\n");
  //throw runtime_error("Socket close failed");
  cid = -1;
  sockid = cid;
}

void SocketServer::Close_pipe(int i)
{
  Close();
}

const char *SocketServer::ReadData(int dim)
{
  delete[] buffer;
  buffer = new char[dim];
  int n = 0;

  for(size_t i = nula; i < size && n < dim; i++) {
    buffer[n] = data[i];
    n++;
    nula++;
  }

  while( (dim - n) > 0 ) {
    n += read(cid,buffer+n,dim-n);
  }
  return buffer;
}

string SocketServer::ServerAddress(void)
{
  return address;
}

string SocketServer::ClientAddress(void)
{
  return client_addr;
}

int SocketServer::ServerPort(void)
{
  return port;
}

int SocketServer::ClientPort(void)
{
  return client_port;
}

