
/* 
   libccd - driver for CCD camera

   $Id: ccd.h,v 1.22 2008-08-15 20:42:30 hroch Exp $

*/


/* print debug informations during testing a libary */
/*
#define DEBUG 1
*/

/* print debug in clients during testing a library */
/*
#define DEBUG_CLIENT 0
*/

/* named  constants */
/* return codes */
#define OK 1
#define FAIL 0


/* expose and filter status */
#define IDLE 0
#define RUN 1
#define EOE -1

/* function prototypes */

/* general functions */


extern int ccd_login(char *);

extern CCD *ccd_init(char *);

extern int ccd_connect(CCD *ccd);

extern int ccd_connected(CCD *ccd);

extern int ccd_shutdown(CCD *ccd);

extern CCDINFO *ccd_info(CCD *, int, int);

extern void ccd_info_free(CCD *);

extern int temp_init(CCD *);

extern float temp_ccd(CCD *);

extern float temp_setpoint(CCD *);

extern float temp_air(CCD *);

extern float temp_regul(CCD *);

extern int temp_set(CCD *, float);

extern int temp_off(CCD *);

extern int filter_define(char *[]);

extern int filter_connect(CCD *);

extern int filter_init(CCD *);

extern char *filter_list(CCD *);

extern int filter_set(CCD *, char *);

extern char *filter_get(CCD *);

extern int filter_status(CCD *);

extern void filter_disconnect(CCD *);

extern int ccd_set_filter(CCD *ccd, int i);

extern int ccd_set_cfilter(CCD *ccd, char *f);

extern int exp_start(CCD *, double, int, int);

extern int exp_stat(CCD *, int);

extern int exp_stop(CCD *, int);

extern int read_start(CCD *, int, int, int, int, int, int, int);

extern float read_stat(CCD *);

extern char *read_download(CCD *, char *);

extern int read_stop(CCD *);

extern void mount(float *, float *);

extern int read_remove(CCD *ccd);

extern int fits_cp(char *iname, char *oname);

extern int ccd_def_observer(CCD *ccd, char *name);

extern int ccd_def_object(CCD *ccd, char *name);

extern int ccd_def_fitsname(CCD *ccd, char *name);
