
/*

   type definitions for CCD

   this define a CCD main class of ccd

   $Id: ccdtypes.h,v 1.6 2008-08-15 20:42:30 hroch Exp $

*/

/* one device can contains more subdevices, but not more then MAXCCD */
#define MAXCCD 2

/* number of possible readout modes */
#define MAXREADOUT 20

/* max number of filters */
#define MAXFILTERS 6

/* max namber of bad columns */
#define MAXBAD 4


/* readout */
typedef struct {
  int mode;                        /* symbolic mode flag */
  int width, height;               /* width, height image in pixels */
  float gain;                      /* gain in e-/ADU */
  float pixwidth, pixheight;       /* pixel width, height in microns */
} CCDREADOUT;

/* info */
typedef struct {
  char *firmware;                  /* firmware version */
  char *camera_name;               /* description */
  char *serial;                    /* serial number */
  int width, height;               /* area size in pixels */
  float gain;                      /* e- per ADU */
  int offset;                      /* offset (bias in ADU?) */
  int adrange;                     /* A/D converter range */
  float pixel_width, pixel_height; /* size of pixel in micrometers */
  int abg_type;                    /* TRUE ABG presented, if not than FALSE */
  double minexp;                   /* hw specific minimum of exposure time */
  double maxexp;                   /* hw specific maximum of exposure time */
  int bitpix;                      /* bits per pixel */
  int saturation;                  /* saturation */
  int maxbad;
  int n_bad_col, bad_col[MAXBAD];  /* number and position of bad columns */
  int n_readout;                   /* number of readout modes */
  int maxreadout;
  CCDREADOUT *ccdreadout[MAXREADOUT]; /* readout modes */
} CCDINFO;

typedef struct {

  /* general parameters */

  char *address;                   /* general type of address, lp,USB,eth..*/

  /* filters */
  int nfilters;                    /* number of filters */
  int maxfilters;
  char *filter[MAXFILTERS];        /* filter description */
  int wheel;                       /* 1.. wheel connected, 0.. otherwise */

  /* some FITS parameters */

  char *site;                      /* observation site name */
  double longitude;                /* observation site longitude */
  double latitude;                 /* observation site latitude */
  double altitude;                 /* observation site altitude */
  char *telescope;                 /* telescope idenfifier */
  double focus;                    /* focal lenght of telescope */

  /* below, accesible only when on = 1 */

  /* camera info */
  int maxccd;
  CCDINFO *ccdinfo[MAXCCD];

  /* temperature */
  float tempccd;                   /* temperature of ccd chip in deg of C */
  float tempair;                   /* air ambient temperatue in deg of C */
  float reg_power;                 /* cooling power in percents */
  int fan_status;                  /* status of fan, 1 - on, 0 - off */

  /* exposure specific info */
  char *fitsname;                  /* filename of the output image */
  char *datetime;                  /* exposure start date and time */
  double exptime;                  /* exposure time duration */
  char *object;                    /* object name */
  char *observer;                  /* observer's name */
  double ra;                       /* RA of telescope, < -999.0 if not set */
  double dec;                      /* Dec of telescope, < -999.0 if not set */
  int binning;                     /* binning */  

  /* current status of the device */

  int ifilter;                     /* index of current filter */
  int on;                          /* = 1 if camera is on, else 0 */
} CCD;
