
#include "camera.h"

extern "C" {
#include "ccd.h"
#include "ccdcommon.h"
}

using namespace std;

Camera::Camera(const char *h)
{
  host = h;
  ccd = NULL;
}

Camera::~Camera()
{
  ccd_free(ccd);
} 

bool Camera::on()
{
  const char *h = host.c_str(); 
  ccd = ccd_init((char *) h);
  if( ccd )
    return(true);
  else
    return(false);
}

string Camera::filters(void)
{
  if( ccd ) {
    string f = filter_list(ccd);
    return(f);
  }
  else
    return("");
}

bool Camera::connected()
{
  return(true);
}
