/* 

   client application for net communication with camera
   
   $Id: ccdnet.c,v 1.31 2007-08-06 19:07:34 hroch Exp $

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "ccdtypes.h"
#include "ccdcommon.h"
#include "commands.h"
#include "ccd.h"
#include "com.h"

#define LEN 80

#define NOTEMP -999.9
#define NOREG 0.0
#define NODEG 999.9

static const int ccdtypes_maxccd = MAXCCD;
static const int ccdtypes_maxfilters = MAXFILTERS;
static const int ccdtypes_maxreadout = MAXREADOUT;
static const int ccdtypes_maxbad = MAXBAD;


/* opens a new connection,  the address has format: 

   "http://computer.anywhere.net:port"

   or
   
   "file:///local/file"

*/


/*
static int empty(char *a)
{
  int i;

  for( i = 0; a[i] != '\0'; i++)
    if( a[i] != ' ' )
      return(0);
  return(1);
}
*/


void split(char *c, char *o[], int lend, char *sep)
{
  char *a;
  int i,j, n;
  char *w,*uw;

  /* workaround for strtok, which doesn't resolve '' as null string */
  n = 2*strlen(c);
  a = malloc(n);
  a[0] = c[0];
  for( i = 1, j = 1; c[i] != '\0' && j < n; i++, j++) {
    if( c[i] == '\'' && c[i-1] == '\'' ) {
      a[j] = '\t';
      j++;
    }
    a[j] = c[i];
  }
  a[j] = '\0';
    
  for( i = 0; i < lend; i++ )
    o[i] = NULL;
  i = 0;

  for( w = strtok(a,sep); w; w = strtok(NULL,sep) ) {

    if( w[0] == '\t' )
      uw = strdup("");
    else
      uw = strdup(w);

    /*    if( ! empty(uw) && i < lend ) {*/
    if( i < lend ) {
      o[i] = uw;
      i++;
    }
  }
  free(a);
}


int ccd_login(char  *address)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_string(address,LOGIN)) ) {
    if( strstr(buf,WELCOME) )
      i = OK;
    free(buf);
  }
  return(i);
}

CCD *ccd_init(char *sdevice)
{
  CCD *ccd;
  char *buf;

  ccd = (CCD *) NULL;
  if( (buf = ccdnet_get_string(sdevice,LOGIN)) ) {
    if( strstr(buf,WELCOME))
      ccd = ccd_new(sdevice);
    free(buf);
    return(ccd);
  }
  return(NULL);
}

int ccd_shutdown(CCD *ccd)
{
  char *buf;

  if( ccd && (buf = ccdnet_get_string(ccd->address,CAMERA_SHUTDOWN)) ) {
    free(buf);
  }
  return(1);
}

int ccd_info_all(CCD *ccd)
{
  const int nb = 6;
  char *b[nb];
  char *buf;
  char buf1[LEN];
  int i, j, nread, nchips, abgtype, nbad, bad[ccdtypes_maxbad];
  int adrange, bias, mode, w, h;
  float xs, ys, gain;
  double minexp,maxexp;

  if( ! ccd ) 
    return(0);

  /* get number of chips */
  buf = ccdnet_get_string(ccd->address,CAMERA_NCHIP);
  if( ! buf || sscanf(buf,"%d",&nchips) != 1 ) {
    free(buf);
    return(0);
  }
    
  /* get info for chips */
  for( i = 0; i < nchips; i++ ) {
    snprintf(buf1,LEN,"%s %d",CAMERA_CHIP,i);
    buf = ccdnet_get_string(ccd->address,buf1);
    if( ! buf ) {
      free(buf);
      return(0);
    }

    split(buf,b,nb,"'");
    /* for( j = 0; j < nb; j++) printf("%s\n",b[j]?b[j]:"NULL");*/
    sscanf(b[5],"%d %d %d %d %lf %lf %d %d %d %d %d",&abgtype,&adrange,&bias,
	   &nread,&minexp,&maxexp,&nbad,&bad[0],&bad[1],&bad[2],&bad[3]);
    ccd_new_info(ccd,i,b[2],b[0],b[4],0,0,bias,adrange,abgtype,
		 0.0,0.0,0.0,nread,minexp,maxexp,nbad,bad);
    for(j = 0; j < nb; j++)
      free(b[j]);
    free(buf);
  }
    
  /* get of possible readouts */
  for( j = 0; j < nchips; j++) {

    snprintf(buf1,LEN,"%s %d",CAMERA_NREADOUT,j);
    buf = ccdnet_get_string(ccd->address,buf1);
    if( ! buf || sscanf(buf,"%d",&nread) != 1 ) {
      free(buf);
      return(0);
    }
    free(buf);
      
    for( i = 0; i < nread; i++ ) {
	
      snprintf(buf1,LEN,"%s %d %d",CAMERA_READOUT_MODES,j,i);
      buf = ccdnet_get_string(ccd->address,buf1);
      if( ! buf || 
	  sscanf(buf,"%d %d %d %f %f %f",&mode,&w,&h,&xs,&ys,&gain) != 6 ) {
	free(buf);
	return(0);
      }
      free(buf);
      ccd_new_readout(ccd->ccdinfo[j],i,mode,w,h,gain,xs,ys);
    }
  }      
  return(1);
}

int ccd_connect(CCD *ccd)
{
  char *buf;
  int ret;

  ret = FAIL;
  if( ccd && (buf = ccdnet_get_string(ccd->address,CAMERA_CONNECT))) {
    if( strstr(buf,CAMERA_CONNECTED) )
      ret = ccd_info_all(ccd);
    free(buf);

  }
  return(ret);
}


int ccd_connected(CCD *ccd)
{
  return(ccd_info_all(ccd));
}

CCDINFO *ccd_info(CCD *ccd, int chip, int mode)
{
  char *buf;
  char buf1[LEN];
  /*
  char name[LEN];
  int i;
  */
  /*  int w,h,bitpix,nbad,bad[ccdtypes_maxbad];*/
  /* float dw,dh,g,off,abg;*/
  CCDINFO *c;
  /*
  const int nb = 4;
  char *b[nb];
  */

  c = NULL;
  snprintf(buf1,LEN,"%s %d %d",CAMERA_INFO,chip,mode);
  if( ccd && (buf = ccdnet_get_string(ccd->address,buf1)) ) {
    if( strstr(buf,CAMERA_NOINFO) == NULL ) {
      /*
      for(i = 0; i < nb; i++)
	b[i] = NULL;

      split(buf,b,nb,"'");*/
      /*      
      if( sscanf(b[3],"%d %d %f %d %d %f %f %f %d %d %d %d %d",&w,&h,&off,
		 &bitpix,&abg,&dw,&dh,&g,&nbad,&bad[0],&bad[1],&bad[2],
		 &bad[3]) >= 9)
	c = ccd_new_info(ccd,chip,b[0],b[1],b[2],w,h,off,bitpix,abg,dw,dh,g,
			 nbad,bad);
      */
      /*
      for(i = 0; i < nb; i++ )
	free(b[i]);
      */
    }
    free(buf);
  }
  return(c);
}

/*
void ccd_info_free(CCD *ccd)
{
}
*/




int temp_init(CCD *ccd)
{
  if( ccd == NULL ) 
    return(0);
  else
    return(1);
}


float temp_ccd(CCD *ccd)
{
  float temp;
  char *buf;

  temp = NOTEMP;
  if( ccd && (buf = ccdnet_get_string(ccd->address,TEMPERATURE_CCD)) ) {
    if( sscanf(buf,"%f",&temp) != 1 )
      temp = NOTEMP;
    free(buf);
  }
  return(temp);
}

float temp_setpoint(CCD *ccd)
{
  float temp;
  char *buf;

  temp = NOTEMP;
  if( ccd && (buf = ccdnet_get_string(ccd->address,TEMPERATURE_SETPOINT)) ) {
    if( sscanf(buf,"%f",&temp) != 1 )
      temp = NOTEMP;
    free(buf);
  }
  return(temp);
}

float temp_air(CCD *ccd)
{
  float temp;
  char *buf;

  temp = NOTEMP;
  if( ccd && (buf = ccdnet_get_string(ccd->address,TEMPERATURE_AIR)) ) {
    if( sscanf(buf,"%f",&temp) != 1 )
      temp = NOTEMP;
    free(buf);
  }
  return(temp);
}

float temp_regul(CCD *ccd)
{
  float reg;
  char *buf;

  reg = NOREG;
  if( ccd && (buf = ccdnet_get_string(ccd->address,TEMPERATURE_REGUL)) ) {
    if( sscanf(buf,"%f",&reg) != 1 )
      reg = NOREG;
    free(buf);
  }
  return(reg);
}

  
int temp_set(CCD *ccd, float temperature)
{
  char buf[LEN+1];
  char *buf1;

  buf1 = NULL;
  snprintf(buf,LEN,"%s %f",TEMPERATURE_SET,temperature);
  if( ccd && (buf1 = ccdnet_get_string(ccd->address,buf))
      && strstr(buf1,TEMPERATURE_SETED)) {
    free(buf1);
    return(OK);
  }
  free(buf1);
  return(FAIL);
}

int temp_off(CCD *ccd)
{
  char *buf;

  if( ccd && (buf = ccdnet_get_string(ccd->address,TEMPERATURE_OFF)) ) {
    free(buf);
    return(OK); }
  else
    return(FAIL);
} 


int exp_start(CCD *ccd, double exptime, int shutter, int chip)
{
  char line[LEN];
  char *buf;

  snprintf(line,LEN,"%s %lf %d %d",EXPOSURE_START,exptime,shutter,chip);
  if( ccd && (buf = ccdnet_get_string(ccd->address,line))
         && strstr(buf,EXPOSURE_STARTED) ) {
    free(buf);
    return(1); }
  else
    return(0);
}    
  

int exp_stat(CCD *ccd, int chip)
{
  int i;
  char *buf;
  char line[LEN];

  snprintf(line,LEN,"%s %d",EXPOSURE_STAT,chip);
  if( ccd && (buf = ccdnet_get_string(ccd->address,line)) ) {
    if( strstr(buf,TRUN) )
      i = RUN;
    else if( strstr(buf,END_OF_EXPOSURE))
      i = EOE;
    else
      i = IDLE;
    free(buf);
    return(i); }
  else
    return(IDLE);
}

int exp_stop(CCD *ccd, int chip)
{
  int i;
  char *buf;
  char line[LEN];
  
  i = 0;
  snprintf(line,LEN,"%s %d",EXPOSURE_STOP,chip);
  if( ccd && (buf = ccdnet_get_string(ccd->address,line)) ) {
    if( strstr(buf,EXPOSURE_STOPED) )
      i = 1;
    free(buf);
  }
  return(i);
}

int read_start(CCD *ccd,int bitpix, int mode, int x1, int y1, int x2, int y2, int chip)
{
  char line[LEN];
  char *buf;
  /* int size; */

  snprintf(line,LEN,"%s %d %d %d %d %d %d %d",EXPOSURE_READ,bitpix,mode,x1,y1,x2,y2,chip);
  /* size = (x2 - x1 + 1)*(y2 - y1 + 1)*bitpix/8;*/
  if( ccd && (buf = ccdnet_get_string(ccd->address,line))
         && strstr(buf,READOUT_STARTED) ) {
    free(buf);
    return(1); }
  else
    return(0);
}    


int read_stop(CCD *ccd)
{
  int i;
  char *buf;
  
  i = 0;
  if( ccd && (buf = ccdnet_get_string(ccd->address,READOUT_STOP)) ) {
    if( strstr(buf,READOUT_STOPED) )
      i = 1;
    free(buf);
  }
  return(i);
}

float read_stat(CCD *ccd)
{
  float p;
  char *buf; 

  if( ccd && (buf = ccdnet_get_string(ccd->address,READOUT_STAT)) ) {
    if( strstr(buf,END_OF_READOUT) )
      p = 101.1;
    else if ( strstr(buf,TRUN) )
      sscanf(buf+strlen(TRUN),"%f",&p);
    else
      p = -1.0;
    free(buf);
    return(p); }
  else
    return(-1.0);
}

char *read_download(CCD *ccd, char *local)
{
  char *remote, *file;
  int i,j;

  if( ccd ) {
    for( i = 0; i < 3; i++ ) {
      if( (remote = ccdnet_get_string(ccd->address,EXPOSURE_DOWNLOAD)) ) {
	if( strcmp(remote,READOUT_ERROR) != 0 ) {
	  j = file_download(ccd->address,remote,local);
	  if( j && (file = malloc(strlen(local)+strlen("file://")+1)) ) {
	    free(remote);
	    strcpy(file,"file://");
	    strcat(file,local);
	    return(file);
	  }
	}
#ifdef DEBUG
	printf("Traying next shot ...\n");
#endif
	sleep(6);
      }
    }
  }
  return(NULL);
}

int read_remove(CCD *ccd)
{
  char *remote;
  int i;

  i = FAIL;
  if( ccd ) {
    if( (remote = ccdnet_get_string(ccd->address,EXPOSURE_REMOVE)) ) {
      if( strstr(remote,EXPOSURE_REMOVED) )
	i = OK;
      else
	i = FAIL;
      free(remote);
    }
  }
  return(i);
}

int filter_define(char *f[])
{
  return(OK);
}

int filter_init(CCD *ccd)
{
  char *buf;

  if( ccd && (buf = ccdnet_get_string(ccd->address,FILTER_INIT))
          && strstr(buf,FILTER_INITED) ) {
    free(buf);
    return(OK); }
  else
    return(FAIL);
}

char *filter_list(CCD *ccd)
{
  char *buf;

  if( ccd && (buf = ccdnet_get_string(ccd->address,FILTER_LIST))
          && strstr(buf,FILTER_NOLIST) == NULL){
    return(buf);
  }
  else
    return(NULL);
}

 
int filter_set(CCD *ccd, char *filt)
{
  char *buf, line[LEN];
  
  snprintf(line,LEN,"%s %s",FILTER_SET,filt);
  if( ccd && (buf = ccdnet_get_string(ccd->address,line))
          && strstr(buf,FILTER_SETED) ) {
    free(buf);
    return(1); }
  else
    return(0);
}
  
char *filter_get(CCD *ccd)
{
  char *buf;

  if( ccd && (buf = ccdnet_get_string(ccd->address,FILTER_GET))
          && strstr(buf,FILTER_NOGET) == NULL )
    return(buf);
  else
    return(NULL);
}

int filter_status(CCD *ccd)
{
  int i;
  char *buf = NULL;

  if( ccd && (buf = ccdnet_get_string(ccd->address,FILTER_STAT)) ) {
    if( strstr(buf, TRUN) )
      i = RUN;
    else
      i = IDLE;
    free(buf);
    return(i); }
  else
    return(IDLE);
}


int ccd_def_observer(CCD *ccd, char *name)
{
  int i;
  char *buf, line[LEN];
  
  if( ! name )
    return(0);
  snprintf(line,LEN,"%s %s",OBSERVER_NAME,name);
  buf = NULL;
  if( ccd && (buf = ccdnet_get_string(ccd->address,line)) )
    i = strstr(buf,OBSERVER_NAME_SET) != NULL;
  else
    i = 0;
  free(buf);
  return(i);
}

int ccd_def_object(CCD *ccd, char *name)
{
  int i;
  char *buf, line[LEN];
  
  if( ! name )
    return(0);
  snprintf(line,LEN,"%s %s",OBJECT_NAME,name);
  buf = NULL;
  if( ccd && (buf = ccdnet_get_string(ccd->address,line)) )
    i = strstr(buf,OBJECT_NAME_SET) != NULL;
  else
    i = 0;
  free(buf);
  return(i);
}

int ccd_def_fitsname(CCD *ccd, char *name)
{
  int i;
  char *buf, line[LEN];
  
  if( ! name )
    return(0);
  snprintf(line,LEN,"%s %s",FITS_NAME,name);
  buf = NULL;
  if( ccd && (buf = ccdnet_get_string(ccd->address,line)) )
    i = strstr(buf,FITS_NAME_SET) != NULL;
  else
    i = 0;
  free(buf);
  return(i);
}

void mount(float *ra, float *dec)
{
  char *file, *home, *name;
  FILE *f;

  file = "xmove.coo";
  home = getenv("HOME");
  name = malloc(strlen(home)+strlen(file)+3);
  strcpy(name,home);
  strcat(name,"/.");
  strcat(name,file);
  
  if( (f = fopen(name,"r")) ) {
    fscanf(f,"%f",ra);
    fscanf(f,"%f",dec);
    fclose(f);
  }
  free(home);
  free(name);
}

/*
char *ccd_get_site_name(CCD *ccd)
{
  char *buf;

  if( ccd && (buf = ccdnet_get_string(ccd->address,OBSERVATORY_NAME))
          && strstr(buf,OBSERVATORY_ERROR) == NULL )
    return(buf);
  else
    return(NULL);
}

double ccd_get_site_long(CCD *ccd)
{
  double x;
  char *buf;

  x = NODEG;
  if( ccd && (buf = ccdnet_get_string(ccd->address,OBSERVATORY_LONGITUDE)) ) {
    if( sscanf(buf,"%lf",&x) != 1 )
      x = NODEG;
    free(buf);
  }
  return(x);
}

double ccd_get_site_lat(CCD *ccd)
{
  double x;
  char *buf;

  x = NODEG;
  if( ccd && (buf = ccdnet_get_string(ccd->address,OBSERVATORY_LATITUDE)) ) {
    if( sscanf(buf,"%lf",&x) != 1 )
      x = NODEG;
    free(buf);
  }
  return(x);
}

double ccd_get_site_alt(CCD *ccd)
{
  double x;
  char *buf;

  x = NODEG;
  if( ccd && (buf = ccdnet_get_string(ccd->address,OBSERVATORY_ALTITUDE)) ) {
    if( sscanf(buf,"%lf",&x) != 1 )
      x = NODEG;
    free(buf);
  }
  return(x);
}
*/
