/*

   communication library

   creates widely useful functions with common interafce
   to unify work with local socket or http protocol

   $Id: com.c,v 1.8 2007-08-28 20:21:21 hroch Exp $

*/


#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <string.h>
#include <errno.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include "com.h"
#include "xmlsub.h"
#include "httpsub.h"

/* format for http address */
#define ADDRESS_MASK1 "http://%s/nightview.cgi"
#define ADDRESS_MASK2 "http://%s:%d/nightview.cgi"

/* default remote port */
#define RPORT 7666

/* length of address */
#define LEN 255

/* FITS block length in bytes */
#define FITS_BLOCK 2880

/* open connection to local socket */
static int sopen_local(char *name)
{
  int id;
  int size;
  struct sockaddr_un file;

  /* create socket */
  if( (id = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0 ) {
    syslog(LOG_ERR,"socket: %m\n");
    return(-1);
  }
  
  /* init server socket */
  file.sun_family = AF_LOCAL;
  strncpy(file.sun_path,name, sizeof(file.sun_path));
  size = sizeof (file);
  if( connect(id, (struct sockaddr *) &file, size) < 0) {
    syslog(LOG_ERR,"connect: %m\n");
    return(-1);
  }
  
  return(id);
}

/* add strings */
static char *stradd(char *string, char *a, char *b, char *c)
{
  strcpy(string, a);
  strcat(string, b);
  strcat(string, c);
  /*  string[len] = '\0';*/
  return(string);
}

/* functions to work with TFILE structures */

TFILE *tfile_new(char *key)
{
  TFILE *t;

  if( key == NULL )
    return(NULL);

  if( (t = malloc(sizeof(TFILE))) == NULL )
    return(NULL);
  t->id = -1;
  t->key = malloc(strlen(key)+1); strcpy(t->key,key);
  t->local = 0;
  t->host = NULL;
  t->http_size = 0;
  t->http_buffer = NULL;
  return(t);
}


static void tfile_local(TFILE *t, int id, char *host)
{
  t->local = 1;
  t->id = id;
  if( host ) {
    if( t->host != NULL )
      free(t->host); 
    t->host = malloc(strlen(host)+1);
    strcpy(t->host,host);
  }
}


static void tfile_remote(TFILE *t, char *host)
{
  if ( host && t ) {
    if( t->host != NULL )
      free(t->host);
    if( (t->host = malloc(strlen(host)+1)) )
      strcpy(t->host,host);
    else
      t->host = NULL;
#ifdef DEBUG
    fprintf(stderr,"realname: %s\n",host);
#endif
  }
}


/* open net connection, the connection on top of http protocol is not 
   need a really opening but tests the address and server ready */

TFILE *topen(char *host, char *key)
{
  char *address, *file;
  char file1[LEN];
  int id;
  TFILE *t;

#ifdef DEBUG
  fprintf(stderr,"host open: %s\n",host);
#endif

  if( (address = strstr(host,"file://")) != NULL ) {

    file = address + strlen("file://");
    if( (id = sopen_local(file)) > 0 ) {

      if( (t = tfile_new(key)) ) {
	tfile_local(t,id,file);
	return(t);
      }
    }

  }
  else /*if( (file = strstr(host,"http://")) != NULL )*/ {

    if( (t = tfile_new(key)) ) {

      if( strstr(host,":") == NULL )
	snprintf(file1,LEN,ADDRESS_MASK2,host,RPORT);
      else
	snprintf(file1,LEN,ADDRESS_MASK1,host);
      tfile_remote(t,file1);
      return(t);
    }
    
  }

  return(NULL);
}

/* 
reads a unspecified number of bytes in blocks from stream 
*/

int tread(TFILE *t, char *data, int size)
{
  if( t == NULL )
    return(-1);

  if( t->local )
    return(read(t->id, data, size));
  else {
    if( strxml(data,t->http_buffer,t->key,size) )
      return(strlen(t->http_buffer));
    else
      return(-1);
  }
}

int twrite(TFILE *t, void *data, int size)
{
  char *buf;

  if( t == NULL )
    return(-1);

  if( t->local )
    return(write(t->id,data,size));
  else {
    
    /* http transfer */
    /* form question following the ?key=value */
    buf = NULL;
    if( (buf = malloc(strlen(t->key) + strlen(data) + 2)) ){
      stradd(buf,t->key,"=",data);
    }

    /* null buffer */
    if( t->http_buffer )
      free(t->http_buffer);

    /* perform action */
    t->http_buffer = http_run(t->host, buf);

    /* nullify parameter buffer */
    if( buf )
      free(buf);

    if( t->http_buffer ) {
      t->http_size = strlen(t->http_buffer);
      return(t->http_size);
    }
    else {
      t->http_size = 0;
      return(-1);
    }
  }
}

int tclose(TFILE *t)
{
  
  if( t->local )
    close(t->id);
  if( t->http_buffer )
    free(t->http_buffer);
  free(t->host);
  free(t->key);
  free(t);
  return(0);
}

static int file_cp(char *name1, char *name2)
{
  FILE *f1,*f2;
  char *buf[FITS_BLOCK];
  int fd;

#ifdef DEBUG 
  printf("cp %s %s\n",name1,name2);
#endif

  //chmod(name2,0644);

  /*
  f1 = fopen(name1,"r");
  printf("f1..%d\n",errno);
  perror("fopen");
  f2 = fopen(name2,"w");
  perror("fopen");

  printf("f2..%d\n",errno);
  printf("%p %p '%s' %d %d %d %d\n",f1,f2,name2,errno,getuid(),getgid());
  if( f1 && f2 ) {
  */
  if( (f1 = fopen(name1,"r")) && (f2 = fopen(name2,"w")) ) {
    //printf("open......\n");
    while( fread(buf,1,FITS_BLOCK,f1) )
      fwrite(buf,1,FITS_BLOCK,f2);
    //printf("writen......\n");
    fd = fileno(f2);
    fchmod(fd,S_IRUSR|S_IRGRP|S_IROTH);
    fclose(f1);
    fclose(f2);
    //printf("closed......\n");    
    return(1);
  }
  return(0);
}

int file_download(char *host, char *name, char *destname)
{
  char file1[LEN];

  if( strstr(host,"file://") != NULL ) {
    if( file_cp(name + strlen("file://"),destname) == 0 ) {
      fprintf(stderr,"File copy %s to %s failed. File exist?\n",name,destname);
      return(0);
    }
    return(1);
  }
  else {
    if( strstr(host,":") == NULL )
      snprintf(file1,LEN,"http://%s:%d/",host,RPORT);
    else
      snprintf(file1,LEN,"http://%s/",host);

    return(http_download(file1,name,destname));
  }
}


/* ccdnet is a private function used by other function here to simplify 
   of the conection, send string 'action' to adress 'hostaddress' and
   return the response */
char *ccdnet_get_string_type(char *hostaddress, char *action, char *type)
{
  int len;
  char *buf;
  TFILE *t;

  if( (t = topen(hostaddress,type)) == NULL )
    return(NULL);

#ifdef DEBUG
  fprintf(stderr,"action: %s - ",action);
#endif
  len = strlen(action) + 1;
  if( twrite(t,action,len) < 0 ) {
    tclose(t);
    return(NULL);
  }

#ifdef DEBUG
  fprintf(stderr,"Oook.\n");
#endif

  if( (buf = malloc(LEN)) == NULL ) {
    tclose(t);
    free(buf);
    return(NULL);
  }    

  if( (len = tread(t,buf,LEN)) < 0 ) {
    tclose(t);
    free(buf);
    return(NULL);
  }
  /*  buf[len] = '\0';*/
#ifdef DEBUG
  fprintf(stderr,"buf: %s %d\n",buf,len);
#endif

  tclose(t);
  return(buf);
}

char *ccdnet_get_string(char *hostaddress, char *action)
{
  return(ccdnet_get_string_type(hostaddress, action, "camera"));
}

char *ccdnet_get_tstring(char *hostaddress, char *action)
{
  return(ccdnet_get_string_type(hostaddress, action, "telescope"));
}

