
/*

  execute system utilities, run a specified binary with
  string arguments and return an output as a single string 

  $Id: exec.c,v 1.1 2006-12-12 20:45:29 hroch Exp $

*/

#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/wait.h>

#define TIMEOUT_SEC 1
#define TIMEOUT_MSEC 200000
/* how long we will be waiting for childs... */

int exec_command(const char *command, char *const args[], char *output, int len)
{

  /* parameters:

  - command is a command (the same meaning as path in exec functions)
  - args[] are arugumets for execvp commands (null terminated array of strins)
  - output is output buffer previously allocated to lenght len
  - len is the max. lenght of output

  */

  pid_t f;
  int pipa[2];      /* pipa = the tap to get out beer from barel,in czech:-) */
  int i,j,n;
  fd_set rfds;
  struct timeval tv;

  if( pipe(pipa) < 0 ) {
    syslog(LOG_ERR,"pipe: %m: cannot create for %s\n",command);
    return(-1);
  }

  f = fork();
  if( f < 0 ) {
    syslog(LOG_ERR,"Fork failed. The %s move failed.\n",command);
    return(-1);
  }
  else if( f == 0 ) {
    close(1);
    dup(pipa[1]);
    close(pipa[0]);
    close(pipa[1]);
    /* fprintf(stderr,"%s %s %s %s\n",command,args[0],args[1],args[2]);*/
#ifdef DEBUG
    fprintf(stderr,"%s %s %s %s\n",command,args[0],args[1],args[2]);
#endif
    if( (j = execvp(command,args)) < 0 ) {
      syslog(LOG_ERR,"execlp %s: %m\n",command);
      /* a child should (!) write any output else a thread is stoped forever 
         (if block-read without select is used in main) or zombie is created */
      write(1,"",len-1);
    }
    exit(j);
  }
  else {

    /* close output file descriptors */
    close(pipa[1]);

    /* use of the non-block input when no data are presented */ 
    strcpy(output,"");
    FD_ZERO(&rfds);
    FD_SET(pipa[0], &rfds);
    tv.tv_sec = TIMEOUT_SEC;
    tv.tv_usec = TIMEOUT_MSEC;
    if( select(pipa[0]+1, &rfds, NULL, NULL, &tv) ) {
      read(pipa[0],output,len);
    }
    close(pipa[0]);
    output[len-1] = '\0';
    n = -1;
    for( i = 0; i < len && output[i] != '\0'; i++)
      if( output[i] == '\n' || output[i] == '\r' ) {
        n = i;
	output[i] = ' ';
      }
    if( n >= 0 )
      output[n] = '\0';
#ifdef DEBUG
    printf("Child returned: >%s<\n",output);
#endif
    if( waitpid(f,&i,0) < 0 ) {
      syslog(LOG_ERR,"wait: %m\n");
      return(-1);
    }
    if( !WIFEXITED(i) ) {
      syslog(LOG_ERR,"Child exited with code %d\n",WEXITSTATUS(i)); 
      return(-1);
    }
  }

  return(i);
}
