
#include "fitsadd.h"
#include <sys/stat.h>
#include <fitsio.h>
#include <unistd.h>
#include <string.h>

/* the fitscopy copies the iname fits to oname, this is simpler version
  of the fitscopy example programe  from a cfitsio package
*/

int fits_cp(char *iname, char *oname)
{
  fitsfile *infptr, *outfptr;
  int status, ii;
  char *bak;

  /* backup old file */
  if( (bak = malloc(strlen(oname)+5)) ){
    strcpy(bak,oname);
    strcat(bak,".bak");
    rename(oname,bak);
    free(bak);
  }

  status = 0;
  if ( !fits_open_file(&infptr, iname, READONLY, &status) ) {
    if ( !fits_create_file(&outfptr, oname, &status) ) {
      
      ii = 1;
      while( !fits_movabs_hdu(infptr, ii++, NULL, &status) )
	fits_copy_hdu(infptr, outfptr, 0, &status); 
    
      if (status == END_OF_FILE) status = 0;
      fits_close_file(outfptr,  &status);
    }
    fits_close_file(infptr, &status);
  }
  
  if (status) fits_report_error(stderr, status);
  return(status);
}

int fits_key(char *name, char *key, char *value, char *comment)
{
  fitsfile *fptr;
  int status;
  struct stat fmode;

  stat(name,&fmode);
  chmod(name,0644);

  status = 0;
  if ( !fits_open_file(&fptr, name, READWRITE , &status) ) {
    fits_update_key_str(fptr, key, value, comment, &status);
    fits_close_file(fptr, &status);
  }
  if (status) fits_report_error(stderr, status);
  
  chmod(name,fmode.st_mode);
  return(status);
}

int fits_comment(char *name, char *comment)
{
  fitsfile *fptr;
  int status;
  struct stat fmode;

  stat(name,&fmode);
  chmod(name,0644);

  status = 0;
  if ( !fits_open_file(&fptr, name, READWRITE , &status) ) {
    fits_write_comment(fptr,comment,&status);
    fits_close_file(fptr, &status);
  }
  if (status) fits_report_error(stderr, status);
  
  chmod(name,fmode.st_mode);
  return(status);
}

char *fits_gz(char *name)
{
  char *namegz, *suf;
  const char gz[] = ".gz";

  suf = name + strlen(name) - strlen(gz);
  if( strcmp(suf,gz) != 0 ) {
    namegz = malloc(strlen(name) + strlen(gz) + 1);
    strcpy(namegz,name);
    strcat(namegz,gz);
  }
  else
    namegz = strdup(name);

  return(namegz);
}

char *fits_ugz(char *namegz)
{
  char *name, *suf;
  const char gz[] = ".gz";
  int i, d;

  suf = namegz + strlen(namegz) - strlen(gz);
  if( strcmp(suf,gz) == 0 ) {
    name = "nightview.fits";
    d = strlen(namegz) - strlen(gz) + 1;
    if( d > 0 ) {
      name = malloc(d);
      for( i = 0; i < d; i++)
	name[i] = namegz[i];
      name[d-1] = '\0';
    }
  }
  else
    name = strdup(namegz);

  return(name);
}

int fits_diff(char *result, char *image, char *dark)
{
  fitsfile *fdark, *fimg, *fres;
  int *idark, *iimg, *ires, nullval;
  int status, i, fpixel;
  long naxes[2], n;
  
  status = 0;
  nullval = 0;
  fpixel = 1;
  idark = NULL;
  iimg = NULL;
  ires = NULL;
  /* open dark, define data */
  if ( !fits_open_file(&fdark, dark, READONLY, &status) ) {
    fits_get_img_size(fdark,2,naxes,&status);
    n = naxes[0]*naxes[1];
    if( (idark = malloc(n*sizeof(int))) )
      fits_read_img(fdark, TINT, fpixel, n, &nullval, idark, &i, &status);
    else
      idark = NULL;
    fits_close_file(fdark, &status);
  }    

  if( !fits_open_file(&fimg, image, READONLY, &status) &&
      !fits_create_file(&fres, result, &status) ) {
      
    fits_copy_hdu(fimg,fres,1,&status);
    
    if( (iimg = malloc(n*sizeof(int))) )
      fits_read_img(fimg, TINT, fpixel, n, &nullval, iimg, &i, &status);
    else
      iimg = NULL;
    fits_close_file(fimg, &status);
    
    if( (ires = malloc(n*sizeof(int))) ) {
      
      for(i = 0; i < n; i++) {
	ires[i] = iimg[i] - idark[i];
	if( ires[i] < 0 )
	  ires[i] = 0;
	else if( 65535 < ires[i] )
	  ires[i] = 65535;
      }
    }
    else
      iimg = NULL;
    
    fits_write_history(fres,"Dark subtracted.",&status);
    fits_write_img(fres, TINT, 1, n, ires, &status);
    fits_close_file(fres, &status);      
  }    

  if( idark ) free(idark);
  if( iimg ) free(iimg);
  if( ires ) free(ires);
    
  if (status) fits_report_error(stderr, status);
  return(status);
}

int fits_keylist(char *image, char *key, char *value, char *comment)
{
  fitsfile *f;
  int status;

  status = 0;
  if ( !fits_open_file(&f, image, READONLY, &status) ) {
    fits_read_keyword(f,key,value,comment,&status);
    fits_close_file(f, &status);
  }

  if (status) fits_report_error(stderr, status);
  return(status);
}
