
/*

  http client library

  $Id: httpclient.c,v 1.4 2007-08-28 20:21:13 hroch Exp $

*/

#include "nightview.h"
#include "httpclient.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "base64.h"

static char *chttp_address(char *host)
{
  char *a,*p;
  int i;

  if( host == NULL )
    return(strdup(""));

  p = host;
  if( (p = strstr(host,"@")) )
    p += 1;
  else if( (p = strstr(host,"//")) )
    p += 2;

  a = malloc(strlen(host)+1);

  i = 0;
  for( ; p[i] != '\0' && p[i] != ':' && p[i] != '/'; i++ )
    a[i] = p[i];

  a[i] = '\0';

  return(a);
}

static char *chttp_port(char *host)
{
  char *xport;
  int lport = 0;
  int i,l;

  if( host == NULL )
    return(strdup("7666"));

  xport = malloc(strlen(host)+1);

  l = 0;
  for( i = 0; host[i] != '\0'; i++) {
    
    if( lport == 1 ) {
      xport[l] = host[i];
      l++;
    }

    if( host[i] == ':' )
      lport = 1;

    if( host[i+1] == '/' )
      lport = 0;

    if( host[i] == '@' ) {
      l = 0;
      lport = 0;
    }
  }
  xport[l] = '\0';

  if( strlen(xport) > 0 )
    return(xport);
  else
    return(strdup("7666"));
}

static char *chttp_auth(char *host)
{
  char *xauth,*auth64;
  int i,l,l64;
  int lauth = 0;

  if( host == NULL )
    return(strdup(""));

  if( strchr(host,'@' ) ) {

    xauth = malloc(strlen(host)+1);
    l = 0;
    for(i = 0; host[i] != '\0'; i++) {
      
      if( lauth == 0 && host[i] == '/' && i > 1 && host[i-1] == '/' ) {
	lauth = 1;
	i++;
      }

      if( lauth == 1 && host[i] == '@' )
	break;

      if( lauth == 1 ) {
	xauth[l] = host[i];
	l++;
      }

    }
    xauth[l] = '\0';

    if( strchr(xauth,':') ) {

      l64 = BASE64_LENGTH(strlen(xauth))+1;
      auth64 = malloc(l64);
      base64_encode(xauth,l,auth64,l64);
      free(xauth);
      
      return(auth64);
    }
    else
      return(xauth);
  }
  else
    return(strdup(""));
}

static char *chttp_encode(char *data)
{
  char *a;
  char buf[4];
  int i,l,j;

  l = 0;
  a = malloc(3*strlen(data)+1);
  for( i = 0; data[i] != '\0'; i++ ) {
    
    if( data[i] == ' ' ) {
      a[l] = '+';
      l++;
    }
    else if( isalnum(data[i]) || data[i] == '=' || data[i] == '&' ) {
      a[l] = data[i];
      l++;
    }
    else {
      snprintf(buf,4,"%%%x",data[i]);
      for( j = 0; buf[j] != '\0'; j++,l++)
	a[l] = toupper(buf[j]);
    }
    

  }
  a[l] = '\0';
  return(a);
}

static void chttp_parsepar(char *line, char *key, char *val)
{
  size_t i,l;

  if( line == NULL )
    return;

  l = 0;
  for(i = 0; line[i] != ':' && line[i] != '\0'; i++,l++)
    key[l] = line[i];
  key[l] = '\0';

  for(i = i + 1; line[i] != '\0' && isspace(line[i]); i++) ;

  l = 0;
  for(i = i; line[i] != '\0'; i++,l++)
    val[l] = line[i];
  val[l] = '\0';
}

static CHTTP *chttp_connect(char *address, char *port)
{
  int id, len;
  struct addrinfo hints, *res, *res0;
  char *a = "";

  if( address == NULL )
    address = "127.0.0.1";

  if( port == NULL )
    port = "7666";

  memset(&hints, 0, sizeof(hints));
  hints.ai_family = PF_INET;
  hints.ai_socktype = SOCK_STREAM;
  hints.ai_flags = AI_CANONNAME;
  hints.ai_protocol = IPPROTO_TCP;
  id = -1;
  if( getaddrinfo(address, port, &hints, &res0) == 0 ) {
    for (res = res0; res; res = res->ai_next) {

      //#ifdef DEBUG
      //printf("Resolved name: %s\n",res->ai_canonname);
      //#endif
      
      /* create socket */
      id = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
      if( id < 0 )
	continue;

      /* connect to host */
      if( connect(id, res->ai_addr, res->ai_addrlen) < 0 ) {
	close(id);
	id = -1;
	fprintf(stderr,"Connection to %s failed.\n",res->ai_canonname);
	continue;
      }
      
      len = strlen(res->ai_canonname) + strlen(port) + 2;
      a = malloc(len);
      strcpy(a,res->ai_canonname);
      strcat(a,":");
      strcat(a,port);
      freeaddrinfo(res0);
      break;
    }
  }

  if( id < 0 ) {
    fprintf(stderr,"Connection failed.\n");
    return NULL;
  }    

  CHTTP *h = malloc(sizeof(CHTTP));
  h->id = id;
  h->errno = 0;
  h->host = a;
  h->nula = 0;
  h->size = 0;
  h->len = 2880;

  return(h);
}

static void chttp_line(CHTTP *h, char *line)
{
  char *a;
  int i,n,size;

  if( !(h && h->id && h->errno == 0) ) return;

  a = malloc(strlen(line)+3);
  strcpy(a,line);
  strcat(a,"\r\n");

  size = strlen(a);
  i = 0;
  while( (n = write(h->id,a+i,size-i)) > 0 )
    i += n;
}


static void chttp_request(CHTTP *h, char *type, char *resource)
{
  int len;
  char *buf;

  if( !(h && h->id && h->errno == 0) ) return;

  len = 20+strlen(resource)+strlen(type);
  buf = malloc(len);
  snprintf(buf,len,"%s %s HTTP/1.0",type,resource);
  chttp_line(h,buf);
  free(buf);
}

static void chttp_options(CHTTP *h, char *key, char *val, char *valx)
{
  int len;
  char *buf;

  if( !(h && h->id && h->errno == 0)) return;

  len = 1+strlen(key)+strlen(val)+strlen(valx);
  buf = malloc(len);
  strcpy(buf,key);
  strcat(buf,val);
  strcat(buf,valx);
  chttp_line(h,buf);
  free(buf);  
}

static void chttp_postdata(CHTTP *h, char *data, int size)
{
  int i,n;

  if( !(h && h->id && h->errno == 0) ) return;

  i = 0;
  while( (n = write(h->id,data+i,size-i) ) > 0 )
    i += n;
}

static void chttp_readline(CHTTP *h, char *line, int size)
{
  int l,i;

  if( !(h && h->id && h->errno == 0) ) return;

  l = 0;
  while( 1 ) {

    if( h->nula == h->size ) {

      h->size = read(h->id,h->data,h->len);
      h->nula = 0;

      if( h->size <= 0 )
	return;
    }

    for(i = h->nula; i < h->size && l < size; i++) {

      if( h->data[i] == '\r' && h->data[i+1] == '\n' ) {
	h->nula = i + 2;
	line[l] = '\0';
	return;
      }
      else if( h->data[i] == '\n' ) {
	h->nula = i + 1;
	line[l] = '\0';
	return;
      }
      else {
	line[l] = h->data[i];
	l++;
      }
    }
    h->nula = h->size;
  }

}

static void chttp_response(CHTTP *h, char *line, int size)
{
  chttp_readline(h,line,size);
}

static void chttp_params(CHTTP *h, char *line, int size)
{
  chttp_readline(h,line,size);
}

static void chttp_data(CHTTP *h, char *data, int *size)
{
  int i,n;

  if( !(h && h->id && h->errno == 0) ) return;

  n = 0;
  for( i = h->nula; i < h->size && n < *size; i++) {
    data[n] = h->data[i];
    n++;
  }
  h->nula += i;
  if( h->nula >= h->size )
    h->nula = 0;

  while( (*size - n) > 0 ) {
    n += read(h->id,data+n,*size-n);
  }
  
}

static int chttp_read(CHTTP *h, char *data, int size)
{
  int i,n;

  if( !(h && h->id && h->errno == 0) ) return -1;

  n = 0;

  if( h->size > 0 && h->nula > 0 ) {

    for( i = h->nula; i < h->size && n < size; i++) {
      data[n] = h->data[i];
      n++;
    }
    h->nula += i;  

    if( h->nula >= h->size ) {
      h->nula = 0;
      h->size = 0;
    }
  }

  n += read(h->id,data+n,size-n);
  return n;
}


static void chttp_close(CHTTP *h)
{
  if( !(h && h->id && h->errno == 0) ) return;

  close(h->id);
  free(h->host);
  free(h);
  h = NULL;
}


char *chttp_form(char *host, char *post_data)
{
  CHTTP *h;
  char *resource = "/nightview.cgi";
  const int nline = 256;
  char line[nline],key[nline],val[nline],xsize[nline];
  char *addr, *auth, *post, *data, *port;
  int size;

  data = NULL;
  addr = chttp_address(host);
  port = chttp_port(host);
  auth = chttp_auth(host);
  post = chttp_encode(post_data);
  size = strlen(post);
  snprintf(xsize,nline,"%d",size);

  if( (h = chttp_connect(addr,port)) ) {
    
    chttp_request(h,"POST",resource);
    chttp_options(h,"Host: ",h->host,"");
    chttp_options(h,"User-Agent: ","nightview/",NIGHTVERSION);
    chttp_options(h,"Accept: ","text/xml, text/html, text/plain, image/x-fits","");
    if( strlen(auth) > 0 )
      chttp_options(h,"Authorization: ","Basic ",auth);
    chttp_options(h,"Content-Type: ","application/x-www-form-urlencoded","");
    chttp_options(h,"Content-Length: ",xsize,"");
    chttp_line(h,"");
    chttp_postdata(h,post,size);

    chttp_response(h,line,nline);
    if( strstr(line,"200") && strstr(line,"OK") ) {
      size = 0;
      while( 1 ) {
	chttp_params(h,line,nline);
	if( strlen(line) == 0 ) break;
	chttp_parsepar(line,key,val);

	if( strcmp(key,"Content-Type") == 0 && strcmp(val,"text/xml" ) != 0 ) {
	  size = 0;
	  break;
	}

	if( strcmp(key,"Content-Length") == 0 && sscanf(val,"%d",&size) != 1 )
	  break;

      }
      if( size > 0 ) {
	data = malloc(size+1);
	chttp_data(h,data,&size);
	data[size] = '\0';
      }
    }
    chttp_close(h);
  }

  free(addr);
  free(auth);
  free(post);
  free(port);
  if( data )
    return(data);
  else
    return(strdup(""));
}

int chttp_file(char *host, char *remotename, char *localname)
{
  CHTTP *h;
  FILE *f;
  const int nline = 256;
  char line[nline],key[nline],val[nline];
  char buf[2880];
  char *addr, *auth, *port;
  int size;
  int n,fd;

  addr = chttp_address(host);
  port = chttp_port(host);
  auth = chttp_auth(host);

  if( localname && remotename && (h = chttp_connect(addr,port)) ) {
    
    chttp_request(h,"GET",remotename);
    chttp_options(h,"Host: ",h->host,"");
    chttp_options(h,"User-Agent: ","nightview/",NIGHTVERSION);
    chttp_options(h,"Accept: ","text/xml, text/html, text/plain, image/x-fits","");
    if( strlen(auth) > 0 )
      chttp_options(h,"Authorization: "," Basic ",auth);
    chttp_line(h,"");
    
    chttp_response(h,line,nline);
    if( strstr(line,"200") && strstr(line,"OK") ) {
      size = 0;
      while( 1 ) {
	chttp_params(h,line,nline);
	if( strlen(line) == 0 ) break;
	chttp_parsepar(line,key,val);

	/*	
	if( strcmp(key,"Content-Type")==0 && strcmp(val,"image/x-fits" )!= 0){
	  size = 0;
	  break;
	}
	*/

	if( strcmp(key,"Content-Length") == 0 && sscanf(val,"%d",&size) != 1 ){
	  size = 0;
	  break;
	}

      }
      if( size > 0 && (f = fopen(localname,"wb")) ) {
	
	while( (n = chttp_read(h,buf,2880)) > 0 )
	  fwrite(buf,n,1,f);

	fd = fileno(f);
	fchmod(fd,S_IRUSR|S_IRGRP|S_IROTH);
	fclose(f);
      }
    }
    chttp_close(h);
  }

  free(addr);
  free(auth);
  free(port);
  return(size);
}


/* compatibility reasons with curl */

char *http_run(char *host, char *data)
{
  return chttp_form(host, data);
}

int http_download(char *host, char *file, char *name)
{
  char *f;
  f = file + strlen("file://");
  return chttp_file(host, f, name);
}

