
/*

  http - curl - specific auxiliary subroutines

  $Id: httpsub.c,v 1.7 2006-12-03 23:04:51 hroch Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

#ifdef DEBUG
#define DEBUG_EXTRA 1
#endif

/* size of buffer for http data input stream */
static int http_size = 0;
static char *stream = NULL;
/* I don;t know why, but the callback don't work without global data.
   The experiments with local data are only the time losses. */

/* this callback and http_run, load the remote file to the memory,
   the work on curl library  */

static int callback(void *new, int size, int items, void *zero)
{
  int nbytes;
  void *mem;

#ifdef DEBUG_EXTRA
  printf("\n@[%s]@\n",(char *) new);
#endif

  nbytes = size*items;
  if( (mem = malloc(http_size + nbytes + 1)) ) {
    memcpy(mem,stream,http_size);
    memcpy(mem+http_size,new,nbytes);
    http_size = http_size + nbytes;
    free(stream);
    stream = mem;
    stream[http_size] = '\0';
    return(nbytes);
  }
  return(0);
}

char *http_run(char *host, char *data)
{
  CURL *curl;
  CURLcode res;
  char *buffer;

  if( stream )
    fprintf(stderr,"stream != NULL\n");
  stream = NULL;
  http_size = 0;
  if( (curl = curl_easy_init()) ) {

    curl_easy_setopt(curl, CURLOPT_URL, host);
    curl_easy_setopt(curl, CURLOPT_POSTFIELDS, data);
#ifdef DEBUG_EXTRA
    curl_easy_setopt(curl, CURLOPT_VERBOSE, 1);
#endif
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, callback);
    curl_easy_setopt(curl, CURLOPT_FILE, NULL);
    res = curl_easy_perform(curl);
    curl_easy_cleanup(curl);
    buffer = NULL;
    if( res == 0 && stream ) {
      /* copy bytes from private to public variable */
      if( (buffer = malloc(http_size + 1)) ) {
	strcpy(buffer,stream);
	buffer[http_size] = '\0';
      }
    }
    if( stream ) {
      free(stream);
      stream = NULL;
    }
    http_size = 0;
    return(buffer);
  }
  return(NULL);
}


int http_download(char *host, char *file, char *name)
{
  FILE *f;
  CURL *curl;
  CURLcode res;
  char *url;
  char err_text[CURL_ERROR_SIZE];

  /*
  if( (name = tmpnam(NULL)) == NULL) {
    fprintf(stderr,"Tmp file name creation error for socket.\n");
    return(NULL);
  }
  */

  if( (f = fopen(name,"wb")) == NULL ) {
    fprintf(stderr,"Tmp file open error.\n");
    return(0);
  }
  
  if( (url = malloc(strlen(host) + strlen(file) + 1)) == NULL ) {
    fprintf(stderr,"Not enought memory for URL identifier.\n");
    return(0);
  }
  strcpy(url,host);
  strcat(url,file + strlen("file://"));

#ifdef DEBUG
  printf("File URL: %s\n",url);
#endif

  if( (curl = curl_easy_init()) ) {

    curl_easy_setopt(curl, CURLOPT_URL,url);
    curl_easy_setopt(curl, CURLOPT_FILE,f);
    curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, err_text);
    res = curl_easy_perform(curl);
    if( res != 0 ) {
      fprintf(stderr,"Curl error: %s\n",err_text);
    } 
    curl_easy_cleanup(curl);
    
    free(url);

    if( fclose(f) == 0 && res == 0 )
      return(1);
  }
  return(0);
}
