
/*

   Show progress bar on line-oriented terminals.

   $Id: progress.c,v 1.3 2008-10-29 22:04:29 hroch Exp $
*/

#include <stdio.h>
#include <string.h>

#define LEN 80
#define RANGE 55

void form_progressbar(double zero, double current, double full, int len, char *label, char *line)
{
  int i, j, ir, ilen;
  char time[LEN];

  for( i = 0; i < len; i++)
    line[i] = ' ';

  ilen = strlen(label);
  for( i = 0; i < ilen && i < len; i++)
    line[i] = label[i];

  ir = (current - zero)/(full - zero) * (RANGE - ilen) - 1;
  if( ir > len ) ir = len;

  line[ilen+1] = '|';
  for( i = 0; i < ir; i++ )
    line[i+ilen+2] = '=';
  line[ir+ilen+2] = '>';

  if ( RANGE < len )
    line[RANGE] = '|';

  snprintf(time,LEN,"%.1f<=%.1f<=%.1f",zero,current,full);

  i = RANGE + 2;
  for( j = 0; time[j] != '\0' && i+j < len; j++)
    line[i+j] = time[j];

  line[len-1] = '\0';
}

void print_progressbar(FILE *stream, char *label, double zero, double current, double full)
{
  char line[LEN];

  form_progressbar(zero,current, full,LEN,label,line);
  fprintf(stream,"\r%s",line);
  fflush(stream);
}
