
/* 

  manipulate with rc coonfiguration file

  $Id: rcfile.c,v 1.7 2002-02-27 15:57:17 hroch Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rcfile.h"


/* 
  open rcfile, search name in path1 and path2 in this order
  suppose, that fisrt argument is system path, second argument 
  is  user path, that it looking for files:

  systempath/rcname
  userpath/.rcname

*/  

static char *rc_file_name = NULL;

FILE *rc_open(char *rcname, char *mode)
{
  return(fopen(rcname,mode));
}


/* currently not used */
FILE *rc_create(char *rcname,char *path)
{
  FILE *f;
  char *name;

  if( rc_file_name != NULL) return(NULL);

  name = malloc(strlen(path) + strlen(rcname) + 3);
  strcpy(name,path);
  strcat(name,"/.");
  strcat(name,rcname);
  f = fopen(name,"w");
  rc_file_name = name;
  if( f )
    return(f);
  free(rc_file_name);
  rc_file_name = NULL;
  return(NULL);
}

void rc_rename(FILE *rc, char *tmpname)
{
  fclose(rc);
  remove(rc_file_name);
  rename(tmpname,rc_file_name);
}


char *rc_gets(char *s, int size, FILE *stream)
{
  char *com;

  if( fgets(s,size,stream) ) {
    /* replace comment start character '#' by '\0' */
    if( (com = strchr(s,'#')) ) *com = '\0'; 
    if( strlen(s) > 0 )
      return(s);
    else
      return(strncpy(s,"",size)); }
  else
    return(NULL);

}

int rc_close(FILE *stream)
{
  return(fclose(stream));
}
