
/*
   A simple XML parser.

   $Id: xmlsub.c,v 1.2 2002-04-15 11:54:57 hroch Exp $

*/

/* a simple parser, only search in memory 'data' for the 'string' 
   between tags <tag> and </tag> and gets pointer to this string  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *strxml(char *string, char *data, char *tag, int size)
{
  char *starttag, *stoptag, *a, *b;
  int i, l;

  if( data == NULL || tag == NULL )
    return(NULL);

  /* initialize the start and stop tag */
  i = strlen(tag);
  starttag = malloc(i+3);
  stoptag = malloc(i+4);
  sprintf(starttag,"<%s>",tag);
  sprintf(stoptag,"</%s>",tag);

  a = strstr(data,starttag) + i + 2;
  b = strstr(data,stoptag);

  free(starttag);
  free(stoptag);

  l = 0;
  if( a && b && b - a > 0) {
    l = b - a;
    if( l > size ) l = size - 1;
    strncpy(string,a,l);
    string[l] = '\0';
    return(string);
  }

  return(NULL);
}
