
/*
  Fits functions

  $Id: ccdfits.c,v 1.2 2007-06-16 11:36:04 hroch Exp $

*/

#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <fitsio.h>
#include "nightview.h"
#include "ccdtypes.h"
#include "ccdcommon.h"


/* create a new FITS file */
int ccd_keep_image(CCD *ccd, int chip, int binning, int startx, int starty,
		     int nx, int ny, unsigned short *fitsimage, char *output)
{
  fitsfile *fptr;       /* pointer to the FITS file, defined in fitsio.h */
  long naxes[2], npixels;
  char *a;
  float temp, ra, dec;
  int i, j, itmp, ret;
  double longit;
  double lat;
  double alt;
  double focus;

  /* contvert SBIG image to FITS image array shape, flip,
     this still work on unsigned char readout.data masked to unsigned short */
  for( i = 0; i < ny/2; i++ ) 
    for( j = 0; j < nx; j++ ) {
      itmp = fitsimage[nx*i + j];
      fitsimage[nx*i + j] = fitsimage[nx*(ny - i - 1) + j];
      fitsimage[nx*(ny - i - 1) + j] = itmp;
    }

  ret = 0;
  naxes[0] = nx;
  naxes[1] = ny;
  npixels  = naxes[0]*naxes[1];          /* number of pixels in the image */

  if (fits_create_file(&fptr, output, &ret))    /* create new FITS file */
    fits_report_error(stderr, ret);   /* print error if error occurs */
  if ( fits_create_img(fptr, USHORT_IMG, 2, naxes, &ret) )
    fits_report_error(stderr, ret);

  temp = ccd_get_exptime(ccd);
  fits_update_key_fixflt(fptr,"EXPTIME",temp,3,"[s] Exposure time",&ret);
  a = ccd_get_datetime(ccd);
  fits_update_key(fptr,TSTRING,"DATE-OBS",a,"UTC of exposure start",&ret);
  a = ccd_get_cfilter(ccd);
  if( strlen(a) > 0 )
    fits_update_key(fptr,TSTRING,"FILTER",a,"filter",&ret);

  a = ccd_get_object(ccd);
  if( strlen(a) > 0 )
    fits_update_key(fptr,TSTRING,"OBJECT",a,"Object name",&ret);
  a = ccd_get_observer(ccd);
  if( strlen(a) > 0 )
    fits_update_key(fptr,TSTRING,"OBSERVER",a,"Observer name",&ret);

  ra = ccd_get_ra(ccd);
  dec = ccd_get_dec(ccd);
  if( ra > -900.0 && dec > -900.0 ) {
     fits_update_key_fixflt(fptr,"MOUNTRA",ra,4,"[deg] Approx. Right Ascension",
		     &ret);
     fits_update_key_fixflt(fptr,"MOUNTDEC",dec,4,"[deg] Approx. Declination",
		     &ret);
  }
  temp = ccd_get_tempccd(ccd);
  if( temp > -273.0 )
    fits_update_key_fixflt(fptr,"TEMPERAT",temp,1,"[C] Camera temperature",&ret);
  temp = ccd_get_tempair(ccd);
  if( temp > -273.0 )
    fits_update_key_fixflt(fptr,"TEMPOUT",temp,1,"[C] Air temperature",&ret);

  startx = startx + 1;
  starty = starty + 1;
  fits_update_key(fptr,TSHORT,"XPOS",&startx,"X position of start pixel",&ret);
  fits_update_key(fptr,TSHORT,"YPOS",&starty,"Y position of start pixel",&ret);
  i = binning;
  fits_update_key(fptr,TSHORT,"XFACTOR",&i,"Camera x binning factor",&ret);
  fits_update_key(fptr,TSHORT,"YFACTOR",&i,"Camera y binning factor",&ret);

  temp = ccd_get_readout_pixsize(ccd,chip,binning-1);
  fits_update_key_fixflt(fptr,"XPIXSIZE",temp,1,"[micrometer] X physical pixel size",&ret);
  temp = ccd_get_readout_piysize(ccd,chip,binning-1);
  fits_update_key_fixflt(fptr,"YPIXSIZE",temp,1,"[micrometer] Y physical pixel size",&ret);
  temp = ccd_get_readout_gain(ccd,chip,binning-1);
  fits_update_key_fixflt(fptr,"GAIN",temp,2,"[e-/ADU] gain of camera amplifier",&ret);

  /*
  i = ccd_get_saturation(ccd);
  fits_update_key(fptr,TUSHORT,"SATURATE",&i,"Saturation limit",&ret);
  */
  a = ccd_get_cameraname(ccd,chip);
  if( strlen(a) > 0 )
    fits_update_key(fptr,TSTRING,"CAMTYPE",a,"Camera manufacturer and model",&ret);

  a = ccd_get_site_name(ccd);
  if( strlen(a) > 0 ) {
    fits_update_key(fptr,TSTRING,"SITE",a,"Name of observatory",&ret);
    alt = ccd_get_site_alt(ccd);
    longit = ccd_get_site_long(ccd);
    lat = ccd_get_site_lat(ccd);
    fits_update_key_fixflt(fptr,"ALTITUDE",alt,1,"[m] Observatory altitude",&ret);
    fits_update_key_fixflt(fptr,"LONGITUD",longit,4,"[deg] Observatory longitude E+, W-",&ret);
    fits_update_key_fixflt(fptr,"LATITUDE",lat,4,"[deg] Observatory latitude",&ret);
  }
  a = ccd_get_telescope_name(ccd);
  if( strlen(a) > 0 ) {
    fits_update_key(fptr,TSTRING,"TELESCOP",a,"Identifier of telescope",&ret);
    focus = ccd_get_telescope_focus(ccd);
    fits_update_key_fixflt(fptr,"FOCUS",focus,6,"[m] Focal length of telescope",&ret);
  }

  fits_write_comment(fptr,"This file was written by the Nightview package version:",&ret);
  fits_write_comment(fptr,NIGHTVER,&ret);
  fits_write_comment(fptr,"Homepage: http://www.physics.muni.cz/mb/nightview/",&ret);

  if ( fits_write_img(fptr, TUSHORT, 1, npixels, fitsimage, &ret) )
    fits_report_error(stderr, ret);
  if ( fits_close_file(fptr, &ret) )
    fits_report_error(stderr, ret);

  return(ret == 0);
}
