#!/bin/bash
#
# $Id: install_sbig_firmware.sh,v 1.13 2008-09-13 16:45:15 hroch Exp $
#

#set -n
set -C
#set -u
set -e
#set -x

crash ()
{
  echo
  echo "  Crash. Something failed. Try to correct errors and run again."
  echo
  exit 99
}

trap crash ERR


fxload_warning ()
{
  echo
  echo
  echo "! fxload utility is not available. Please, install it."
  echo "! (without fxload, any firmware can't be loaded and your device will not work!)"
  echo
}

usbfs_warning ()
{
  echo
  echo
  echo "! USB filesystem is not presented in your /etc/fstab. Please, add it by (for example) command:."
  echo "! echo \"usbfs /proc/bus/usb/ usbfs defaults 0 0\" >> /etc/fstab"
  echo "! (without usbfs, any firmware can't be loaded and your device will not work!)"
  echo
}


PATH=$PATH:/sbin
export PATH


# FETCH=-1.. test the availability of wget
# FETCH=0 .. don't test and unpack previously fetched package
# FETCH=1 .. fetch package itself
FETCH=-1

# DESTDIR
#DESTDIR=/tmp/root
# bash$ DESTDIR=/tmp/root ./install_sbig_firmware.sh 

# TMP
TDIR=install_sbig_firmware
TMP=/var/tmp/
TEMP=$TMP/$TDIR

INSTPATH=$PWD
NAMELIB="PUBLIC_SOFTWARE-2008-03-04.tar.gz"
FETCHLIB="http://pleione.asu.cas.cz/~soldan/software/$NAMELIB"
ARCHIVE=$TMP$NAMELIB

# additional warnings
FX=0
FS=0

# process command-line parameters
for A in $@; do
   case $A in
     -f ) shift
          FETCH=0
          ;;
   esac
done

echo "--------------------------------------------------------------"
echo "                                                     Nightview"
echo
echo "Welcome in installer of the SBIG firmware library."
echo
echo "This utility will download, unpack and install SBIG libraries"
echo "and other additional files for Nightview software package."
echo
echo "Required version of the SBIGudrv: 4.57, 2008-04-01"
echo
echo "This script needs some prerequisites and utilities to run:"
echo "   1. run it as root"
echo "   2. run from install directory: libsbig/"
echo "   3. Wget utility is required to get file to install."
echo "   4. Fxload utility is available."
echo
echo "------------------------------------------------------------------"
echo "Press ENTER..."
read

echo "Now, I will test your system..."

cd $INSTPATH
echo -n "Checking install directory tree, looking for ../udev/sbig.rules "
if [ -f ../udev/nightview.rules ]; then
   echo ".. OK"
else
   echo
   echo "File ../udev/nightview.rules not found. Please switch to directory"
   echo "libsbig in the installation tree and run this script from the location."
   exit 2
fi

echo -n "Testing availability of fxload...."
(fxload -V >& /dev/null)
if [ $? -eq 0 ]; then
    echo "fxload is available...OK"
else
    fxload_warning
    FX=1
fi

echo -n "Testing presence of USB filesystem in fstab ...."
(grep usbfs /etc/fstab >& /dev/null)
if [ $? -eq 0 ]; then
    echo "usbfs is available...OK"
else
    usbfs_warning
    FS=1
fi

if [ $FETCH -ne 0 -a -f "$ARCHIVE" ]; then
  echo -n "Checking presence of the archive $ARCHIVE ..."
  FETCH=0
  echo -n "presented and will be used..."
  echo "done"
fi

if [ $FETCH -ne 0 ]; then
  echo "Checking wget availability..."
  WGET=$(wget --help>& /dev/null)
  if [ $? -eq 0 ]; then
    echo "wget is available .. OK"
    FETCH=1
  else
    echo "wget is not available to get a required files."
    echo "Try:"
    echo "   * get it manually:"
    echo "    - $FETCHLIB"
    echo "   and place it to $TMP and run this utility with -f option"
    echo
    echo "   * install wget utility"
    exit 3
  fi
fi

echo "Required tests passed."
echo 

OS=$(uname -o)
if [ "$OS" = "GNU/Linux" ]; then
  echo "Your operation system has been detected as: $OS"
else
  echo "Your operation system has been detected as: $OS. This isn't probably"
  echo "supported platform to run SBIG's drivers."
  echo "Do you continue with installation? (Yes/no)"
  read AGREE
  if [ "$AGREE" = "Yes" ]; then
    echo "Continuing on your request."
  else
    exit 0
  fi
fi

MARCH=$(uname -m)
if [ "$MARCH"  = "x86_64" ]; then
  BIT=64
  echo "Your platform is detected as $MARCH. The 64bit release will be used"
else
  BIT=32
  echo "Your platform is detected as $MARCH. The 32bit release will be used"
fi

if [ $FETCH -eq 1 ]; then

  echo "Fetching of a SBIG's library..."
  cd $TMP
  wget $FETCHLIB
  if [ $? -ne 0 ]; then
    echo "Failed to download of the SBIG library. Try again or fetch it"
    echo "manually and put to $TMP. Run this script with -f option again."
    exit 5
  fi
  echo "done"
fi

if [ ! -f $ARCHIVE ]; then
   echo "! The archive to install is missing: $ARCHIVE"
   exit 55
fi

echo -n "Unpacking the SBIG's library..."
mkdir -p $TEMP
cd $TEMP
tar zxf $ARCHIVE
if [ $? -ne 0 ]; then
   echo "Unpack of the file $ARCHIVE failed. There is no reason..."
   exit 6
fi
echo "done"

echo -n "Copying files to system..."
cp -i $INSTPATH/uninstall_sbig_firmware.sh $DESTDIR/usr/local/sbin/
cd PUBLIC_SOFTWARE/sbigudrv/Release
cp -i app/sbigudrv.h $DESTDIR/usr/local/include/
cp -i drv/*$BIT.a drv/*$BIT.so $DESTDIR/usr/local/lib/
if [ ! -d $DESTDIR/lib/firmware ]; then 
  mkdir -p $DESTDIR/lib/firmware
fi
cp -i drv/*.hex drv/*.bin drv/sbig_dev_permission.py $DESTDIR/lib/firmware/
cp -i drv/10-sbig.rules $DESTDIR/etc/udev/rules.d/
cp -i drv/50-usb-serial.rules $DESTDIR/etc/udev/rules.d/
cd $DESTDIR/usr/local/lib
for A in libsbigudrv*.a; do ln -sf $A libsbigudrv.a; done
for A in libsbigudrv*.so; do ln -sf $A libsbigudrv.so; done
cd $TMP
rm -rf $TDIR
echo "done"
  
echo -n "Setting up udev rules..."
cd $INSTPATH
cp -i ../udev/nightview.rules $DESTDIR/etc/udev/rules.d/
cp -i ../udev/nightview.sh $DESTDIR/lib/udev/devices/
echo "done"

echo -n "Running ldconfig..."
ldconfig
echo "done"

echo 
echo " -----------------------------------------------------------------"
echo
echo " Successful installation."
echo
echo " Now, you can cleanly install Nightview with enabled camera daemon."
echo " cd to installdir and then type: configure && make && make install"
echo " The sbig files can be uninstalled with script:"
echo "     /usr/local/sbin/uninstall_sbig_firmware.sh"
echo 

if [ $FX -ne 0 ]; then
   echo "! Don't forget install fxload utility!"
   fxload_warning
fi

if [ $FS -ne 0 ]; then
   echo "! Don't forget add usbfs to your /etc/fstab!"
   usbfs_warning
fi

exit 0
