
/*

   wrapper to get current system time in FITS format

   $Id: systime.c,v 1.1 2007-05-07 18:36:48 hroch Exp $

*/


#include <time.h>
#include <sys/time.h>
#include <syslog.h>
#include <fitsio.h>
#include <string.h>


void systime(char *datetime)
{
  int ret;
  time_t t;
  struct timeval tv;
  struct tm d;
  const double milion = 1e6L;

  gettimeofday(&tv,NULL);
  t = tv.tv_sec;
  gmtime_r(&t,&d);

  ret = 0;
  fits_time2str(d.tm_year+1900,d.tm_mon+1,d.tm_mday,
		d.tm_hour,d.tm_min,d.tm_sec+tv.tv_usec/milion,3,datetime,&ret);

  if( ret ) {
    syslog(LOG_ERR,"It is not possible to get UTC.\n");
    strcpy(datetime,"");
  }
}
