
/*

   Evaluate astronomical expressions (sum a difference of coordinates).

 $Id: astro_eval.c,v 1.9 2007-06-13 19:51:10 hroch Exp $

*/

#include <math.h>
#include "astro.h"

/* 
   compute the shorter difference in longitude-type angle coordinates 
*/
double diff_ra(double ra2, double ra1)
{
  double d, minus;
 
  while( ra1 >= 360.0 )
    ra1 = ra1 - 360.0;
  
  while( ra1 < 0.0 )
    ra1 = ra1 + 360.0;

  while( ra2 >= 360.0 )
    ra2 = ra2 - 360.0;
  
  while( ra1 < 0.0 )
    ra1 = ra1 + 360.0;

  if( ra2 > ra1 )
    minus = -1.0;
  else
    minus = 1.0;

  d = ra2 - ra1;

  /* select shorter distance on the sphere */
  if( fabs(d) > 180.0 ) {
    d = 360.0 - fabs(d);
    d = d*minus;
  }
  d = ra2 - ra1;
  return(d);
}

/*
  difference in hour angle
*/

double diff_ha(double ha2, double ha1,double spin)
{
  double d/*, dt*/;

  if( ha1 > 180.0 )
    ha1 = ha1 - 360.0;
  if( ha2 > 180.0 )
    ha2 = ha2 - 360.0;

  if( (-180.0 < ha1 && ha1 <= 180.0) &&
      (-180.0 < ha2 && ha2 <= 180.0) )
      d = ha2 - ha1;
  else if( ha1 <= 180.0 ) 
    d = ha2 - (360.0 + ha1);
  else if( ha2 <= 180.0 )
    d = (360.0 + ha2) - ha1;
  else 
    return(-999.9);    

  d = d + 360.0*spin;

  if( fabs(d) > 360.0 )
    return(-999.9);

#ifdef DEBUG
  printf("rozil hodinovych uhlu: %f %f %f\n",ha1,ha2,d);
#endif

  /* correction for the Earth rotation during slew */
  //dt = fabs(d)/vel/240.0;        // 1deg = 240 seconds
  //d = d + dt;

#ifdef DEBUG
  printf("corr: %f %f %f\n",dt,d,d-dt);
#endif

  return(d);
}


/* 
   compute the shorter difference in hour latitude like coordinate 
*/
double diff_dec(double dec2, double dec1)
{
  double d;

  d = dec2 - dec1;
  return(d);
}

/*
   sum of ra's, check the interval of result
*/
double add_ra( double ra1, double ra2)
{
  double ra;

  ra = ra1 + ra2;
  
  while( ra >= 360.0 )
    ra = ra - 360.0;

  while( ra < 0.0 )
    ra = ra + 360.0;

  return(ra);
}

/*
   sum of ra's, check the interval of result
*/
double add_dec( double dec1, double dec2)
{
  double dec;

  dec = dec1 + dec2;
  
  if( dec > 90.0 )
    dec = 90.0;

  if( dec < -90.0 )
    dec = -90.0;

  return(dec);
}


/*

  distance in spherical coordinates

*/

/*
double dang(double ra1, double dec1, double ra2, double dec2)
{
  double r1,r2,d1,d2;

  d1 = dec1/RAD;
  d2 = dec2/RAD;
  r1 = ra1/RAD;
  r2 = ra2/RAD;

  return(RAD*acos(sin(d1)*sin(d2) + cos(d1)*cos(d2)*cos(ra1 - ra2)));
}
*/

 /* identification of zero value within interval ha1..ha2 */
double izero(double h1,double h2)
{

  if( fabs(h1) > 90.0 && fabs(h2) > 90.0 ) {

    if( h1 > 90.0 )
      h1 = h1 - 180.0;
    else if( h1 < 90.0 )
      h1 = h1 + 180.0;

    if( h2 > 90.0 )
      h2 = h2 - 180.0;
    else if( h2 < 90.0 )
      h2 = h2 + 180.0;

    if( h2*h1 < 0.0 ) {
      if( h2 > h1 )
	return(-1.0);
      else
	return(1.0);
    }
    else
      return(0.0);
  }
  else
    return(0.0);

}
