
/*

   control axis

   $Id: axis.c,v 1.7 2008-09-12 21:46:40 hroch Exp $

*/

#include <stdlib.h>
#include "mount.h"

void init_axis(AXIS *a)
{
  a->jd = 0.0;
  a->jd_start = 0.0;
  a->jd_stop = 0.0;
  a->set = 0;
  a->coo = 0.0;
  a->coo_start = 0.0;
  a->coo_stop = 0.0;
  a->vel = 0.0;
  a->velmax = 0.0;
  a->veldef = 0.0;
  a->diffcoo = 0.0;
  a->guide = 0;
  a->mode = 0;
  a->brake = 0;
  a->stoped = 0;
  a->tdur = -1.0;
  a->move = 0;
  a->set = 0;
  a->dir = 0;
  a->start_command = NULL;
  a->stop_command = NULL;
}

void init_clock(CLOCK *a)
{
  a->clock = 0;
  a->setclock = 0;
  a->clock_save = 0;
  a->clock_vel = -1.0;
  a->clock_command = NULL;
}

void set_axis_start_command(AXIS *a,char *c)
{
  a->start_command = c;
}

void set_axis_stop_command(AXIS *a,char *c)
{
  a->stop_command = c;
}

void set_axis_clock_command(CLOCK *a,char *c)
{
  a->clock_command = c;
}

double aget_coo(AXIS *a)
{
  return(a->coo);
}

double aget_coostop(AXIS *a)
{
  return(a->coo_stop);
}

double aget_vel(AXIS *a)
{
  return(a->vel);
}

double aget_veldef(AXIS *a)
{
  return(a->veldef);
}

double aget_velmax(AXIS *a)
{
  return(a->velmax);
}

int aget_clock(CLOCK *a)
{
  return(a->clock);
}

int aget_move(AXIS *a)
{
  return(a->move);
}

int aget_stoped(AXIS *a)
{
  return(a->stoped);
}

double aget_timer(AXIS *a)
{
  double dt;

  dt = 86400.0*(a->jd - a->jd_start);
  if( a->jd_start <= a->jd && a->jd <= a->jd_stop )
    ;
  else
    dt = 0.0;
  return(dt);
}

double aget_duration(AXIS *a)
{
  if( a->jd_start <= a->jd && a->jd <= a->jd_stop )
    return(86400.0*a->tdur);
  else
    return(0.0);
}

void aset_coo(AXIS *a, double x, int mode)
{
  a->set = 1;
  a->mode = mode;
  a->set_diffcoo = x;
  //a->move = 1;
}

void aset_cal(AXIS *a, double x)
{
  a->coo = x;
}

void aset_vel(AXIS *a, double x)
{
  if( 0.0 <= x && x <= a->velmax )
    a->set_vel = x;
  else
    a->set_vel = a->veldef;
}

void aset_velmax(AXIS *a, double x)
{
  a->velmax = x;
}

void aset_veldef(AXIS *a, double x)
{
  a->veldef = x;
}

void aset_velclock(CLOCK *a, double x)
{
  a->clock_vel = x;
}

void aset_move(AXIS *a,int direction)
{
  a->set = 1;
  a->mode = -1;
  a->set_dir = direction;
}

void aset_stoped(AXIS *a,int i)
{
  a->stoped = i;
}

void aset_stop(AXIS *a)
{
  a->stop = 1;
}

void aset_clock(CLOCK *a, double vel)
{
  a->clock = 1;
  a->clock_vel = vel;
  a->setclock = 1;
} 

void aset_clock_stop(CLOCK *a)
{
  a->clock = 0;
  a->setclock = 1;
} 

int update_axis(AXIS *a, double interval)
{
  double jd,tdur;
  int ret;

  ret = 1;

  if( a->start_command == NULL )
    return(ret);

  /* update time */
  jd = julian();
  if( jd > a->jd + interval )
    a->jd = jd;
  else
    return(1);
  
  if( a->brake == 1 ) {
    /* don't do anything during stop braking */

    if( a->jd_stop < a->jd ) {
      a->move = 0;
      a->mode = 0;
      a->stoped = 1;
      a->brake = 0;
      a->coo = a->coo_stop;
      a->tdur = -1.0;
      a->vel = 0.0;
      a->set = 0;
      a->stop = 0;
    }
    return(1);
  }

  /* stop moving only when we are moving, prevent race condition
     when stop is released after end of stop braking */
  if( a->stop == 1 && a->move == 0 ) {
    a->stop = 0;
  }

  /* stop motion */
  if( a->stop == 1 ) {
    a->stop = 0;

    ret = slew_stop(a->start_command,a->set_vel,&tdur);

    if( ret == 1 ) {
      a->set = 0;
      a->mode = 2;
      a->move = 1;
      a->brake = 1;
      a->coo_start = a->coo;
      a->coo_stop = a->coo;
      a->diffcoo = 0.0;
      a->tdur = tdur;
      a->jd_stop = a->jd + a->tdur;
    }
    return(ret);
  }

  /* run command */
  if( a->set == 1 ) {
    a->set = 0;

    if( a->move == 0 ) {

      /* set to specified coordinates */
      if( a->mode == 0 || a->mode == 1 )

	ret = slew_start_d(a->start_command,a->set_diffcoo,a->set_vel,&tdur);

      else if( a->mode == -1 )

	ret =  slew_start_g(a->start_command,a->set_dir,a->set_vel);

      else
	ret = 0;

      if( ret == 1 ) {
	a->move = 1;
	a->diffcoo = a->set_diffcoo;
	a->dir = a->set_dir;
	a->vel = a->set_vel;
	a->tdur = tdur;
	a->coo_start = a->coo;
	a->coo_stop = a->coo + a->diffcoo;
	a->jd_start = a->jd;
	a->jd_stop = a->jd_start + a->tdur;
      }
      else
	a->move = 0;
    }
    else
      ret = 0;
  }

  if( a->guide == 1 ) {
    /* guide */
  }

  if( a->move == 1 ) {

    if( a->mode == -1 && a->brake == 0 ) {

      /* estimate current position on base velocity (non-stop slew) */
      a->coo = a->coo_start + 86400.0*a->dir*a->vel*(a->jd - a->jd_start);

    }
    else {

      if( a->jd_stop < a->jd ) {
	a->move = 0;
 	a->stoped = 1;
	a->brake = 0;
	a->coo = a->coo_stop;
	a->tdur = -1.0;
	a->vel = 0.0;
      }
      else 
        /* estimate current position on base of elapsed time */
	a->coo = a->coo_start + a->diffcoo*(a->jd - a->jd_start)/a->tdur;
    }
  }

  return(ret);
}

int update_axis_clock(CLOCK *c)
{
  int ret;

  ret = 1;

  if( c->setclock == 1 ) {
    c->setclock = 0;

    if( c->clock == 1 ) {      
      
      ret = slew_clock(c->clock_command,c->clock,c->clock_vel);
      if( ret == 0 ) c->clock = c->clock_save; 

    }
    else if( c->clock == 0 ) {
      
      ret = slew_clock(c->clock_command,c->clock,-1.0);
      if( ret == 0 ) c->clock = c->clock_save;

    }
  }
  return(ret);
}    

