/*

   interfaces to  library, client side 

   $Id: interface.c,v 1.13 2007-08-29 20:11:09 hroch Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include "mount.h"
#include "com.h"

/* time step to update an info about mount status */
#define TIME_STEP 1

#define LEN 500

static TELE *tel_new(char *address)
{
  TELE *t;

  if( (t = malloc(sizeof(TELE))) &&
      (t->address = malloc(strlen(address) + 1)) ) {
    strcpy(t->address,address);
    t->ra = 999.999;
    t->dec = 999.999;
    t->ha = 999.999;
    t->azimut = 999.999;
    t->zenit = 999.999;
    t->jd = 0.0;
    t->clock = -1;
    t->id = NULL;
    t->time = 0;
    t->synchro = 0;
    return(t);
  }
  return(NULL);
}

static int update_state(TELE *tel)
{
  time_t t, t0;
  ssize_t i;
  char *buf;
  TFILE *id;

  id = (TFILE *) tel->id;
  t = time((time_t *)0);
  t0 = tel->time;

  if( tel && difftime(t,t0) > (time_t) TIME_STEP ) {
    i = -1;
    if( (buf = ccdnet_get_tstring(tel->address,TEL_INFO)) ) {
#ifdef DEBUG
      printf("%s\n",buf);
#endif
      i = sscanf(buf,"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %d",
		 &(tel->jd),&(tel->ra),
		 &(tel->ara),&(tel->dec),&(tel->adec),&(tel->dome),
                 &(tel->azimut),&(tel->zenit),&(tel->ha),&(tel->mhc),
		 &(tel->synchro)) == 11;
      free(buf);
    } 

    tel->time = t;
    return(i);
  }
  return(-1);

}


int tel_login(char *address)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_tstring(address,LOGIN)) ) {
    if( strstr(buf,WELCOME) )
      i = OK;
    free(buf);
  }
  return(i);  
}


TELE *tel_init(char *sdevice)
{
  TELE *t = NULL;
  char *buf;

  if( (buf = ccdnet_get_tstring(sdevice,LOGIN)) ) {
    if( strstr(buf,WELCOME)) {
      t = tel_new(sdevice);
      /*      update_state(t);*/
    }
    free(buf);
    return(t);
  }
  return(NULL);
}

float get_ra(TELE *tel)
{

  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->ra);
}

float get_ara(TELE *tel)
{

  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->ara);
}

float get_ha(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->ha);
}

float get_dec(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->dec);
}

float get_adec(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->adec);
}

float get_azimut(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->azimut);
}

float get_dome(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->dome);
}

float get_zenit(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->zenit);
}

double get_jd(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->jd);
}

double get_mhc(TELE *tel)
{
  if( tel == NULL ) 
    return(999.999);

  update_state(tel);
  return(tel->mhc);
}

int get_synchro(TELE *tel)
{
  if( tel == NULL ) 
    return(0);

  update_state(tel);
  return(tel->synchro);
}


int get_status(TELE *tel, int *hclock, double *ra, double *ra1, double *dec, double *dec1, double *dome, double *dome1)
{
  int i;
  char *buf;

  if( tel ) {
    if( (buf = ccdnet_get_tstring(tel->address,TEL_GET)) ) {
      i = sscanf(buf,"%d %lf %lf %lf %lf %lf %lf",hclock,ra,ra1,dec,dec1,dome,dome1);
      free(buf);
      return(i);
    } 
  }
  return(-1);
}

int get_velstat(TELE *tel, double *vra, double *vdec, double *maxvelra, double *maxveldec)
{
  int i;
  char *buf;

  if( tel ) {
    if( (buf = ccdnet_get_tstring(tel->address,TEL_STATUS)) ) {
      i = sscanf(buf,"%lf %lf %lf %lf",vra,vdec,maxvelra,maxveldec);
      free(buf);
      return(i);
    } 
  }
  return(-1);
}



int set_calibrate(TELE *t, float x, float y)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f %f",TEL_CALIBRATE,x,y);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_CALIBRATED,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

int set_coo(TELE *t, float x, float y, float vx, float vy)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f %f %f %f",TEL_SET,x,y,vx,vy);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

int set_coa(TELE *t, float x, float y, float vx, float vy)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f %f %f %f",TEL_SET_I,x,y,vx,vy);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

/*
int set_velra(TELE *t, float x)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f",TEL_SET_VELRA,x);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

int set_veldec(TELE *t, float x)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f",TEL_SET_VELDEC,x);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

int set_velclock(TELE *t, float x)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f",TEL_SET_VELCLOCK,x);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}
*/

/*
int set_ra(TELE *t, float x)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f",TEL_SET_RA,x);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}
*/

int set_dra(TELE *t, float x,float v)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f %f",TEL_SET_DRA,x,v);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

int set_xra(TELE *t, char *direction,float v)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %s %f",TEL_SET_XRA,direction,v);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

/*
int set_dec(TELE *t, float x)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f",TEL_SET_DEC,x);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}
*/

int set_ddec(TELE *t, float x,float v)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %f %f",TEL_SET_DDEC,x,v);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}

int set_xdec(TELE *t, char *direction,float v)
{
  char line[LEN], *buf;
  int i;
  
  i = FAIL;
  snprintf(line,LEN,"%s %s %f",TEL_SET_XDEC,direction,v);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
      if( strstr(TEL_SETOK,buf) )
	i = OK;
      free(buf);
    } 
  return(i);
}


/*
int set_ha(TELE *t, float x)
{
  return(0);
}


int set_azimut(TELE *t, float x)
{
  return(0);
}

int set_zenit(TELE *t, float x)
{
  return(0);
}
*/

int clock_start(TELE *t, float v)
{
  char line[LEN],*buf;
  int i;

  i = FAIL;
  snprintf(line,LEN,"%s %f",TEL_CLOCK_ON,v);
  if( (buf = ccdnet_get_tstring(t->address,line)) ) {
    if( strstr(buf,TEL_CLOCK_ONOK) )
      i = OK;
    free(buf);
  }
  return(i);  
}

int clock_stop(TELE *t)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_tstring(t->address,TEL_CLOCK_OFF)) ) {
    if( strstr(buf,TEL_CLOCK_OFFOK) )
      i = OK;
    free(buf);
  }
  return(i);  
}

int park(TELE *t)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_tstring(t->address,TEL_PARK)) ) {
    if( strstr(buf,TEL_PARKING) )
      i = OK;
    free(buf);
  }
  return(i);  
}

int stop(TELE *t)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_tstring(t->address,TEL_STOP)) ) {
    if( strstr(buf,TEL_STOPOK) )
      i = OK;
    free(buf);
  }
  return(i);  
}

int stop_ra(TELE *t)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_tstring(t->address,TEL_STOP_RA)) ) {
    if( strstr(buf,TEL_STOPOK) )
      i = OK;
    free(buf);
  }
  return(i);  
}

int stop_dec(TELE *t)
{
  char *buf;
  int i;

  i = FAIL;
  if( (buf = ccdnet_get_tstring(t->address,TEL_STOP_DEC)) ) {
    if( strstr(buf,TEL_STOPOK) )
      i = OK;
    free(buf);
  }
  return(i);  
}
