
/*

  header file for mount

  $Id: mount.h,v 1.23 2008-09-12 21:46:40 hroch Exp $

*/

#include <time.h>

typedef struct _TELESCOPE TELE;

struct _TELESCOPE {
  double ra;                 /* Right Ascension */
  double ara;                /* apparent R.A. = ra + refraction */
  double dec;                /* Declination */
  double adec;               /* apparent Dec = dec + refraction */
  double ha;                 /* Hour Angle */
  double aha;                 /* apparent Hour Angle */
  double azimut;             /* Azimut */
  double zenit;              /* Zenit distance */
  double dome;               /* azimut of the dome's slit */ 
  double jd;                /* Julian date */
  double mhc;                /* local Mean siderical time */
  double latitude;           /* geographical latitude of the observatory */
  double longitude;           /* geographical longitude of the observatory */
  double spin;               /* indication of sping telescope around */
  int clock;                /* 1 if driving clock is on, 0 off, -1 unknown state */
  int synchro;              /* if the coordinates are synchronized (probably)*/

  char *address;            /* host address */
  void *id;                /* socket to the server */
  time_t time;              /* time of last connect */
};

typedef struct _AXIS AXIS;

struct _AXIS {

  double jd;              /* reference time */
  double jd_start;        /* start time of last slew */
  double jd_stop;         /* stop time of last slew */
  double coo;             /* coordinate value, degrees */
  double coo_start;       /* start coordinate of last slew */
  double coo_stop;        /* stop coordinate of last slew */ 
  double vel;             /* slew velocity, deg/sec */
  double set_vel;         /* input slew velocity */
  double velmax;          /* upper bound for velocity */
  double veldef;          /* default value for velocity */
  double diffcoo;         /* setpoint in coordinate difference */
  double set_diffcoo;     /* input setpoint to diffcoo */
  double tdur;            /* estimate of duration of slew */
  int move;               /* status of axis, 0 in rest, 1 in motion */
  int stoped;             /* set to 1 early after stop */
  int guide;              /* guide for refraction, etc. */
  int set;                /* new setpoint is specified */
  int dir;                /* direction for nonstop slew */
  int set_dir;            /* input direction */
  int stop;               /* set up stop */
  int mode;               /* mode for slew, 0 - to specified coordinates
                              -1 - slew without endpoint, 2 - stop braking */
  int brake;              /* 1 - stop braking, 0 - otherwise */
  char *start_command;    /* command to execute for start of slew */
  char *stop_command;     /* command to execute for stop of slew */

};

typedef struct _CLOCK CLOCK;

struct _CLOCK {

  /* right ascension/hour angle specific stuff */
  int clock;              /* clock on/off */
  int setclock;           /* set clock on 1 */
  int clock_save;          /* save previous status of clock */
  double clock_vel;       /* clock velocity, deg/sec */
  char *clock_command;    /* command to set clock */

};


/* ----  server specific ---- */

/* the path to the socket file */
/*
#define MOUNT_SHOCK "file:///var/tmp/.telescope_shock"
#define MOUNT_SHOCK_LOCAL "/var/tmp/.telescope_shock"
*/
/* second item is derived from first! */

/* the file with current position of telescope and dome */
/*#define POSITION_FILE "/var/lib/nightview/telescope_pos"*/
#define POSITION_FILE "/var/tmp/telescope_pos"

/* the commit interval to save coordinates in seconds */
#define COMMIT_DELAY 10

/* the interval for check the state of the dome slice in seconds */
#define DOME_INTERVAL 60

/* the interval for time resolution in main loop in nanoseconds*/
#define LOOP_STEP 50000000

/* the dome step when clockmachine is up, in degrees */
#define DOME_STEP 5.0

/* block size, convention, no more then one line we will using */
#define BLOCK 500

#define OK 1
#define FAIL 0

/* ------- astronomical values ------- */
extern int mount_init(int argc, char *argv[]);
extern void mount_shutdown(void);
extern char *mount(char *,size_t *);

extern double julian(void);
extern void conve(double jd, double ra, double dec, double latitude, double longitude,
		  double *a, double *z, double *h);
extern void conve1(double jd, double a, double z, double latitude, double longitude,
		   double *ra, double *dec);
extern void conve0(double jd, double ha, double dec, double latitude, double longitude, double *a, double *z);
extern void conve10(double, double, double, double, double, double *, double *);
extern double rekta(double, double);
extern double houra(double, double);
extern void toappar(double, double, double, double *, double *);
extern void fromappar(double, double, double, double *, double *);
extern double diff_ra(double ra2, double ra1);
extern double diff_ha(double ha2, double ha1, double);
extern double diff_dec(double dec2, double dec1);
extern double add_ra(double ra2, double ra1);
extern double add_dec(double dec2, double dec1);
extern double izero(double,double);

/* --- comunication commands ---- */

#define LOGIN "login"
#define WELCOME "welcome"

#define TEL_INFO "telescope info"

#define TEL_STATUS "telescope status"

#define TEL_CONNECT "telescope connect"
#define TEL_CONNECTED "telescope connected"

#define TEL_CALIBRATE "telescope calibrate"
#define TEL_CALIBRATED "telescope calibrated"
#define TEL_CALIBRATEDFAIL "telescope not calibrated"

#define TEL_SET "telescope set coo"
#define TEL_SET_RA "telescope set ra"
#define TEL_SET_DEC "telescope set dec"
#define TEL_SET_I "telescope set ha"
#define TEL_SET_DRA "telescope set dra"
#define TEL_SET_DDEC "telescope set ddec"
#define TEL_SET_XRA "telescope set xra"
#define TEL_SET_XDEC "telescope set xdec"

#define TEL_SETOK "telescope set ok"
#define TEL_SETFAIL "telescope set fail"

#define TEL_GET "telescope get"
#define TEL_GETOK "telescope get ok"

#define TEL_CLOCK_ON "telescope clock on"
#define TEL_CLOCK_ONOK "telescope clock on ok"

#define TEL_CLOCK_OFF "telescope clock off"
#define TEL_CLOCK_OFFOK "telescope clock off ok"

#define TEL_STOP "telescope move stop"
#define TEL_STOP_RA "telescope move stop ra"
#define TEL_STOP_DEC "telescope move stop dec"
#define TEL_STOPOK "telescope stop ok"
#define TEL_STOPFAIL "telescope stop fail"

#define TEL_PARK "telescope park"
#define TEL_PARKING "telescope parking"

#define TEL_NA "not available"

#define DOME_OPEN "dome open"
#define DOME_OPENED "dome opended"

#define DOME_CLOSE "dome close"
#define DOME_CLOSED "dome closed"

#define DOME_SET "dome set"
#define DOME_SETED "dome seted"

/* --- comunnication layer ---- */

extern int tel_login(char *);
extern TELE *tel_init(char *);
extern char *cmpkey(char *, char *);
extern float get_ra(TELE *);
extern float get_ara(TELE *);
extern float get_dec(TELE *);
extern float get_adec(TELE *);
extern float get_ha(TELE *);
extern float get_azimut(TELE *);
extern float get_dome(TELE *);
extern float get_zenit(TELE *);
extern double get_jd(TELE *);
extern double get_mhc(TELE *);
extern int get_synchro(TELE *);
extern int get_status(TELE *tel, int *, double *, double *, double *, double *, double *, double *);
extern int get_velstat(TELE *tel, double *, double *, double *, double *);
extern int set_coo(TELE *t, float x, float y, float, float);
extern int set_coa(TELE *t, float x, float y, float, float);
extern int set_calibrate(TELE *,float,float);
extern int set_dra(TELE *,float,float);
extern int set_xra(TELE *,char *,float);
extern int set_ddec(TELE *,float,float);
extern int set_xdec(TELE *,char *,float);
extern int set_ha(TELE *,float);
extern int set_azimut(TELE *,float);
extern int set_zenit(TELE *,float);

extern int clock_start(TELE *,float);
extern int clock_stop(TELE *);
extern int park(TELE *);
extern int stop(TELE *);
extern int stop_ra(TELE *);
extern int stop_dec(TELE *);

/* --- axis --- */
extern void init_axis(AXIS *);
extern void init_clock(CLOCK *);
extern void set_axis_start_command(AXIS *,char *);
extern void set_axis_stop_command(AXIS *,char *);
extern double aget_coo(AXIS *);
extern double aget_coostop(AXIS *);
extern double aget_ra(AXIS *);
extern double aget_ara(AXIS *);
extern double aget_vel(AXIS *);
extern double aget_velmax(AXIS *);
extern double aget_veldef(AXIS *);
extern int aget_move(AXIS *);
extern int aget_stoped(AXIS *);
extern double aget_duration(AXIS *);
extern double aget_timer(AXIS *);
extern void aset_coo(AXIS *, double, int);
extern void aset_cal(AXIS *, double);
extern void aset_acal(AXIS *, double);
extern void aset_ra(AXIS *, double);
extern void aset_ara(AXIS *, double);
extern void aset_vel(AXIS *, double);
extern void aset_velmax(AXIS *, double);
extern void aset_veldef(AXIS *, double);
extern void aset_move(AXIS *,int);
extern void aset_stoped(AXIS *,int);
extern void aset_stop(AXIS *);

extern int aget_clock(CLOCK *);
extern void aset_clock(CLOCK *, double);
extern void aset_clock_stop(CLOCK *);
extern void aset_velclock(CLOCK *, double);
extern void set_axis_clock_command(CLOCK *,char *);
extern int update_axis(AXIS *,double);
extern int update_axis_clock(CLOCK *);

/* slew */
extern int slew_start_d(char *, double, double, double *);
extern int slew_start_g(char *, int, double);
extern int slew_stop(char *,double,double *);
extern int slew_clock(char *, int, double);

/* init */
extern int initvelo(char *, char *, double *);

/* --- system commands to move --- */
#define REKL_COMMAND "telescope_hang"
#define DEKL_COMMAND "telescope_dekl"
#define DOME_COMMAND "telescope_dome"
#define DOME_INIT "telescope_domeinit"
#define CLOCK_COMMAND "telescope_clock"

