
/* 

   slew commands

   all routines returns 1 on success and 0 on failure

   $Id: slew.c,v 1.5 2008-09-12 21:46:40 hroch Exp $

*/

#include <stdio.h>
#include <syslog.h>
#include <sys/types.h>
#include "mount.h"
#include "exec.h"

#define LEN 256

int slew_start_d(char *command, double diff, double vel, double *dur)
{
  char line[LEN+1], line1[LEN+1], out[LEN+1];
  char *args[4];

  snprintf(line,LEN,"%f",diff);
  snprintf(line1,LEN,"%f",vel);

  args[0] = command;
  args[1] = line;
  args[2] = line1;
  args[3] = NULL;

  if( exec_command(command,args,out,LEN) == 0 && sscanf(out,"%lf",dur) == 1 ) {
    *dur = *dur/86400.0L;
    return(1);
  }
  else {
    syslog(LOG_ERR,"Duration read failed.\n");
    return(0);
  }

}

int slew_start_g(char *command, int direction, double vel)
{
  char *line, line1[LEN+1], out[LEN+1];
  char *args[4];

  if( direction < 0 )
    line = "-";
  else
    line = "+";
  snprintf(line1,LEN,"%f",vel);

  args[0] = command;
  args[1] = line;
  args[2] = line1;
  args[3] = NULL;

  if( exec_command(command,args,out,LEN) == 0 ) {
    return(1);
  }
  else {
    syslog(LOG_ERR,"slew: nonstop run failed.\n");
    return(0);
  }

  
}


int slew_stop(char *command, double vel, double *dur)
{
  char out[LEN+1], line1[LEN+1];
  char *args[3];

  snprintf(line1,LEN,"%f",vel);

  args[0] = command;
  args[1] = "stop";
  args[2] = line1;
  args[3] = NULL;

  if( exec_command(command,args,out,LEN) == 0 && sscanf(out,"%lf",dur) == 1 ){
    *dur = *dur/86400.0L;
    return(1);
  }
  else {
    syslog(LOG_ERR,"Stop command failed.\n");
    return(0);
  }

}

int slew_clock(char *command, int clock, double vel)
{
  char line[LEN+1], line1[LEN+1], out[LEN+1];
  char *args[4];

  args[0] = command;

  snprintf(line,LEN,"%d",clock);
  args[1] = line;

  if( vel > 1e-7 ) {
    snprintf(line1,LEN,"%f",vel);
    args[2] = line1;
    args[3] = NULL;
  }
  else
    args[2] = NULL;

  if( exec_command(command,args,out,LEN) != -1 ) {
    return(1);
  }
  else {
    syslog(LOG_ERR,"Wrong clock response.\n");
    return(0);
  }

}
