%define packver 0.3.0-0
Name: nightview
Summary: Dummy Nightview package
Version: 0.3
Release: 1
License: GNU GPL
Group: Applications/Science
Source0: ftp://integral.sci.muni.cz/pub/%{name}/nightview_%{packver}.tar.gz
Source1: COPYING
Source2: nightview-server.init.redhat
Source3: nightview-remote.init.redhat
Source4: mount-server.init.redhat
Source5: nightview-env.init.redhat
URL: http://www.physics.muni.cz/mb/nightview/
Packager: David Necas (Yeti) <yeti@physics.muni.cz>
Vendor: Trific soft.
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
#Patch0: %{name}-sgml-paths.patch
%define ndocdir %{_datadir}/doc/%{name}-doc
# Debian specific \, comment out all strings 'BuildPrereq'
#BuildPrereq: sgml-common
#BuildPrereq: docbook-style-xsl
#BuildPrereq: docbook-style-dsssl
# FIXME: I'm unable to make openjade work with catalogs
#BuildPrereq: docbook-dtds = 1.0-14
#BuildPrereq: openjade
#BuildPrereq: gtk+-devel

%package -n %{name}-gtk
Summary: Graphical utility to control of CCD camera
Group: Applications/Science

%package -n %{name}-doc
Summary: Documentation for nightview
Group: Applications/Science

%package -n %{name}-server
Summary: Server to control of CCD camera
Group: System Environment/Daemons
Requires: initscripts
Requires: chkconfig

%package -n %{name}-shell
Summary: Console utilities to control of CCD camera.
Group: Applications/Science

%package -n libccdsbig
Summary: Wrapper library to libsbig
Group: Development/Libraries

%package -n libccdsbig-devel
Summary: Development files for libccdsbig
Group: Development/Libraries
Requires: libccdsbig = %{version}

%package -n libccdnet
Summary: Client part of CCD library.
Group: Development/Libraries

%package -n libccdnet-devel
Summary: Development files for libccdnet
Group: Development/Libraries
Requires: libccdnet = %{version}

%package -n mount-server
Summary: Server to control of telescope mount
Group: System Environment/Daemons

%package -n mount-shell
Summary: Console utilities to control of telescope's mount
Group: Applications/Science

%package -n mount-xmove
Summary: Graphical utility to control of telescope's mount
Group: Applications/Science

%package -n %{name}-remote
Summary: A server to remote control of CCD camera
Group: System Environment/Daemons

%description
This is a side-effect of RPM package naming.  Don't install it,
it contains no files.

%description gtk
This package provides graphical frontend to control of a CCD camera.

%description doc
Nightview documentation, in several formats (PS, PDF, HTML, man page).

%description server
This package provides local daemon for control of a CCD camera.

%description remote
 This package provides remote access for nightview-server and mount-server.
 This package contains shell scripts to run http server (boa) and cgi 
 routine to comunicate with CCD camera over internet. 

This package provides local daemon for control of a CCD camera.

%description shell
his package provides console utilities to control of a CCD camera.

%description -n libccdsbig
This is a wrapper for the driver library libsbig by S. Ashe.

%description -n libccdsbig-devel
This is a wrapper for the driver library libsbig by S. Ashe. 
Static library.

%description -n libccdnet
This library provides unified and transparent interface to use
CCD camera over network. Static library.


%description -n libccdnet-devel
This library provides unified and transparent interface to use                  
CCD camera over network. Static library.                                        

%description -n mount-server
This package provides local daemon for control of telescope mount.
This server require an additional, user provided commands to
control of your own mount. The low-level shell commands for 
a specified mount must be provided.
   

%description -n mount-shell
This package provides console utilities to control of mount of telescope.

%description -n mount-xmove
This package provides graphical frontend to control of telescope's mount.

%prep
%setup -a0 -n %{name}
# Debian specific, comment out follow line
#%patch0 -p 1
cp rpm/COPYING .

%build
make
cd xmove && perl Makefile.PL && make && cd ..

%install
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/%{name}/cgi-bin
mkdir -p $RPM_BUILD_ROOT%{_includedir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/html
mkdir -p $RPM_BUILD_ROOT%{ndocdir}
make install DESTDIR=$RPM_BUILD_ROOT
install -m 644 debian/nightview.1 $RPM_BUILD_ROOT%{_mandir}/man1
install -m 644 COPYING $RPM_BUILD_ROOT%{ndocdir}
install -m 755 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/init.d/nightview-server
install -m 755 %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}/init.d/nightview-remote
install -m 755 %{SOURCE4} $RPM_BUILD_ROOT%{_sysconfdir}/init.d/mount-server
install -m 755 %{SOURCE5} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/nightview

%clean
rm -rf $RPM_BUILD_ROOT

%post -n libccdsbig
/sbin/ldconfig

%post -n libccdnet
/sbin/ldconfig

%postun -n libccdsbig
/sbin/ldconfig

%postun -n libccdnet
/sbin/ldconfig

%post -n %{name}-server
/sbin/chkconfig --add nightview-server

%post -n %{name}-remote
/sbin/chkconfig --add nightview-remote

%post -n mount-server
/sbin/chkconfig --add mount-server

%preun -n %{name}-server
if [ "$1" = 0 ]; then
  /sbin/service nightview-server stop >/dev/null 2>&1 || :
  /sbin/chkconfig --del nightview-server
fi

%preun -n %{name}-remote
if [ "$1" = 0 ]; then
  /sbin/service nightview-remote stop >/dev/null 2>&1 || :
  /sbin/chkconfig --del nightview-remote
fi

%preun -n mount-server
if [ "$1" = 0 ]; then
  /sbin/service mount-server stop >/dev/null 2>&1 || :
  /sbin/chkconfig --del mount-server
fi

%postun -n %{name}-server
/sbin/service nightview-server condrestart >/dev/null 2>&1 || :

%postun -n %{name}-remote
/sbin/service nightview-remote condrestart >/dev/null 2>&1 || :

%postun -n mount-server
/sbin/service mount-server condrestart >/dev/null 2>&1 || :

%files

%files gtk
%defattr(755,root,root)
%{_bindir}/gtknightview
%defattr(644,root,root)
%doc %{_mandir}/man1/gtknightview.1*
%dir %doc %{_mandir}/man1
%doc COPYING

%files shell
%defattr(755,root,root)
%{_bindir}/night_control
%{_bindir}/night_exposure
%{_bindir}/night_filter
%{_bindir}/night_temperature
%{_bindir}/night_keylist
%{_bindir}/night_power
%{_bindir}/night_dark
%{_bindir}/nightview-test
%defattr(644,root,root)
%doc %{_mandir}/man1/night_control.1*
%doc %{_mandir}/man1/night_exposure.1*
%doc %{_mandir}/man1/night_filter.1*
%doc %{_mandir}/man1/night_temperature.1*
%doc %{_mandir}/man1/night_keylist.1*
%doc %{_mandir}/man1/night_power.1*
%doc %{_mandir}/man1/night_dark.1*
%doc %{_mandir}/man1/nightview-test.1*
%dir %doc %{_mandir}/man1
%doc COPYING

%files server
%defattr(755,root,root)
%config(noreplace) %{_sysconfdir}/sysconfig/nightview
%{_sysconfdir}/init.d/nightview-server
%{_sbindir}/nightviewd
%{_sbindir}/nightview-conf
%defattr(644,root,root)
%doc %{_mandir}/man8/nightviewd.8*
%doc %{_mandir}/man8/nightview-conf.8*
%dir %doc %{_mandir}/man8
%doc COPYING

%files remote
%defattr(755,root,root)
%config(noreplace) %{_sysconfdir}/sysconfig/nightview
%{_sysconfdir}/init.d/nightview-remote
%{_sbindir}/nightview-boa
%{_sbindir}/nightview-thttpd
%{_libdir}/nightview/cgi-bin/nightview.cgi
%dir %{_libdir}/nightview/cgi-bin
%dir %{_libdir}/nightview
%defattr(644,root,root)
%{_datadir}/%{name}/html/index.boa.html
%{_datadir}/%{name}/html/nightview.html
%dir %{_datadir}/%{name}/html
%dir %{_datadir}/%{name}
%doc %{_mandir}/man8/nightview-boa.8*
%doc %{_mandir}/man8/nightview-thttpd.8*
%dir %doc %{_mandir}/man8
%doc COPYING

%files doc
%defattr(644,root,root)
%doc %{ndocdir}/*
%doc %dir %{ndocdir}
%doc %{_mandir}/man1/nightview.*
%dir %doc %{_mandir}/man1

%files -n libccdsbig
%defattr(755,root,root)
%{_libdir}/libccdsbig.so
%{_libdir}/libccdsbig.so.*
%doc COPYING

%files -n libccdsbig-devel
%defattr(644,root,root)
%{_includedir}/ccd.h
%{_includedir}/ccdcommon.h
%{_includedir}/ccdtypes.h
%{_includedir}/rcfile.h
%{_libdir}/libccdsbig.a
%doc COPYING

%files -n libccdnet
%defattr(755,root,root)
%{_libdir}/libccdnet.so
%{_libdir}/libccdnet.so.*
%doc COPYING

%files -n libccdnet-devel
%defattr(644,root,root)
%{_includedir}/com.h
%{_includedir}/commands.h
%{_libdir}/libccdnet.a
%doc COPYING

%files -n mount-server
%defattr(755,root,root)
%config(noreplace) %{_sysconfdir}/sysconfig/nightview
%{_sysconfdir}/init.d/mount-server
%{_sbindir}/telescoped
%doc %{_mandir}/man8/telescoped.8*
%dir %doc %{_mandir}/man8
%doc COPYING

%files -n mount-shell
%defattr(755,root,root)
%{_bindir}/telescope
%doc %{_mandir}/man1/telescope.1*
%dir %doc %{_mandir}/man1
%doc COPYING

%files -n mount-xmove
%{_bindir}/xmove
%{perl_sitearch}/auto/nightview/.packlist
%{_mandir}/man1/xmove.1*
%doc COPYING

#
# $Id: nightview.spec,v 1.5 2003-07-08 15:34:21 hroch Exp $
#
