
/* Command line frontend to night core

   night_filter
   
   controls filter wheel and set a specified filter

   $Id: night_filter.c,v 1.19 2008-01-15 21:48:14 hroch Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <string.h>
#include "nightview.h"
#include "commands.h"
#include "ccdtypes.h"
#include "ccd.h"
#include "ccdcommon.h"

int main(int argc, char *argv[])
{
  int i,l=0,l0=0;
  int list = 0;
  int info = 0;
  int init = 0;
  int prs = 0;
  void show_help(void);
  char *buf = NULL;
  CCD *ccd;
  char *host = NIGHT_LOCALHOST;
  float t;
  char *indicator[] = { "-", "/", "|", "\\" };

  host = getenv(NIGHTVIEW_HOST);
  if( host == NULL )
    host = NIGHT_LOCALHOST;

  if( argc == 1 ) {
    show_help();
    return(0);
  }

  /* processing of command line parameters */
  for( i = 1; i < argc; i++ ) {
    if( (strcmp(argv[i],"-h") == 0) || (strcmp(argv[i],"--help") == 0) ) {
      show_help();
      return(0);
    }
    if( (strcmp(argv[i],"--version") == 0) ) {
      printf("%s\n",COOLVER);
      return(0);
    }

    if( (strcmp(argv[i],"-list") == 0) ) {
      list = 1;
    }

    if( (strcmp(argv[i],"-init") == 0) ) {
      init = 1;
    }

    if( (strcmp(argv[i],"info") == 0) ) {
      info = 1;
    }

    /* progress indicator */
    if( (strcmp(argv[i],"-p") == 0 ) ) {
      prs = 1;
    }

    /* set server address */
    if( strcmp(argv[i],"-host") == 0 && i++ <= argc ) {
      host = argv[i];
    }

  }

  if( (ccd = ccd_init(host)) == NULL) {
    fprintf(stderr,"Connection to %s failed or camera not connected\n",host);
    return(1);
  }

  if( (list == 1) && (buf = filter_list(ccd)) ) {
    fprintf(stdout,"%s\n",buf);
    free(buf);
  }
  else if( init && ! filter_init(ccd) ) {
    fprintf(stderr,"Filter initialisation failed.\n");
    free(buf);
  }

  else if( (info == 1) && (buf = filter_get(ccd)) ) {
    fprintf(stdout,"%s\n",buf);
    free(buf);
  }

  else {
    for( i = 1; i < argc; i++ )

      if( strcmp(argv[i],"-f") == 0 && i++ <= argc ) {

        if( filter_set(ccd, argv[i]) != 1 ) {
          fprintf(stderr,"Filter set failed.\n");
          exit(1);
        }

	if( prs ) {
	  l0 = printf("Setting filter ");
	  l = printf("*");
	}
        for( t = 0.0; filter_status(ccd) == RUN && t < 5.0; t = t + 0.2   ) {
	  if( prs ) {
	    for(i=0; i< l;i++)
	      printf("\b");
	    l = printf(indicator[i%4]);
	    fflush(stdout);
	  }
          usleep(200000);
	}
	if( prs ) {
	  for( i = 0; i < l+l0; i++ )
	    printf("\b");
	}
      }	
  }

  ccd_free(ccd);
  return(0);
}

/*---------------------------------------------------------------------*/

void show_help(void)
{
  printf("%s\n",COOLVER);
  printf("night_filter - select filter or print current one\n");
  printf("Usage: night_filter [-f filter] [-list]\n");
  printf("options:\n");
  printf("\t info print current filter\n");
  printf("\t -f  set filter, one from -list\n");
  printf("\t -list list of defined filters\n");
  printf("\t -init (re)initialize filter wheel\n");
  printf("\t -p    show progress indicator\n");
  printf("\t -host address:port internet address server, default: local connect\n");
  printf("Setting of environment variable %s is equivalent to -host option.\n",
	 NIGHTVIEW_HOST);
  printf("\n");
}
